/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: dr_wlm_info_tPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the dr_wlm_info_tPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=dr_wlm_info_t.class)
public class dr_wlm_info_tPointer extends StructurePointer {

	// NULL
	public static final dr_wlm_info_tPointer NULL = new dr_wlm_info_tPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected dr_wlm_info_tPointer(long address) {
		super(address);
	}

	public static dr_wlm_info_tPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static dr_wlm_info_tPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static dr_wlm_info_tPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new dr_wlm_info_tPointer(address);
	}

	public dr_wlm_info_tPointer add(long count) {
		return dr_wlm_info_tPointer.cast(address + (dr_wlm_info_t.SIZEOF * count));
	}

	public dr_wlm_info_tPointer add(Scalar count) {
		return add(count.longValue());
	}

	public dr_wlm_info_tPointer addOffset(long offset) {
		return dr_wlm_info_tPointer.cast(address + offset);
	}

	public dr_wlm_info_tPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public dr_wlm_info_tPointer sub(long count) {
		return dr_wlm_info_tPointer.cast(address - (dr_wlm_info_t.SIZEOF * count));
	}

	public dr_wlm_info_tPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public dr_wlm_info_tPointer subOffset(long offset) {
		return dr_wlm_info_tPointer.cast(address - offset);
	}

	public dr_wlm_info_tPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public dr_wlm_info_tPointer untag(long mask) {
		return dr_wlm_info_tPointer.cast(address & ~mask);
	}

	public dr_wlm_info_tPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return dr_wlm_info_t.SIZEOF;
	}

	// Implementation methods

	// U32:1 cpu_add
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cpu_addOffset_", declaredType="U32:1")
	public UDATA cpu_add() throws CorruptDataException {
		return getU32Bitfield(dr_wlm_info_t._cpu_add_s_, dr_wlm_info_t._cpu_add_b_);
	}

	// U32:8 cpu_cap
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cpu_capOffset_", declaredType="U32:8")
	public UDATA cpu_cap() throws CorruptDataException {
		return getU32Bitfield(dr_wlm_info_t._cpu_cap_s_, dr_wlm_info_t._cpu_cap_b_);
	}

	// U32:1 cpu_rem
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cpu_remOffset_", declaredType="U32:1")
	public UDATA cpu_rem() throws CorruptDataException {
		return getU32Bitfield(dr_wlm_info_t._cpu_rem_s_, dr_wlm_info_t._cpu_rem_b_);
	}

	// U32:8 cpu_usage
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cpu_usageOffset_", declaredType="U32:8")
	public UDATA cpu_usage() throws CorruptDataException {
		return getU32Bitfield(dr_wlm_info_t._cpu_usage_s_, dr_wlm_info_t._cpu_usage_b_);
	}

	// U32:1 mem_add
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mem_addOffset_", declaredType="U32:1")
	public UDATA mem_add() throws CorruptDataException {
		return getU32Bitfield(dr_wlm_info_t._mem_add_s_, dr_wlm_info_t._mem_add_b_);
	}

	// U32:8 mem_cap
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mem_capOffset_", declaredType="U32:8")
	public UDATA mem_cap() throws CorruptDataException {
		return getU32Bitfield(dr_wlm_info_t._mem_cap_s_, dr_wlm_info_t._mem_cap_b_);
	}

	// U32:1 mem_rem
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mem_remOffset_", declaredType="U32:1")
	public UDATA mem_rem() throws CorruptDataException {
		return getU32Bitfield(dr_wlm_info_t._mem_rem_s_, dr_wlm_info_t._mem_rem_b_);
	}

	// U32:8 mem_usage
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mem_usageOffset_", declaredType="U32:8")
	public UDATA mem_usage() throws CorruptDataException {
		return getU32Bitfield(dr_wlm_info_t._mem_usage_s_, dr_wlm_info_t._mem_usage_b_);
	}

	// U32:10 pad1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pad1Offset_", declaredType="U32:10")
	public UDATA pad1() throws CorruptDataException {
		return getU32Bitfield(dr_wlm_info_t._pad1_s_, dr_wlm_info_t._pad1_b_);
	}

	// U32:16 pad2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pad2Offset_", declaredType="U32:16")
	public UDATA pad2() throws CorruptDataException {
		return getU32Bitfield(dr_wlm_info_t._pad2_s_, dr_wlm_info_t._pad2_b_);
	}

	// U32:1 rs_cpu
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rs_cpuOffset_", declaredType="U32:1")
	public UDATA rs_cpu() throws CorruptDataException {
		return getU32Bitfield(dr_wlm_info_t._rs_cpu_s_, dr_wlm_info_t._rs_cpu_b_);
	}

	// U32:1 rs_mem
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rs_memOffset_", declaredType="U32:1")
	public UDATA rs_mem() throws CorruptDataException {
		return getU32Bitfield(dr_wlm_info_t._rs_mem_s_, dr_wlm_info_t._rs_mem_b_);
	}

}
