/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9SharedCacheAPI
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9SharedCacheAPI {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _cacheDirPermOffset_;
	public static final int _cacheNameOffset_;
	public static final int _cacheTypeOffset_;
	public static final int _ctrlDirNameOffset_;
	public static final int _destroySharedCacheOffset_;
	public static final int _expireTimeOffset_;
	public static final int _inContainerOffset_;
	public static final int _iterateSharedCachesOffset_;
	public static final int _layerOffset_;
	public static final int _maxAOTOffset_;
	public static final int _maxJITOffset_;
	public static final int _methodSpecsOffset_;
	public static final int _minAOTOffset_;
	public static final int _minJITOffset_;
	public static final int _modContextOffset_;
	public static final int _newStartupHintsOffset_;
	public static final int _parseResultOffset_;
	public static final int _printStatsOptionsOffset_;
	public static final int _runtimeFlagsOffset_;
	public static final int _runtimeFlags2Offset_;
	public static final int _sharedCacheEnabledOffset_;
	public static final int _softMaxBytesOffset_;
	public static final int _storageKeyTestingOffset_;
	public static final int _verboseFlagsOffset_;
	public static final int _xShareClassCacheDisabledOnCRIURestoreOffset_;
	public static final int _xShareClassesPresentOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_cacheDirPermOffset_ = 0;
		_cacheNameOffset_ = 0;
		_cacheTypeOffset_ = 0;
		_ctrlDirNameOffset_ = 0;
		_destroySharedCacheOffset_ = 0;
		_expireTimeOffset_ = 0;
		_inContainerOffset_ = 0;
		_iterateSharedCachesOffset_ = 0;
		_layerOffset_ = 0;
		_maxAOTOffset_ = 0;
		_maxJITOffset_ = 0;
		_methodSpecsOffset_ = 0;
		_minAOTOffset_ = 0;
		_minJITOffset_ = 0;
		_modContextOffset_ = 0;
		_newStartupHintsOffset_ = 0;
		_parseResultOffset_ = 0;
		_printStatsOptionsOffset_ = 0;
		_runtimeFlagsOffset_ = 0;
		_runtimeFlags2Offset_ = 0;
		_sharedCacheEnabledOffset_ = 0;
		_softMaxBytesOffset_ = 0;
		_storageKeyTestingOffset_ = 0;
		_verboseFlagsOffset_ = 0;
		_xShareClassCacheDisabledOnCRIURestoreOffset_ = 0;
		_xShareClassesPresentOffset_ = 0;
	}

}
