/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: vminfo_psize
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class vminfo_psize {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _ame_deficit_npgsOffset_;
	public static final int _ame_numframesOffset_;
	public static final int _ame_numfrbOffset_;
	public static final int _attrOffset_;
	public static final int _backtrksOffset_;
	public static final int _cmem_ncomp_opsOffset_;
	public static final int _cmem_ndecomp_opsOffset_;
	public static final int _cmem_tot_csizeOffset_;
	public static final int _cmem_tot_ncpgsOffset_;
	public static final int _cmem_ucpool_sizeOffset_;
	public static final int _cmem_wseg_csizeOffset_;
	public static final int _cmem_wseg_ncpgsOffset_;
	public static final int _cyclesOffset_;
	public static final int _exfillsOffset_;
	public static final int _extendwtsOffset_;
	public static final int _flagsOffset_;
	public static final int _freewtsOffset_;
	public static final int _klock_kstk_stealsOffset_;
	public static final int _klock_pin_npgsOffset_;
	public static final int _klock_pta_stealsOffset_;
	public static final int _klock_tot_npgsOffset_;
	public static final int _klock_tot_stealsOffset_;
	public static final int _lockexctOffset_;
	public static final int _maxfreeOffset_;
	public static final int _memavailableOffset_;
	public static final int _minfreeOffset_;
	public static final int _nonsys_pgsOffset_;
	public static final int _numclientOffset_;
	public static final int _numclsegpinOffset_;
	public static final int _numclseguseOffset_;
	public static final int _numcompressOffset_;
	public static final int _numframesOffset_;
	public static final int _numfrbOffset_;
	public static final int _numiodoneOffset_;
	public static final int _numpermOffset_;
	public static final int _numpermioOffset_;
	public static final int _numpgsp_pgsOffset_;
	public static final int _numpoutOffset_;
	public static final int _numpsegpinOffset_;
	public static final int _numpseguseOffset_;
	public static final int _numrallocOffset_;
	public static final int _numremoteOffset_;
	public static final int _numsiosOffset_;
	public static final int _numvpagesOffset_;
	public static final int _numwsegpinOffset_;
	public static final int _numwseguseOffset_;
	public static final int _pageinsOffset_;
	public static final int _pageoutsOffset_;
	public static final int _pendiowtsOffset_;
	public static final int _pfavailOffset_;
	public static final int _pfpinavailOffset_;
	public static final int _pfrsvdblksOffset_;
	public static final int _pgexctOffset_;
	public static final int _pgrclmOffset_;
	public static final int _pgspginsOffset_;
	public static final int _pgspgoutsOffset_;
	public static final int _pgstealsOffset_;
	public static final int _psizeOffset_;
	public static final int _rpgcntOffset_;
	public static final int _scansOffset_;
	public static final int _soft_clseguseOffset_;
	public static final int _soft_pseguseOffset_;
	public static final int _soft_wseguseOffset_;
	public static final int _system_pgsOffset_;
	public static final int _true_numframesOffset_;
	public static final int _true_numfrbOffset_;
	public static final int _zerofillsOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_ame_deficit_npgsOffset_ = 0;
		_ame_numframesOffset_ = 0;
		_ame_numfrbOffset_ = 0;
		_attrOffset_ = 0;
		_backtrksOffset_ = 0;
		_cmem_ncomp_opsOffset_ = 0;
		_cmem_ndecomp_opsOffset_ = 0;
		_cmem_tot_csizeOffset_ = 0;
		_cmem_tot_ncpgsOffset_ = 0;
		_cmem_ucpool_sizeOffset_ = 0;
		_cmem_wseg_csizeOffset_ = 0;
		_cmem_wseg_ncpgsOffset_ = 0;
		_cyclesOffset_ = 0;
		_exfillsOffset_ = 0;
		_extendwtsOffset_ = 0;
		_flagsOffset_ = 0;
		_freewtsOffset_ = 0;
		_klock_kstk_stealsOffset_ = 0;
		_klock_pin_npgsOffset_ = 0;
		_klock_pta_stealsOffset_ = 0;
		_klock_tot_npgsOffset_ = 0;
		_klock_tot_stealsOffset_ = 0;
		_lockexctOffset_ = 0;
		_maxfreeOffset_ = 0;
		_memavailableOffset_ = 0;
		_minfreeOffset_ = 0;
		_nonsys_pgsOffset_ = 0;
		_numclientOffset_ = 0;
		_numclsegpinOffset_ = 0;
		_numclseguseOffset_ = 0;
		_numcompressOffset_ = 0;
		_numframesOffset_ = 0;
		_numfrbOffset_ = 0;
		_numiodoneOffset_ = 0;
		_numpermOffset_ = 0;
		_numpermioOffset_ = 0;
		_numpgsp_pgsOffset_ = 0;
		_numpoutOffset_ = 0;
		_numpsegpinOffset_ = 0;
		_numpseguseOffset_ = 0;
		_numrallocOffset_ = 0;
		_numremoteOffset_ = 0;
		_numsiosOffset_ = 0;
		_numvpagesOffset_ = 0;
		_numwsegpinOffset_ = 0;
		_numwseguseOffset_ = 0;
		_pageinsOffset_ = 0;
		_pageoutsOffset_ = 0;
		_pendiowtsOffset_ = 0;
		_pfavailOffset_ = 0;
		_pfpinavailOffset_ = 0;
		_pfrsvdblksOffset_ = 0;
		_pgexctOffset_ = 0;
		_pgrclmOffset_ = 0;
		_pgspginsOffset_ = 0;
		_pgspgoutsOffset_ = 0;
		_pgstealsOffset_ = 0;
		_psizeOffset_ = 0;
		_rpgcntOffset_ = 0;
		_scansOffset_ = 0;
		_soft_clseguseOffset_ = 0;
		_soft_pseguseOffset_ = 0;
		_soft_wseguseOffset_ = 0;
		_system_pgsOffset_ = 0;
		_true_numframesOffset_ = 0;
		_true_numfrbOffset_ = 0;
		_zerofillsOffset_ = 0;
	}

}
