/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: __pthrdscontextPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the __pthrdscontextPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=__pthrdscontext.class)
public class __pthrdscontextPointer extends StructurePointer {

	// NULL
	public static final __pthrdscontextPointer NULL = new __pthrdscontextPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected __pthrdscontextPointer(long address) {
		super(address);
	}

	public static __pthrdscontextPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static __pthrdscontextPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static __pthrdscontextPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new __pthrdscontextPointer(address);
	}

	public __pthrdscontextPointer add(long count) {
		return __pthrdscontextPointer.cast(address + (__pthrdscontext.SIZEOF * count));
	}

	public __pthrdscontextPointer add(Scalar count) {
		return add(count.longValue());
	}

	public __pthrdscontextPointer addOffset(long offset) {
		return __pthrdscontextPointer.cast(address + offset);
	}

	public __pthrdscontextPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public __pthrdscontextPointer sub(long count) {
		return __pthrdscontextPointer.cast(address - (__pthrdscontext.SIZEOF * count));
	}

	public __pthrdscontextPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public __pthrdscontextPointer subOffset(long offset) {
		return __pthrdscontextPointer.cast(address - offset);
	}

	public __pthrdscontextPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public __pthrdscontextPointer untag(long mask) {
		return __pthrdscontextPointer.cast(address & ~mask);
	}

	public __pthrdscontextPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return __pthrdscontext.SIZEOF;
	}

	// Implementation methods

	// U32 __pc_cr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pc_crOffset_", declaredType="U32")
	public UDATA __pc_cr() throws CorruptDataException {
		return new U32(getIntAtOffset(__pthrdscontext.___pc_crOffset_));
	}

	// U32 __pc_cr
	public UDATAPointer __pc_crEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__pthrdscontext.___pc_crOffset_));
	}

	// U64 __pc_ctr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pc_ctrOffset_", declaredType="U64")
	public UDATA __pc_ctr() throws CorruptDataException {
		return new U64(getLongAtOffset(__pthrdscontext.___pc_ctrOffset_));
	}

	// U64 __pc_ctr
	public UDATAPointer __pc_ctrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__pthrdscontext.___pc_ctrOffset_));
	}

	// U64[] __pc_except
	public UDATAPointer __pc_exceptEA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(__pthrdscontext.___pc_exceptOffset_));
	}

	// I32 __pc_excp_type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pc_excp_typeOffset_", declaredType="I32")
	public IDATA __pc_excp_type() throws CorruptDataException {
		return new I32(getIntAtOffset(__pthrdscontext.___pc_excp_typeOffset_));
	}

	// I32 __pc_excp_type
	public IDATAPointer __pc_excp_typeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(__pthrdscontext.___pc_excp_typeOffset_));
	}

	// U8 __pc_fpeu
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pc_fpeuOffset_", declaredType="U8")
	public U8 __pc_fpeu() throws CorruptDataException {
		return new U8(getByteAtOffset(__pthrdscontext.___pc_fpeuOffset_));
	}

	// U8 __pc_fpeu
	public U8Pointer __pc_fpeuEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(__pthrdscontext.___pc_fpeuOffset_));
	}

	// U8 __pc_fpinfo
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pc_fpinfoOffset_", declaredType="U8")
	public U8 __pc_fpinfo() throws CorruptDataException {
		return new U8(getByteAtOffset(__pthrdscontext.___pc_fpinfoOffset_));
	}

	// U8 __pc_fpinfo
	public U8Pointer __pc_fpinfoEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(__pthrdscontext.___pc_fpinfoOffset_));
	}

	// double[] __pc_fpr
	public DoublePointer __pc_fprEA() throws CorruptDataException {
		return DoublePointer.cast(nonNullFieldEA(__pthrdscontext.___pc_fprOffset_));
	}

	// U32 __pc_fpscr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pc_fpscrOffset_", declaredType="U32")
	public UDATA __pc_fpscr() throws CorruptDataException {
		return new U32(getIntAtOffset(__pthrdscontext.___pc_fpscrOffset_));
	}

	// U32 __pc_fpscr
	public UDATAPointer __pc_fpscrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__pthrdscontext.___pc_fpscrOffset_));
	}

	// U8 __pc_fpscr24_31
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pc_fpscr24_31Offset_", declaredType="U8")
	public U8 __pc_fpscr24_31() throws CorruptDataException {
		return new U8(getByteAtOffset(__pthrdscontext.___pc_fpscr24_31Offset_));
	}

	// U8 __pc_fpscr24_31
	public U8Pointer __pc_fpscr24_31EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(__pthrdscontext.___pc_fpscr24_31Offset_));
	}

	// U32 __pc_fpscrx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pc_fpscrxOffset_", declaredType="U32")
	public UDATA __pc_fpscrx() throws CorruptDataException {
		return new U32(getIntAtOffset(__pthrdscontext.___pc_fpscrxOffset_));
	}

	// U32 __pc_fpscrx
	public UDATAPointer __pc_fpscrxEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__pthrdscontext.___pc_fpscrxOffset_));
	}

	// U64[] __pc_gpr
	public UDATAPointer __pc_gprEA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(__pthrdscontext.___pc_gprOffset_));
	}

	// U64 __pc_iar
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pc_iarOffset_", declaredType="U64")
	public UDATA __pc_iar() throws CorruptDataException {
		return new U64(getLongAtOffset(__pthrdscontext.___pc_iarOffset_));
	}

	// U64 __pc_iar
	public UDATAPointer __pc_iarEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__pthrdscontext.___pc_iarOffset_));
	}

	// U64 __pc_lr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pc_lrOffset_", declaredType="U64")
	public UDATA __pc_lr() throws CorruptDataException {
		return new U64(getLongAtOffset(__pthrdscontext.___pc_lrOffset_));
	}

	// U64 __pc_lr
	public UDATAPointer __pc_lrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__pthrdscontext.___pc_lrOffset_));
	}

	// U32 __pc_mq
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pc_mqOffset_", declaredType="U32")
	public UDATA __pc_mq() throws CorruptDataException {
		return new U32(getIntAtOffset(__pthrdscontext.___pc_mqOffset_));
	}

	// U32 __pc_mq
	public UDATAPointer __pc_mqEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__pthrdscontext.___pc_mqOffset_));
	}

	// U64 __pc_msr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pc_msrOffset_", declaredType="U64")
	public UDATA __pc_msr() throws CorruptDataException {
		return new U64(getLongAtOffset(__pthrdscontext.___pc_msrOffset_));
	}

	// U64 __pc_msr
	public UDATAPointer __pc_msrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__pthrdscontext.___pc_msrOffset_));
	}

	// U8 __pc_pad
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pc_padOffset_", declaredType="U8")
	public U8 __pc_pad() throws CorruptDataException {
		return new U8(getByteAtOffset(__pthrdscontext.___pc_padOffset_));
	}

	// U8 __pc_pad
	public U8Pointer __pc_padEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(__pthrdscontext.___pc_padOffset_));
	}

	// U32 __pc_xer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pc_xerOffset_", declaredType="U32")
	public UDATA __pc_xer() throws CorruptDataException {
		return new U32(getIntAtOffset(__pthrdscontext.___pc_xerOffset_));
	}

	// U32 __pc_xer
	public UDATAPointer __pc_xerEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__pthrdscontext.___pc_xerOffset_));
	}

}
