/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _system_confPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _system_confPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_system_conf.class)
public class _system_confPointer extends StructurePointer {

	// NULL
	public static final _system_confPointer NULL = new _system_confPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _system_confPointer(long address) {
		super(address);
	}

	public static _system_confPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _system_confPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _system_confPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _system_confPointer(address);
	}

	public _system_confPointer add(long count) {
		return _system_confPointer.cast(address + (_system_conf.SIZEOF * count));
	}

	public _system_confPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _system_confPointer addOffset(long offset) {
		return _system_confPointer.cast(address + offset);
	}

	public _system_confPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _system_confPointer sub(long count) {
		return _system_confPointer.cast(address - (_system_conf.SIZEOF * count));
	}

	public _system_confPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _system_confPointer subOffset(long offset) {
		return _system_confPointer.cast(address - offset);
	}

	public _system_confPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _system_confPointer untag(long mask) {
		return _system_confPointer.cast(address & ~mask);
	}

	public _system_confPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _system_conf.SIZEOF;
	}

	// Implementation methods

	// I32 L2_cache_asc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_L2_cache_ascOffset_", declaredType="I32")
	public IDATA L2_cache_asc() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._L2_cache_ascOffset_));
	}

	// I32 L2_cache_asc
	public IDATAPointer L2_cache_ascEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._L2_cache_ascOffset_));
	}

	// I32 L2_cache_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_L2_cache_sizeOffset_", declaredType="I32")
	public IDATA L2_cache_size() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._L2_cache_sizeOffset_));
	}

	// I32 L2_cache_size
	public IDATAPointer L2_cache_sizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._L2_cache_sizeOffset_));
	}

	// I32 Xfrac
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_XfracOffset_", declaredType="I32")
	public IDATA Xfrac() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._XfracOffset_));
	}

	// I32 Xfrac
	public IDATAPointer XfracEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._XfracOffset_));
	}

	// I32 Xint
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_XintOffset_", declaredType="I32")
	public IDATA Xint() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._XintOffset_));
	}

	// I32 Xint
	public IDATAPointer XintEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._XintOffset_));
	}

	// U8 ame_status
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ame_statusOffset_", declaredType="U8")
	public U8 ame_status() throws CorruptDataException {
		return new U8(getByteAtOffset(_system_conf._ame_statusOffset_));
	}

	// U8 ame_status
	public U8Pointer ame_statusEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_system_conf._ame_statusOffset_));
	}

	// I32 architecture
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_architectureOffset_", declaredType="I32")
	public IDATA architecture() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._architectureOffset_));
	}

	// I32 architecture
	public IDATAPointer architectureEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._architectureOffset_));
	}

	// I32 cach_cong
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cach_congOffset_", declaredType="I32")
	public IDATA cach_cong() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._cach_congOffset_));
	}

	// I32 cach_cong
	public IDATAPointer cach_congEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._cach_congOffset_));
	}

	// I32 cache_attrib
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cache_attribOffset_", declaredType="I32")
	public IDATA cache_attrib() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._cache_attribOffset_));
	}

	// I32 cache_attrib
	public IDATAPointer cache_attribEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._cache_attribOffset_));
	}

	// I32 capacity_increment
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_capacity_incrementOffset_", declaredType="I32")
	public IDATA capacity_increment() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._capacity_incrementOffset_));
	}

	// I32 capacity_increment
	public IDATAPointer capacity_incrementEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._capacity_incrementOffset_));
	}

	// I32 dcache_asc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dcache_ascOffset_", declaredType="I32")
	public IDATA dcache_asc() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._dcache_ascOffset_));
	}

	// I32 dcache_asc
	public IDATAPointer dcache_ascEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._dcache_ascOffset_));
	}

	// I32 dcache_block
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dcache_blockOffset_", declaredType="I32")
	public IDATA dcache_block() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._dcache_blockOffset_));
	}

	// I32 dcache_block
	public IDATAPointer dcache_blockEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._dcache_blockOffset_));
	}

	// I32 dcache_line
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dcache_lineOffset_", declaredType="I32")
	public IDATA dcache_line() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._dcache_lineOffset_));
	}

	// I32 dcache_line
	public IDATAPointer dcache_lineEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._dcache_lineOffset_));
	}

	// I32 dcache_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dcache_sizeOffset_", declaredType="I32")
	public IDATA dcache_size() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._dcache_sizeOffset_));
	}

	// I32 dcache_size
	public IDATAPointer dcache_sizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._dcache_sizeOffset_));
	}

	// I32 dfp_version
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dfp_versionOffset_", declaredType="I32")
	public IDATA dfp_version() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._dfp_versionOffset_));
	}

	// I32 dfp_version
	public IDATAPointer dfp_versionEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._dfp_versionOffset_));
	}

	// I64 dispatch_wheel
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dispatch_wheelOffset_", declaredType="I64")
	public IDATA dispatch_wheel() throws CorruptDataException {
		return new I64(getLongAtOffset(_system_conf._dispatch_wheelOffset_));
	}

	// I64 dispatch_wheel
	public IDATAPointer dispatch_wheelEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._dispatch_wheelOffset_));
	}

	// I32[] donotuse
	public IDATAPointer donotuseEA() throws CorruptDataException {
		return I32Pointer.cast(nonNullFieldEA(_system_conf._donotuseOffset_));
	}

	// I32 dtlb_asc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dtlb_ascOffset_", declaredType="I32")
	public IDATA dtlb_asc() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._dtlb_ascOffset_));
	}

	// I32 dtlb_asc
	public IDATAPointer dtlb_ascEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._dtlb_ascOffset_));
	}

	// I32 dtlb_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dtlb_sizeOffset_", declaredType="I32")
	public IDATA dtlb_size() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._dtlb_sizeOffset_));
	}

	// I32 dtlb_size
	public IDATAPointer dtlb_sizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._dtlb_sizeOffset_));
	}

	// U8 eco_status
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_eco_statusOffset_", declaredType="U8")
	public U8 eco_status() throws CorruptDataException {
		return new U8(getByteAtOffset(_system_conf._eco_statusOffset_));
	}

	// U8 eco_status
	public U8Pointer eco_statusEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_system_conf._eco_statusOffset_));
	}

	// I64 entitled_capacity
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_entitled_capacityOffset_", declaredType="I64")
	public IDATA entitled_capacity() throws CorruptDataException {
		return new I64(getLongAtOffset(_system_conf._entitled_capacityOffset_));
	}

	// I64 entitled_capacity
	public IDATAPointer entitled_capacityEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._entitled_capacityOffset_));
	}

	// I8 errchecklevel
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_errchecklevelOffset_", declaredType="I8")
	public U8 errchecklevel() throws CorruptDataException {
		return new U8(getByteAtOffset(_system_conf._errchecklevelOffset_));
	}

	// I8 errchecklevel
	public U8Pointer errchecklevelEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_system_conf._errchecklevelOffset_));
	}

	// I32 gencount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_gencountOffset_", declaredType="I32")
	public IDATA gencount() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._gencountOffset_));
	}

	// I32 gencount
	public IDATAPointer gencountEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._gencountOffset_));
	}

	// I32 icache_asc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_icache_ascOffset_", declaredType="I32")
	public IDATA icache_asc() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._icache_ascOffset_));
	}

	// I32 icache_asc
	public IDATAPointer icache_ascEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._icache_ascOffset_));
	}

	// I32 icache_block
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_icache_blockOffset_", declaredType="I32")
	public IDATA icache_block() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._icache_blockOffset_));
	}

	// I32 icache_block
	public IDATAPointer icache_blockEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._icache_blockOffset_));
	}

	// I32 icache_line
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_icache_lineOffset_", declaredType="I32")
	public IDATA icache_line() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._icache_lineOffset_));
	}

	// I32 icache_line
	public IDATAPointer icache_lineEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._icache_lineOffset_));
	}

	// I32 icache_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_icache_sizeOffset_", declaredType="I32")
	public IDATA icache_size() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._icache_sizeOffset_));
	}

	// I32 icache_size
	public IDATAPointer icache_sizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._icache_sizeOffset_));
	}

	// I32 implementation
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_implementationOffset_", declaredType="I32")
	public IDATA implementation() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._implementationOffset_));
	}

	// I32 implementation
	public IDATAPointer implementationEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._implementationOffset_));
	}

	// I32 itlb_asc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_itlb_ascOffset_", declaredType="I32")
	public IDATA itlb_asc() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._itlb_ascOffset_));
	}

	// I32 itlb_asc
	public IDATAPointer itlb_ascEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._itlb_ascOffset_));
	}

	// I32 itlb_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_itlb_sizeOffset_", declaredType="I32")
	public IDATA itlb_size() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._itlb_sizeOffset_));
	}

	// I32 itlb_size
	public IDATAPointer itlb_sizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._itlb_sizeOffset_));
	}

	// I32 kernel
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_kernelOffset_", declaredType="I32")
	public IDATA kernel() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._kernelOffset_));
	}

	// I32 kernel
	public IDATAPointer kernelEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._kernelOffset_));
	}

	// I32 max_ncpus
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_max_ncpusOffset_", declaredType="I32")
	public IDATA max_ncpus() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._max_ncpusOffset_));
	}

	// I32 max_ncpus
	public IDATAPointer max_ncpusEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._max_ncpusOffset_));
	}

	// I64 maxrealaddr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_maxrealaddrOffset_", declaredType="I64")
	public IDATA maxrealaddr() throws CorruptDataException {
		return new I64(getLongAtOffset(_system_conf._maxrealaddrOffset_));
	}

	// I64 maxrealaddr
	public IDATAPointer maxrealaddrEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._maxrealaddrOffset_));
	}

	// I32 model_arch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_model_archOffset_", declaredType="I32")
	public IDATA model_arch() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._model_archOffset_));
	}

	// I32 model_arch
	public IDATAPointer model_archEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._model_archOffset_));
	}

	// I32 model_impl
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_model_implOffset_", declaredType="I32")
	public IDATA model_impl() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._model_implOffset_));
	}

	// I32 model_impl
	public IDATAPointer model_implEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._model_implOffset_));
	}

	// I32 ncpus
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ncpusOffset_", declaredType="I32")
	public IDATA ncpus() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._ncpusOffset_));
	}

	// I32 ncpus
	public IDATAPointer ncpusEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._ncpusOffset_));
	}

	// I32 num_xcpus
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_num_xcpusOffset_", declaredType="I32")
	public IDATA num_xcpus() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._num_xcpusOffset_));
	}

	// I32 num_xcpus
	public IDATAPointer num_xcpusEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._num_xcpusOffset_));
	}

	// I64 original_entitled_capacity
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_original_entitled_capacityOffset_", declaredType="I64")
	public IDATA original_entitled_capacity() throws CorruptDataException {
		return new I64(getLongAtOffset(_system_conf._original_entitled_capacityOffset_));
	}

	// I64 original_entitled_capacity
	public IDATAPointer original_entitled_capacityEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._original_entitled_capacityOffset_));
	}

	// I32 original_ncpus
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_original_ncpusOffset_", declaredType="I32")
	public IDATA original_ncpus() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._original_ncpusOffset_));
	}

	// I32 original_ncpus
	public IDATAPointer original_ncpusEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._original_ncpusOffset_));
	}

	// U8 pad
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_padOffset_", declaredType="U8")
	public U8 pad() throws CorruptDataException {
		return new U8(getByteAtOffset(_system_conf._padOffset_));
	}

	// U8 pad
	public U8Pointer padEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_system_conf._padOffset_));
	}

	// I16 phys_implementation
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_phys_implementationOffset_", declaredType="I16")
	public I16 phys_implementation() throws CorruptDataException {
		return new I16(getShortAtOffset(_system_conf._phys_implementationOffset_));
	}

	// I16 phys_implementation
	public I16Pointer phys_implementationEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(_system_conf._phys_implementationOffset_));
	}

	// I16 phys_version
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_phys_versionOffset_", declaredType="I16")
	public I16 phys_version() throws CorruptDataException {
		return new I16(getShortAtOffset(_system_conf._phys_versionOffset_));
	}

	// I16 phys_version
	public I16Pointer phys_versionEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(_system_conf._phys_versionOffset_));
	}

	// I64 physmem
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_physmemOffset_", declaredType="I64")
	public IDATA physmem() throws CorruptDataException {
		return new I64(getLongAtOffset(_system_conf._physmemOffset_));
	}

	// I64 physmem
	public IDATAPointer physmemEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._physmemOffset_));
	}

	// I32 priv_lck_cnt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_priv_lck_cntOffset_", declaredType="I32")
	public IDATA priv_lck_cnt() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._priv_lck_cntOffset_));
	}

	// I32 priv_lck_cnt
	public IDATAPointer priv_lck_cntEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._priv_lck_cntOffset_));
	}

	// I32 prob_lck_cnt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_prob_lck_cntOffset_", declaredType="I32")
	public IDATA prob_lck_cnt() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._prob_lck_cntOffset_));
	}

	// I32 prob_lck_cnt
	public IDATAPointer prob_lck_cntEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._prob_lck_cntOffset_));
	}

	// I32 resv_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_resv_sizeOffset_", declaredType="I32")
	public IDATA resv_size() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._resv_sizeOffset_));
	}

	// I32 resv_size
	public IDATAPointer resv_sizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._resv_sizeOffset_));
	}

	// I32 rtc_type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rtc_typeOffset_", declaredType="I32")
	public IDATA rtc_type() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._rtc_typeOffset_));
	}

	// I32 rtc_type
	public IDATAPointer rtc_typeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._rtc_typeOffset_));
	}

	// I32 slb_attr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_slb_attrOffset_", declaredType="I32")
	public IDATA slb_attr() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._slb_attrOffset_));
	}

	// I32 slb_attr
	public IDATAPointer slb_attrEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._slb_attrOffset_));
	}

	// I32 slb_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_slb_sizeOffset_", declaredType="I32")
	public IDATA slb_size() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._slb_sizeOffset_));
	}

	// I32 slb_size
	public IDATAPointer slb_sizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._slb_sizeOffset_));
	}

	// I32 smt_status
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_smt_statusOffset_", declaredType="I32")
	public IDATA smt_status() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._smt_statusOffset_));
	}

	// I32 smt_status
	public IDATAPointer smt_statusEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._smt_statusOffset_));
	}

	// I32 smt_threads
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_smt_threadsOffset_", declaredType="I32")
	public IDATA smt_threads() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._smt_threadsOffset_));
	}

	// I32 smt_threads
	public IDATAPointer smt_threadsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._smt_threadsOffset_));
	}

	// I32 splpar_status
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_splpar_statusOffset_", declaredType="I32")
	public IDATA splpar_status() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._splpar_statusOffset_));
	}

	// I32 splpar_status
	public IDATAPointer splpar_statusEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._splpar_statusOffset_));
	}

	// I64 sys_lmbsize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sys_lmbsizeOffset_", declaredType="I64")
	public IDATA sys_lmbsize() throws CorruptDataException {
		return new I64(getLongAtOffset(_system_conf._sys_lmbsizeOffset_));
	}

	// I64 sys_lmbsize
	public IDATAPointer sys_lmbsizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._sys_lmbsizeOffset_));
	}

	// I32 tlb_attrib
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tlb_attribOffset_", declaredType="I32")
	public IDATA tlb_attrib() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._tlb_attribOffset_));
	}

	// I32 tlb_attrib
	public IDATAPointer tlb_attribEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._tlb_attribOffset_));
	}

	// I32 variable_capacity_weight
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_variable_capacity_weightOffset_", declaredType="I32")
	public IDATA variable_capacity_weight() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._variable_capacity_weightOffset_));
	}

	// I32 variable_capacity_weight
	public IDATAPointer variable_capacity_weightEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._variable_capacity_weightOffset_));
	}

	// I32 version
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_versionOffset_", declaredType="I32")
	public IDATA version() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._versionOffset_));
	}

	// I32 version
	public IDATAPointer versionEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._versionOffset_));
	}

	// I32 virt_alias
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_virt_aliasOffset_", declaredType="I32")
	public IDATA virt_alias() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._virt_aliasOffset_));
	}

	// I32 virt_alias
	public IDATAPointer virt_aliasEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._virt_aliasOffset_));
	}

	// I32 vmx_version
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vmx_versionOffset_", declaredType="I32")
	public IDATA vmx_version() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._vmx_versionOffset_));
	}

	// I32 vmx_version
	public IDATAPointer vmx_versionEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._vmx_versionOffset_));
	}

	// I32 vrm_status
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vrm_statusOffset_", declaredType="I32")
	public IDATA vrm_status() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._vrm_statusOffset_));
	}

	// I32 vrm_status
	public IDATAPointer vrm_statusEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._vrm_statusOffset_));
	}

	// I32 width
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_widthOffset_", declaredType="I32")
	public IDATA width() throws CorruptDataException {
		return new I32(getIntAtOffset(_system_conf._widthOffset_));
	}

	// I32 width
	public IDATAPointer widthEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_system_conf._widthOffset_));
	}

}
