/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_ReclaimDelegate
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_ReclaimDelegate {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __collectionSetDelegateOffset_;
	public static final int __compactGroupMaxCountOffset_;
	public static final int __compactGroupsOffset_;
	public static final int __compactRateOfReturnOffset_;
	public static final int __currentSortedRegionCountOffset_;
	public static final int __dispatcherOffset_;
	public static final int __regionManagerOffset_;
	public static final int __regionSortedByCompactScoreOffset_;
	public static final int __regionsSortedByEmptinessArrayOffset_;
	public static final int __regionsSortedByEmptinessArraySizeOffset_;
	public static final int __sweepSchemeOffset_;
	public static final int __writeOnceCompactorOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__collectionSetDelegateOffset_ = 0;
		__compactGroupMaxCountOffset_ = 0;
		__compactGroupsOffset_ = 0;
		__compactRateOfReturnOffset_ = 0;
		__currentSortedRegionCountOffset_ = 0;
		__dispatcherOffset_ = 0;
		__regionManagerOffset_ = 0;
		__regionSortedByCompactScoreOffset_ = 0;
		__regionsSortedByEmptinessArrayOffset_ = 0;
		__regionsSortedByEmptinessArraySizeOffset_ = 0;
		__sweepSchemeOffset_ = 0;
		__writeOnceCompactorOffset_ = 0;
	}

}
