/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9InternalVMLabels
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9InternalVMLabels {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _VMprJavaSendNativeOffset_;
	public static final int _cInterpreterOffset_;
	public static final int _executeCurrentBytecodeOffset_;
	public static final int _handlePopFramesOffset_;
	public static final int _javaCheckAsyncEventsOffset_;
	public static final int _javaStackOverflowOffset_;
	public static final int _runJNIHandlerOffset_;
	public static final int _runJavaHandlerOffset_;
	public static final int _runMethodOffset_;
	public static final int _runMethodHandleOffset_;
	public static final int _runMethodInterpretedOffset_;
	public static final int _throwCurrentExceptionOffset_;
	public static final int _throwExceptionOffset_;
	public static final int _throwExceptionNLSOffset_;
	public static final int _throwHeapOutOfMemoryErrorOffset_;
	public static final int _throwNativeOutOfMemoryErrorOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_VMprJavaSendNativeOffset_ = 0;
		_cInterpreterOffset_ = 0;
		_executeCurrentBytecodeOffset_ = 0;
		_handlePopFramesOffset_ = 0;
		_javaCheckAsyncEventsOffset_ = 0;
		_javaStackOverflowOffset_ = 0;
		_runJNIHandlerOffset_ = 0;
		_runJavaHandlerOffset_ = 0;
		_runMethodOffset_ = 0;
		_runMethodHandleOffset_ = 0;
		_runMethodInterpretedOffset_ = 0;
		_throwCurrentExceptionOffset_ = 0;
		_throwExceptionOffset_ = 0;
		_throwExceptionNLSOffset_ = 0;
		_throwHeapOutOfMemoryErrorOffset_ = 0;
		_throwNativeOutOfMemoryErrorOffset_ = 0;
	}

}
