/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: tbtable_extPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the tbtable_extPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=tbtable_ext.class)
public class tbtable_extPointer extends StructurePointer {

	// NULL
	public static final tbtable_extPointer NULL = new tbtable_extPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected tbtable_extPointer(long address) {
		super(address);
	}

	public static tbtable_extPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static tbtable_extPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static tbtable_extPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new tbtable_extPointer(address);
	}

	public tbtable_extPointer add(long count) {
		return tbtable_extPointer.cast(address + (tbtable_ext.SIZEOF * count));
	}

	public tbtable_extPointer add(Scalar count) {
		return add(count.longValue());
	}

	public tbtable_extPointer addOffset(long offset) {
		return tbtable_extPointer.cast(address + offset);
	}

	public tbtable_extPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public tbtable_extPointer sub(long count) {
		return tbtable_extPointer.cast(address - (tbtable_ext.SIZEOF * count));
	}

	public tbtable_extPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public tbtable_extPointer subOffset(long offset) {
		return tbtable_extPointer.cast(address - offset);
	}

	public tbtable_extPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public tbtable_extPointer untag(long mask) {
		return tbtable_extPointer.cast(address & ~mask);
	}

	public tbtable_extPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return tbtable_ext.SIZEOF;
	}

	// Implementation methods

	// U8 alloca_reg
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_alloca_regOffset_", declaredType="U8")
	public U8 alloca_reg() throws CorruptDataException {
		return new U8(getByteAtOffset(tbtable_ext._alloca_regOffset_));
	}

	// U8 alloca_reg
	public U8Pointer alloca_regEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(tbtable_ext._alloca_regOffset_));
	}

	// I32 ctl_info
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ctl_infoOffset_", declaredType="I32")
	public IDATA ctl_info() throws CorruptDataException {
		return new I32(getIntAtOffset(tbtable_ext._ctl_infoOffset_));
	}

	// I32 ctl_info
	public IDATAPointer ctl_infoEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(tbtable_ext._ctl_infoOffset_));
	}

	// I32[] ctl_info_disp
	public IDATAPointer ctl_info_dispEA() throws CorruptDataException {
		return I32Pointer.cast(nonNullFieldEA(tbtable_ext._ctl_info_dispOffset_));
	}

	// U32[] eh_info_disp
	public UDATAPointer eh_info_dispEA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(tbtable_ext._eh_info_dispOffset_));
	}

	// I32 hand_mask
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hand_maskOffset_", declaredType="I32")
	public IDATA hand_mask() throws CorruptDataException {
		return new I32(getIntAtOffset(tbtable_ext._hand_maskOffset_));
	}

	// I32 hand_mask
	public IDATAPointer hand_maskEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(tbtable_ext._hand_maskOffset_));
	}

	// U8[] name
	public U8Pointer nameEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(tbtable_ext._nameOffset_));
	}

	// I16 name_len
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_name_lenOffset_", declaredType="I16")
	public I16 name_len() throws CorruptDataException {
		return new I16(getShortAtOffset(tbtable_ext._name_lenOffset_));
	}

	// I16 name_len
	public I16Pointer name_lenEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(tbtable_ext._name_lenOffset_));
	}

	// U32 parminfo
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_parminfoOffset_", declaredType="U32")
	public UDATA parminfo() throws CorruptDataException {
		return new U32(getIntAtOffset(tbtable_ext._parminfoOffset_));
	}

	// U32 parminfo
	public UDATAPointer parminfoEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tbtable_ext._parminfoOffset_));
	}

	// U32 tb_offset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tb_offsetOffset_", declaredType="U32")
	public UDATA tb_offset() throws CorruptDataException {
		return new U32(getIntAtOffset(tbtable_ext._tb_offsetOffset_));
	}

	// U32 tb_offset
	public UDATAPointer tb_offsetEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tbtable_ext._tb_offsetOffset_));
	}

	// vec_ext vec_ext
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vec_extOffset_", declaredType="vec_ext")
	public vec_extPointer vec_ext() throws CorruptDataException {
		return vec_extPointer.cast(nonNullFieldEA(tbtable_ext._vec_extOffset_));
	}

	// vec_ext vec_ext
	public PointerPointer vec_extEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tbtable_ext._vec_extOffset_));
	}

	// U8 xtbtable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_xtbtableOffset_", declaredType="U8")
	public U8 xtbtable() throws CorruptDataException {
		return new U8(getByteAtOffset(tbtable_ext._xtbtableOffset_));
	}

	// U8 xtbtable
	public U8Pointer xtbtableEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(tbtable_ext._xtbtableOffset_));
	}

}
