/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_AllocationContextBalanced
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_AllocationContextBalanced {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __allocationRegionOffset_;
	public static final int __arrayReservedRegionCountOffset_;
	public static final int __arrayReservedRegionListOffset_;
	public static final int __cachedReplenishPointOffset_;
	public static final int __contextLockOffset_;
	public static final int __discardRegionListOffset_;
	public static final int __flushedRegionsOffset_;
	public static final int __freeListLockOffset_;
	public static final int __freeMemorySizeOffset_;
	public static final int __freeProcessorNodeCountOffset_;
	public static final int __freeProcessorNodesOffset_;
	public static final int __freeRegionsOffset_;
	public static final int __heapRegionManagerOffset_;
	public static final int __idleMPRegionsOffset_;
	public static final int __nextSiblingOffset_;
	public static final int __nextToStealOffset_;
	public static final int __nonFullRegionsOffset_;
	public static final int __numaNodeOffset_;
	public static final int __regionCountOffset_;
	public static final int __sharedArrayReservedRegionsBytesUsedOffset_;
	public static final int __stealingCousinOffset_;
	public static final int __subspaceOffset_;
	public static final int __threadCountOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__allocationRegionOffset_ = 0;
		__arrayReservedRegionCountOffset_ = 0;
		__arrayReservedRegionListOffset_ = 0;
		__cachedReplenishPointOffset_ = 0;
		__contextLockOffset_ = 0;
		__discardRegionListOffset_ = 0;
		__flushedRegionsOffset_ = 0;
		__freeListLockOffset_ = 0;
		__freeMemorySizeOffset_ = 0;
		__freeProcessorNodeCountOffset_ = 0;
		__freeProcessorNodesOffset_ = 0;
		__freeRegionsOffset_ = 0;
		__heapRegionManagerOffset_ = 0;
		__idleMPRegionsOffset_ = 0;
		__nextSiblingOffset_ = 0;
		__nextToStealOffset_ = 0;
		__nonFullRegionsOffset_ = 0;
		__numaNodeOffset_ = 0;
		__regionCountOffset_ = 0;
		__sharedArrayReservedRegionsBytesUsedOffset_ = 0;
		__stealingCousinOffset_ = 0;
		__subspaceOffset_ = 0;
		__threadCountOffset_ = 0;
	}

}
