/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: StackIteratorData4RealtimeMarkingSchemePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the StackIteratorData4RealtimeMarkingSchemePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=StackIteratorData4RealtimeMarkingScheme.class)
public class StackIteratorData4RealtimeMarkingSchemePointer extends StructurePointer {

	// NULL
	public static final StackIteratorData4RealtimeMarkingSchemePointer NULL = new StackIteratorData4RealtimeMarkingSchemePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected StackIteratorData4RealtimeMarkingSchemePointer(long address) {
		super(address);
	}

	public static StackIteratorData4RealtimeMarkingSchemePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static StackIteratorData4RealtimeMarkingSchemePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static StackIteratorData4RealtimeMarkingSchemePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new StackIteratorData4RealtimeMarkingSchemePointer(address);
	}

	public StackIteratorData4RealtimeMarkingSchemePointer add(long count) {
		return StackIteratorData4RealtimeMarkingSchemePointer.cast(address + (StackIteratorData4RealtimeMarkingScheme.SIZEOF * count));
	}

	public StackIteratorData4RealtimeMarkingSchemePointer add(Scalar count) {
		return add(count.longValue());
	}

	public StackIteratorData4RealtimeMarkingSchemePointer addOffset(long offset) {
		return StackIteratorData4RealtimeMarkingSchemePointer.cast(address + offset);
	}

	public StackIteratorData4RealtimeMarkingSchemePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public StackIteratorData4RealtimeMarkingSchemePointer sub(long count) {
		return StackIteratorData4RealtimeMarkingSchemePointer.cast(address - (StackIteratorData4RealtimeMarkingScheme.SIZEOF * count));
	}

	public StackIteratorData4RealtimeMarkingSchemePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public StackIteratorData4RealtimeMarkingSchemePointer subOffset(long offset) {
		return StackIteratorData4RealtimeMarkingSchemePointer.cast(address - offset);
	}

	public StackIteratorData4RealtimeMarkingSchemePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public StackIteratorData4RealtimeMarkingSchemePointer untag(long mask) {
		return StackIteratorData4RealtimeMarkingSchemePointer.cast(address & ~mask);
	}

	public StackIteratorData4RealtimeMarkingSchemePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return StackIteratorData4RealtimeMarkingScheme.SIZEOF;
	}

	// Implementation methods

	// MM_EnvironmentRealtime* env
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_envOffset_", declaredType="MM_EnvironmentRealtime*")
	public MM_EnvironmentRealtimePointer env() throws CorruptDataException {
		return MM_EnvironmentRealtimePointer.cast(getPointerAtOffset(StackIteratorData4RealtimeMarkingScheme._envOffset_));
	}

	// MM_EnvironmentRealtime* env
	public PointerPointer envEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(StackIteratorData4RealtimeMarkingScheme._envOffset_));
	}

	// J9Object* fromObject
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fromObjectOffset_", declaredType="J9Object*")
	public J9ObjectPointer fromObject() throws CorruptDataException {
		return J9ObjectPointer.cast(getPointerAtOffset(StackIteratorData4RealtimeMarkingScheme._fromObjectOffset_));
	}

	// J9Object* fromObject
	public PointerPointer fromObjectEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(StackIteratorData4RealtimeMarkingScheme._fromObjectOffset_));
	}

	// MM_MetronomeDelegate* metronomeDelegate
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_metronomeDelegateOffset_", declaredType="MM_MetronomeDelegate*")
	public MM_MetronomeDelegatePointer metronomeDelegate() throws CorruptDataException {
		return MM_MetronomeDelegatePointer.cast(getPointerAtOffset(StackIteratorData4RealtimeMarkingScheme._metronomeDelegateOffset_));
	}

	// MM_MetronomeDelegate* metronomeDelegate
	public PointerPointer metronomeDelegateEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(StackIteratorData4RealtimeMarkingScheme._metronomeDelegateOffset_));
	}

}
