/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: JVMInformationEntryPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the JVMInformationEntryPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=JVMInformationEntry.class)
public class JVMInformationEntryPointer extends StructurePointer {

	// NULL
	public static final JVMInformationEntryPointer NULL = new JVMInformationEntryPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected JVMInformationEntryPointer(long address) {
		super(address);
	}

	public static JVMInformationEntryPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static JVMInformationEntryPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static JVMInformationEntryPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new JVMInformationEntryPointer(address);
	}

	public JVMInformationEntryPointer add(long count) {
		return JVMInformationEntryPointer.cast(address + (JVMInformationEntry.SIZEOF * count));
	}

	public JVMInformationEntryPointer add(Scalar count) {
		return add(count.longValue());
	}

	public JVMInformationEntryPointer addOffset(long offset) {
		return JVMInformationEntryPointer.cast(address + offset);
	}

	public JVMInformationEntryPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public JVMInformationEntryPointer sub(long count) {
		return JVMInformationEntryPointer.cast(address - (JVMInformationEntry.SIZEOF * count));
	}

	public JVMInformationEntryPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public JVMInformationEntryPointer subOffset(long offset) {
		return JVMInformationEntryPointer.cast(address - offset);
	}

	public JVMInformationEntryPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public JVMInformationEntryPointer untag(long mask) {
		return JVMInformationEntryPointer.cast(address & ~mask);
	}

	public JVMInformationEntryPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return JVMInformationEntry.SIZEOF;
	}

	// Implementation methods

	// const U8* javaArguments
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_javaArgumentsOffset_", declaredType="const U8*")
	public U8Pointer javaArguments() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(JVMInformationEntry._javaArgumentsOffset_));
	}

	// const U8* javaArguments
	public PointerPointer javaArgumentsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(JVMInformationEntry._javaArgumentsOffset_));
	}

	// U8* jvmArguments
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_jvmArgumentsOffset_", declaredType="U8*")
	public U8Pointer jvmArguments() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(JVMInformationEntry._jvmArgumentsOffset_));
	}

	// U8* jvmArguments
	public PointerPointer jvmArgumentsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(JVMInformationEntry._jvmArgumentsOffset_));
	}

	// const U8* jvmFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_jvmFlagsOffset_", declaredType="const U8*")
	public U8Pointer jvmFlags() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(JVMInformationEntry._jvmFlagsOffset_));
	}

	// const U8* jvmFlags
	public PointerPointer jvmFlagsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(JVMInformationEntry._jvmFlagsOffset_));
	}

	// const U8* jvmName
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_jvmNameOffset_", declaredType="const U8*")
	public U8Pointer jvmName() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(JVMInformationEntry._jvmNameOffset_));
	}

	// const U8* jvmName
	public PointerPointer jvmNameEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(JVMInformationEntry._jvmNameOffset_));
	}

	// I64 jvmStartTime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_jvmStartTimeOffset_", declaredType="I64")
	public IDATA jvmStartTime() throws CorruptDataException {
		return new I64(getLongAtOffset(JVMInformationEntry._jvmStartTimeOffset_));
	}

	// I64 jvmStartTime
	public IDATAPointer jvmStartTimeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(JVMInformationEntry._jvmStartTimeOffset_));
	}

	// const U8* jvmVersion
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_jvmVersionOffset_", declaredType="const U8*")
	public U8Pointer jvmVersion() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(JVMInformationEntry._jvmVersionOffset_));
	}

	// const U8* jvmVersion
	public PointerPointer jvmVersionEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(JVMInformationEntry._jvmVersionOffset_));
	}

	// I64 pid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pidOffset_", declaredType="I64")
	public IDATA pid() throws CorruptDataException {
		return new I64(getLongAtOffset(JVMInformationEntry._pidOffset_));
	}

	// I64 pid
	public IDATAPointer pidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(JVMInformationEntry._pidOffset_));
	}

}
