/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9CRIUCheckpointState
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9CRIUCheckpointState {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _checkpointCPUCountOffset_;
	public static final int _checkpointRestoreTimeDeltaOffset_;
	public static final int _checkpointThreadOffset_;
	public static final int _classIterationRestoreHookRecordsOffset_;
	public static final int _cracCheckpointToDirOffset_;
	public static final int _criuDumpFunctionPointerTypeOffset_;
	public static final int _criuInitOptsFunctionPointerTypeOffset_;
	public static final int _criuJVMCheckpointExceptionClassOffset_;
	public static final int _criuJVMCheckpointExceptionInitOffset_;
	public static final int _criuJVMRestoreExceptionClassOffset_;
	public static final int _criuJVMRestoreExceptionInitOffset_;
	public static final int _criuSetAutoDedupFunctionPointerTypeOffset_;
	public static final int _criuSetExtUnixSkFunctionPointerTypeOffset_;
	public static final int _criuSetFileLocksFunctionPointerTypeOffset_;
	public static final int _criuSetGhostFileLimitFunctionPointerTypeOffset_;
	public static final int _criuSetImagesDirFdFunctionPointerTypeOffset_;
	public static final int _criuSetLeaveRunningFunctionPointerTypeOffset_;
	public static final int _criuSetLogFileFunctionPointerTypeOffset_;
	public static final int _criuSetLogLevelFunctionPointerTypeOffset_;
	public static final int _criuSetShellJobFunctionPointerTypeOffset_;
	public static final int _criuSetTcpCloseFunctionPointerTypeOffset_;
	public static final int _criuSetTcpEstablishedFunctionPointerTypeOffset_;
	public static final int _criuSetTcpTcpSkipInFlightFunctionPointerTypeOffset_;
	public static final int _criuSetTrackMemFunctionPointerTypeOffset_;
	public static final int _criuSetUnprivilegedFunctionPointerTypeOffset_;
	public static final int _criuSetWorkDirFdFunctionPointerTypeOffset_;
	public static final int _criuSystemCheckpointExceptionClassOffset_;
	public static final int _criuSystemCheckpointExceptionInitOffset_;
	public static final int _criuSystemRestoreExceptionClassOffset_;
	public static final int _criuSystemRestoreExceptionInitOffset_;
	public static final int _delayedLockingOperationsRecordsOffset_;
	public static final int _delayedLockingOperationsRootOffset_;
	public static final int _flagsOffset_;
	public static final int _hookRecordsOffset_;
	public static final int _isDebugOnRestoreEnabledOffset_;
	public static final int _javaDebugThreadCountOffset_;
	public static final int _javaDebugThreadsOffset_;
	public static final int _jucForkJoinPoolParallelismOffsetOffset_;
	public static final int _jvmtienvOffset_;
	public static final int _lastRestoreTimeInNanosecondsOffset_;
	public static final int _libCRIUHandleOffset_;
	public static final int _maxRetryForNotCheckpointSafeOffset_;
	public static final int _processRestoreStartTimeInNanosecondsOffset_;
	public static final int _requiredCapabilitiesOffset_;
	public static final int _requiredGhostFileLimitOffset_;
	public static final int _restoreArgsCharsOffset_;
	public static final int _restoreArgsListOffset_;
	public static final int _sleepMillisecondsForNotCheckpointSafeOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_checkpointCPUCountOffset_ = 0;
		_checkpointRestoreTimeDeltaOffset_ = 0;
		_checkpointThreadOffset_ = 0;
		_classIterationRestoreHookRecordsOffset_ = 0;
		_cracCheckpointToDirOffset_ = 0;
		_criuDumpFunctionPointerTypeOffset_ = 0;
		_criuInitOptsFunctionPointerTypeOffset_ = 0;
		_criuJVMCheckpointExceptionClassOffset_ = 0;
		_criuJVMCheckpointExceptionInitOffset_ = 0;
		_criuJVMRestoreExceptionClassOffset_ = 0;
		_criuJVMRestoreExceptionInitOffset_ = 0;
		_criuSetAutoDedupFunctionPointerTypeOffset_ = 0;
		_criuSetExtUnixSkFunctionPointerTypeOffset_ = 0;
		_criuSetFileLocksFunctionPointerTypeOffset_ = 0;
		_criuSetGhostFileLimitFunctionPointerTypeOffset_ = 0;
		_criuSetImagesDirFdFunctionPointerTypeOffset_ = 0;
		_criuSetLeaveRunningFunctionPointerTypeOffset_ = 0;
		_criuSetLogFileFunctionPointerTypeOffset_ = 0;
		_criuSetLogLevelFunctionPointerTypeOffset_ = 0;
		_criuSetShellJobFunctionPointerTypeOffset_ = 0;
		_criuSetTcpCloseFunctionPointerTypeOffset_ = 0;
		_criuSetTcpEstablishedFunctionPointerTypeOffset_ = 0;
		_criuSetTcpTcpSkipInFlightFunctionPointerTypeOffset_ = 0;
		_criuSetTrackMemFunctionPointerTypeOffset_ = 0;
		_criuSetUnprivilegedFunctionPointerTypeOffset_ = 0;
		_criuSetWorkDirFdFunctionPointerTypeOffset_ = 0;
		_criuSystemCheckpointExceptionClassOffset_ = 0;
		_criuSystemCheckpointExceptionInitOffset_ = 0;
		_criuSystemRestoreExceptionClassOffset_ = 0;
		_criuSystemRestoreExceptionInitOffset_ = 0;
		_delayedLockingOperationsRecordsOffset_ = 0;
		_delayedLockingOperationsRootOffset_ = 0;
		_flagsOffset_ = 0;
		_hookRecordsOffset_ = 0;
		_isDebugOnRestoreEnabledOffset_ = 0;
		_javaDebugThreadCountOffset_ = 0;
		_javaDebugThreadsOffset_ = 0;
		_jucForkJoinPoolParallelismOffsetOffset_ = 0;
		_jvmtienvOffset_ = 0;
		_lastRestoreTimeInNanosecondsOffset_ = 0;
		_libCRIUHandleOffset_ = 0;
		_maxRetryForNotCheckpointSafeOffset_ = 0;
		_processRestoreStartTimeInNanosecondsOffset_ = 0;
		_requiredCapabilitiesOffset_ = 0;
		_requiredGhostFileLimitOffset_ = 0;
		_restoreArgsCharsOffset_ = 0;
		_restoreArgsListOffset_ = 0;
		_sleepMillisecondsForNotCheckpointSafeOffset_ = 0;
	}

}
