/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_haw extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_DK = "Kenemaka";
        final String metaValue_DE = "Kelem\u0101nia";
        final String metaValue_GR = "Helene";
        final String metaValue_FR = "Palani";
        final String metaValue_IT = "\u02bb\u012ak\u0101lia";
        final String metaValue_NL = "H\u014dlani";
        final String metaValue_RU = "L\u016bkia";
        final Object[][] data = new Object[][] {
            { "AU", "N\u016bh\u014dlani" },
            { "CA", "Kanak\u0101" },
            { "CN", "Kina" },
            { "DE", metaValue_DE },
            { "DK", metaValue_DK },
            { "ES", "Kepania" },
            { "FR", metaValue_FR },
            { "GB", "Aupuni M\u014d\u02bb\u012b Hui P\u016b \u02bbIa" },
            { "GR", metaValue_GR },
            { "IE", "\u02bbIlelani" },
            { "IL", "\u02bbIsera\u02bbela" },
            { "IN", "\u02bb\u012ania" },
            { "IT", metaValue_IT },
            { "JP", "I\u0101pana" },
            { "MX", "Mekiko" },
            { "NL", metaValue_NL },
            { "NZ", "Aotearoa" },
            { "PH", "\u02bb\u0100ina Pilipino" },
            { "RU", metaValue_RU },
            { "US", "\u02bbAmelika Hui P\u016b \u02bbIa" },
            { "ar", "\u02bbAlapia" },
            { "cy", "Wale" },
            { "da", metaValue_DK },
            { "de", metaValue_DE },
            { "el", metaValue_GR },
            { "en", "Pelek\u0101nia" },
            { "es", "Paniolo" },
            { "fj", "P\u012bk\u012b" },
            { "fr", metaValue_FR },
            { "ga", "\u02bbAiliki" },
            { "he", "Hebera" },
            { "it", metaValue_IT },
            { "ja", "Kepan\u012b" },
            { "ko", "K\u014dlea" },
            { "la", "L\u0101kina" },
            { "mi", "M\u0101ori" },
            { "nl", metaValue_NL },
            { "pt", "Pukik\u012b" },
            { "ru", metaValue_RU },
            { "sm", "K\u0101moa" },
            { "sv", "Kuekene" },
            { "to", "Tonga" },
            { "ty", "Polapola" },
            { "vi", "Wiekanama" },
            { "zh", "P\u0101k\u0113" },
            { "gsw", "Kuikilani Kelem\u0101nia" },
            { "haw", "\u02bb\u014clelo Hawai\u02bbi" },
            { "und", "\u02bbIke \u02bbole \u2018ia a k\u016bpono \u02bbole paha ka \u02bb\u014dlelo" },
            { "en_AU", "Pelek\u0101ne N\u016b H\u014dlani" },
            { "en_CA", "Pelek\u0101ne Kanak\u0101" },
            { "en_GB", "Pelek\u0101nia Pekek\u0101ne" },
            { "en_US", "Pelek\u0101nia \u02bbAmelika" },
            { "fr_CA", "Palani Kanak\u0101" },
            { "fr_CH", "Kuikilani" },
            { "pt_BR", "Pukik\u012b Palakila" },
            { "zh_Hans", "P\u0101k\u0113 Ho\u02bboma\u02bbalahi \u02bbia" },
            { "zh_Hant", "P\u0101k\u0113 Ku\u02bbuna" },
        };
        return data;
    }
}
