/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_HeapRegionManager
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_HeapRegionManager {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __auxRegionCountOffset_;
	public static final int __auxRegionDescriptorListOffset_;
	public static final int __heapRegionListMonitorOffset_;
	public static final int __highTableEdgeOffset_;
	public static final int __lowTableEdgeOffset_;
	public static final int __regionDescriptorDestructorOffset_;
	public static final int __regionDescriptorInitializerOffset_;
	public static final int __regionShiftOffset_;
	public static final int __regionSizeOffset_;
	public static final int __regionTableOffset_;
	public static final int __tableDescriptorSizeOffset_;
	public static final int __tableRegionCountOffset_;
	public static final int __totalHeapSizeOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__auxRegionCountOffset_ = 0;
		__auxRegionDescriptorListOffset_ = 0;
		__heapRegionListMonitorOffset_ = 0;
		__highTableEdgeOffset_ = 0;
		__lowTableEdgeOffset_ = 0;
		__regionDescriptorDestructorOffset_ = 0;
		__regionDescriptorInitializerOffset_ = 0;
		__regionShiftOffset_ = 0;
		__regionSizeOffset_ = 0;
		__regionTableOffset_ = 0;
		__tableDescriptorSizeOffset_ = 0;
		__tableRegionCountOffset_ = 0;
		__totalHeapSizeOffset_ = 0;
	}

}
