/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9StackWalkConstants
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9StackWalkConstants {

	// VM Constants

	public static final long SIZEOF;
	public static final long J9SW_ARGUMENT_REGISTER_COUNT;
	public static final long J9SW_JIT_CALLEE_PRESERVED_SIZE;
	public static final long J9SW_JIT_FIRST_RESOLVE_PARM_REGISTER;
	public static final long J9SW_JIT_FLOAT_ARGUMENT_REGISTER_COUNT;
	public static final long J9SW_JIT_LOOKUP_INTERFACE_RESOLVE_OFFSET_TO_SAVED_RECEIVER;
	public static final long J9SW_JIT_RETURN_TABLE_SIZE;
	public static final long J9SW_JIT_STACK_SLOTS_USED_BY_CALL;
	public static final long J9SW_JIT_VIRTUAL_METHOD_RESOLVE_OFFSET_TO_SAVED_RECEIVER;
	public static final long J9SW_POTENTIAL_SAVED_REGISTERS;
	public static final long J9SW_REGISTER_MAP_MASK;
	public static final long J9_JNI_PUSHED_REFERENCE_COUNT_MASK;
	public static final long J9_STACK_FLAGS_CALL_OUT_FRAME_ALLOCATED;
	public static final long J9_STACK_FLAGS_EXIT_TRACEPOINT_LEVEL3;
	public static final long J9_STACK_FLAGS_J2_IFRAME;
	public static final long J9_STACK_FLAGS_JIT_ALLOCATION_RESOLVE;
	public static final long J9_STACK_FLAGS_JIT_BEFORE_ANEWARRAY_RESOLVE;
	public static final long J9_STACK_FLAGS_JIT_BEFORE_MULTIANEWARRAY_RESOLVE;
	public static final long J9_STACK_FLAGS_JIT_CALL_IN_FRAME;
	public static final long J9_STACK_FLAGS_JIT_CALL_IN_TYPE_J2_I;
	public static final long J9_STACK_FLAGS_JIT_CALL_IN_TYPE_METHODTYPE;
	public static final long J9_STACK_FLAGS_JIT_DATA_RESOLVE;
	public static final long J9_STACK_FLAGS_JIT_EXCEPTION_CATCH_RESOLVE;
	public static final long J9_STACK_FLAGS_JIT_FAILED_METHOD_MONITOR_ENTER_RESOLVE;
	public static final long J9_STACK_FLAGS_JIT_FRAME_SUB_TYPE_MASK;
	public static final long J9_STACK_FLAGS_JIT_GENERIC_RESOLVE;
	public static final long J9_STACK_FLAGS_JIT_INDUCE_OSR_RESOLVE;
	public static final long J9_STACK_FLAGS_JIT_INTERFACE_METHOD_RESOLVE;
	public static final long J9_STACK_FLAGS_JIT_JNI_CALL_OUT_FRAME;
	public static final long J9_STACK_FLAGS_JIT_LOOKUP_RESOLVE;
	public static final long J9_STACK_FLAGS_JIT_METHOD_MONITOR_ENTER_RESOLVE;
	public static final long J9_STACK_FLAGS_JIT_MONITOR_ENTER_RESOLVE;
	public static final long J9_STACK_FLAGS_JIT_NATIVE_TRANSITION;
	public static final long J9_STACK_FLAGS_JIT_RECOMPILATION_RESOLVE;
	public static final long J9_STACK_FLAGS_JIT_RESOLVE_FRAME;
	public static final long J9_STACK_FLAGS_JIT_RUNTIME_HELPER_RESOLVE;
	public static final long J9_STACK_FLAGS_JIT_SPECIAL_METHOD_RESOLVE;
	public static final long J9_STACK_FLAGS_JIT_STACK_OVERFLOW_RESOLVE_FRAME;
	public static final long J9_STACK_FLAGS_JIT_STATIC_METHOD_RESOLVE;
	public static final long J9_STACK_FLAGS_JIT_TRANSITION_TO_INTERPRETER_MASK;
	public static final long J9_STACK_FLAGS_JIT_VIRTUAL_METHOD_RESOLVE;
	public static final long J9_STACK_FLAGS_JNI_REFS_REDIRECTED;
	public static final long J9_STACK_FLAGS_METHOD_ENTRY;
	public static final long J9_STACK_FLAGS_RELEASE_VMACCESS;
	public static final long J9_STACK_FLAGS_RETURNS_OBJECT;
	public static final long J9_STACK_FLAGS_UNUSED_0x80000000;
	public static final long J9_STACK_FLAGS_USE_SPECIFIED_CLASS_LOADER;
	public static final long J9_STACK_INVISIBLE_FRAME;
	public static final long J9_STACK_REPORT_FRAME_POP;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		J9SW_ARGUMENT_REGISTER_COUNT = 0;
		J9SW_JIT_CALLEE_PRESERVED_SIZE = 0;
		J9SW_JIT_FIRST_RESOLVE_PARM_REGISTER = 0;
		J9SW_JIT_FLOAT_ARGUMENT_REGISTER_COUNT = 0;
		J9SW_JIT_LOOKUP_INTERFACE_RESOLVE_OFFSET_TO_SAVED_RECEIVER = 0;
		J9SW_JIT_RETURN_TABLE_SIZE = 0;
		J9SW_JIT_STACK_SLOTS_USED_BY_CALL = 0;
		J9SW_JIT_VIRTUAL_METHOD_RESOLVE_OFFSET_TO_SAVED_RECEIVER = 0;
		J9SW_POTENTIAL_SAVED_REGISTERS = 0;
		J9SW_REGISTER_MAP_MASK = 0;
		J9_JNI_PUSHED_REFERENCE_COUNT_MASK = 0;
		J9_STACK_FLAGS_CALL_OUT_FRAME_ALLOCATED = 0;
		J9_STACK_FLAGS_EXIT_TRACEPOINT_LEVEL3 = 0;
		J9_STACK_FLAGS_J2_IFRAME = 0;
		J9_STACK_FLAGS_JIT_ALLOCATION_RESOLVE = 0;
		J9_STACK_FLAGS_JIT_BEFORE_ANEWARRAY_RESOLVE = 0;
		J9_STACK_FLAGS_JIT_BEFORE_MULTIANEWARRAY_RESOLVE = 0;
		J9_STACK_FLAGS_JIT_CALL_IN_FRAME = 0;
		J9_STACK_FLAGS_JIT_CALL_IN_TYPE_J2_I = 0;
		J9_STACK_FLAGS_JIT_CALL_IN_TYPE_METHODTYPE = 0;
		J9_STACK_FLAGS_JIT_DATA_RESOLVE = 0;
		J9_STACK_FLAGS_JIT_EXCEPTION_CATCH_RESOLVE = 0;
		J9_STACK_FLAGS_JIT_FAILED_METHOD_MONITOR_ENTER_RESOLVE = 0;
		J9_STACK_FLAGS_JIT_FRAME_SUB_TYPE_MASK = 0;
		J9_STACK_FLAGS_JIT_GENERIC_RESOLVE = 0;
		J9_STACK_FLAGS_JIT_INDUCE_OSR_RESOLVE = 0;
		J9_STACK_FLAGS_JIT_INTERFACE_METHOD_RESOLVE = 0;
		J9_STACK_FLAGS_JIT_JNI_CALL_OUT_FRAME = 0;
		J9_STACK_FLAGS_JIT_LOOKUP_RESOLVE = 0;
		J9_STACK_FLAGS_JIT_METHOD_MONITOR_ENTER_RESOLVE = 0;
		J9_STACK_FLAGS_JIT_MONITOR_ENTER_RESOLVE = 0;
		J9_STACK_FLAGS_JIT_NATIVE_TRANSITION = 0;
		J9_STACK_FLAGS_JIT_RECOMPILATION_RESOLVE = 0;
		J9_STACK_FLAGS_JIT_RESOLVE_FRAME = 0;
		J9_STACK_FLAGS_JIT_RUNTIME_HELPER_RESOLVE = 0;
		J9_STACK_FLAGS_JIT_SPECIAL_METHOD_RESOLVE = 0;
		J9_STACK_FLAGS_JIT_STACK_OVERFLOW_RESOLVE_FRAME = 0;
		J9_STACK_FLAGS_JIT_STATIC_METHOD_RESOLVE = 0;
		J9_STACK_FLAGS_JIT_TRANSITION_TO_INTERPRETER_MASK = 0;
		J9_STACK_FLAGS_JIT_VIRTUAL_METHOD_RESOLVE = 0;
		J9_STACK_FLAGS_JNI_REFS_REDIRECTED = 0;
		J9_STACK_FLAGS_METHOD_ENTRY = 0;
		J9_STACK_FLAGS_RELEASE_VMACCESS = 0;
		J9_STACK_FLAGS_RETURNS_OBJECT = 0;
		J9_STACK_FLAGS_UNUSED_0x80000000 = 0;
		J9_STACK_FLAGS_USE_SPECIFIED_CLASS_LOADER = 0;
		J9_STACK_INVISIBLE_FRAME = 0;
		J9_STACK_REPORT_FRAME_POP = 0;
	}

}
