/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9GSParametersPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9GSParametersPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9GSParameters.class)
public class J9GSParametersPointer extends StructurePointer {

	// NULL
	public static final J9GSParametersPointer NULL = new J9GSParametersPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9GSParametersPointer(long address) {
		super(address);
	}

	public static J9GSParametersPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9GSParametersPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9GSParametersPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new J9GSParametersPointer(address);
	}

	public J9GSParametersPointer add(long count) {
		return J9GSParametersPointer.cast(address + (J9GSParameters.SIZEOF * count));
	}

	public J9GSParametersPointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9GSParametersPointer addOffset(long offset) {
		return J9GSParametersPointer.cast(address + offset);
	}

	public J9GSParametersPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9GSParametersPointer sub(long count) {
		return J9GSParametersPointer.cast(address - (J9GSParameters.SIZEOF * count));
	}

	public J9GSParametersPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9GSParametersPointer subOffset(long offset) {
		return J9GSParametersPointer.cast(address - offset);
	}

	public J9GSParametersPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9GSParametersPointer untag(long mask) {
		return J9GSParametersPointer.cast(address & ~mask);
	}

	public J9GSParametersPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9GSParameters.SIZEOF;
	}

	// Implementation methods

	// U32:4 accessRegNum
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_accessRegNumOffset_", declaredType="U32:4")
	public UDATA accessRegNum() throws CorruptDataException {
		return getU32Bitfield(J9GSParameters._accessRegNum_s_, J9GSParameters._accessRegNum_b_);
	}

	// U32:2 addressSpaceIndication
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_addressSpaceIndicationOffset_", declaredType="U32:2")
	public UDATA addressSpaceIndication() throws CorruptDataException {
		return getU32Bitfield(J9GSParameters._addressSpaceIndication_s_, J9GSParameters._addressSpaceIndication_b_);
	}

	// U32:2 addressingMode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_addressingModeOffset_", declaredType="U32:2")
	public UDATA addressingMode() throws CorruptDataException {
		return getU32Bitfield(J9GSParameters._addressingMode_s_, J9GSParameters._addressingMode_b_);
	}

	// void* controlBlock
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_controlBlockOffset_", declaredType="void*")
	public VoidPointer controlBlock() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9GSParameters._controlBlockOffset_));
	}

	// void* controlBlock
	public PointerPointer controlBlockEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9GSParameters._controlBlockOffset_));
	}

	// U32 flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_flagsOffset_", declaredType="U32")
	public UDATA flags() throws CorruptDataException {
		return new U32(getIntAtOffset(J9GSParameters._flagsOffset_));
	}

	// U32 flags
	public UDATAPointer flagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9GSParameters._flagsOffset_));
	}

	// U64 handlerAddr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_handlerAddrOffset_", declaredType="U64")
	public UDATA handlerAddr() throws CorruptDataException {
		return new U64(getLongAtOffset(J9GSParameters._handlerAddrOffset_));
	}

	// U64 handlerAddr
	public UDATAPointer handlerAddrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9GSParameters._handlerAddrOffset_));
	}

	// U64 instructionAddr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_instructionAddrOffset_", declaredType="U64")
	public UDATA instructionAddr() throws CorruptDataException {
		return new U64(getLongAtOffset(J9GSParameters._instructionAddrOffset_));
	}

	// U64 instructionAddr
	public UDATAPointer instructionAddrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9GSParameters._instructionAddrOffset_));
	}

	// U32:1 instructionCause
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_instructionCauseOffset_", declaredType="U32:1")
	public UDATA instructionCause() throws CorruptDataException {
		return getU32Bitfield(J9GSParameters._instructionCause_s_, J9GSParameters._instructionCause_b_);
	}

	// U64 intermediateResult
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_intermediateResultOffset_", declaredType="U64")
	public UDATA intermediateResult() throws CorruptDataException {
		return new U64(getLongAtOffset(J9GSParameters._intermediateResultOffset_));
	}

	// U64 intermediateResult
	public UDATAPointer intermediateResultEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9GSParameters._intermediateResultOffset_));
	}

	// U32 notUsed2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_notUsed2Offset_", declaredType="U32")
	public UDATA notUsed2() throws CorruptDataException {
		return new U32(getIntAtOffset(J9GSParameters._notUsed2Offset_));
	}

	// U32 notUsed2
	public UDATAPointer notUsed2EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9GSParameters._notUsed2Offset_));
	}

	// U64 operandAddr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_operandAddrOffset_", declaredType="U64")
	public UDATA operandAddr() throws CorruptDataException {
		return new U64(getLongAtOffset(J9GSParameters._operandAddrOffset_));
	}

	// U64 operandAddr
	public UDATAPointer operandAddrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9GSParameters._operandAddrOffset_));
	}

	// U32:8 reserved8
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_reserved8Offset_", declaredType="U32:8")
	public UDATA reserved8() throws CorruptDataException {
		return getU32Bitfield(J9GSParameters._reserved8_s_, J9GSParameters._reserved8_b_);
	}

	// U32:1 reservedBit1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_reservedBit1Offset_", declaredType="U32:1")
	public UDATA reservedBit1() throws CorruptDataException {
		return getU32Bitfield(J9GSParameters._reservedBit1_s_, J9GSParameters._reservedBit1_b_);
	}

	// U32:5 reservedMode5
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_reservedMode5Offset_", declaredType="U32:5")
	public UDATA reservedMode5() throws CorruptDataException {
		return getU32Bitfield(J9GSParameters._reservedMode5_s_, J9GSParameters._reservedMode5_b_);
	}

	// U32:6 reservedMode6
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_reservedMode6Offset_", declaredType="U32:6")
	public UDATA reservedMode6() throws CorruptDataException {
		return getU32Bitfield(J9GSParameters._reservedMode6_s_, J9GSParameters._reservedMode6_b_);
	}

	// U64 returnAddr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_returnAddrOffset_", declaredType="U64")
	public UDATA returnAddr() throws CorruptDataException {
		return new U64(getLongAtOffset(J9GSParameters._returnAddrOffset_));
	}

	// U64 returnAddr
	public UDATAPointer returnAddrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9GSParameters._returnAddrOffset_));
	}

	// U32:2 transactionalExecutionMode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_transactionalExecutionModeOffset_", declaredType="U32:2")
	public UDATA transactionalExecutionMode() throws CorruptDataException {
		return getU32Bitfield(J9GSParameters._transactionalExecutionMode_s_, J9GSParameters._transactionalExecutionMode_b_);
	}

	// U32:1 translationMode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_translationModeOffset_", declaredType="U32:1")
	public UDATA translationMode() throws CorruptDataException {
		return getU32Bitfield(J9GSParameters._translationMode_s_, J9GSParameters._translationMode_b_);
	}

}
