/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: ConstantPoolMap$EntryUseFlags
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class ConstantPoolMap$EntryUseFlags {

	// VM Constants

	public static final long SIZEOF;
	public static final long ANEW_ARRAY;
	public static final long ANNOTATION;
	public static final long CHECK_CAST;
	public static final long GET_FIELD;
	public static final long GET_STATIC;
	public static final long INSTANCE_OF;
	public static final long INVOKE_DYNAMIC;
	public static final long INVOKE_HANDLEEXACT;
	public static final long INVOKE_HANDLEGENERIC;
	public static final long INVOKE_INTERFACE;
	public static final long INVOKE_SPECIAL;
	public static final long INVOKE_STATIC;
	public static final long INVOKE_VIRTUAL;
	public static final long LDC;
	public static final long LDC2W;
	public static final long MULTI_ANEW_ARRAY;
	public static final long NEW;
	public static final long PUT_FIELD;
	public static final long PUT_STATIC;
	public static final long REFERENCED;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		ANEW_ARRAY = 0;
		ANNOTATION = 0;
		CHECK_CAST = 0;
		GET_FIELD = 0;
		GET_STATIC = 0;
		INSTANCE_OF = 0;
		INVOKE_DYNAMIC = 0;
		INVOKE_HANDLEEXACT = 0;
		INVOKE_HANDLEGENERIC = 0;
		INVOKE_INTERFACE = 0;
		INVOKE_SPECIAL = 0;
		INVOKE_STATIC = 0;
		INVOKE_VIRTUAL = 0;
		LDC = 0;
		LDC2W = 0;
		MULTI_ANEW_ARRAY = 0;
		NEW = 0;
		PUT_FIELD = 0;
		PUT_STATIC = 0;
		REFERENCED = 0;
	}

}
