/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _IO_FILEPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _IO_FILEPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_IO_FILE.class)
public class _IO_FILEPointer extends StructurePointer {

	// NULL
	public static final _IO_FILEPointer NULL = new _IO_FILEPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _IO_FILEPointer(long address) {
		super(address);
	}

	public static _IO_FILEPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _IO_FILEPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _IO_FILEPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _IO_FILEPointer(address);
	}

	public _IO_FILEPointer add(long count) {
		return _IO_FILEPointer.cast(address + (_IO_FILE.SIZEOF * count));
	}

	public _IO_FILEPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _IO_FILEPointer addOffset(long offset) {
		return _IO_FILEPointer.cast(address + offset);
	}

	public _IO_FILEPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _IO_FILEPointer sub(long count) {
		return _IO_FILEPointer.cast(address - (_IO_FILE.SIZEOF * count));
	}

	public _IO_FILEPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _IO_FILEPointer subOffset(long offset) {
		return _IO_FILEPointer.cast(address - offset);
	}

	public _IO_FILEPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _IO_FILEPointer untag(long mask) {
		return _IO_FILEPointer.cast(address & ~mask);
	}

	public _IO_FILEPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _IO_FILE.SIZEOF;
	}

	// Implementation methods

	// U8* _IO_backup_base
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__IO_backup_baseOffset_", declaredType="U8*")
	public U8Pointer _IO_backup_base() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(_IO_FILE.__IO_backup_baseOffset_));
	}

	// U8* _IO_backup_base
	public PointerPointer _IO_backup_baseEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_IO_FILE.__IO_backup_baseOffset_));
	}

	// U8* _IO_buf_base
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__IO_buf_baseOffset_", declaredType="U8*")
	public U8Pointer _IO_buf_base() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(_IO_FILE.__IO_buf_baseOffset_));
	}

	// U8* _IO_buf_base
	public PointerPointer _IO_buf_baseEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_IO_FILE.__IO_buf_baseOffset_));
	}

	// U8* _IO_buf_end
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__IO_buf_endOffset_", declaredType="U8*")
	public U8Pointer _IO_buf_end() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(_IO_FILE.__IO_buf_endOffset_));
	}

	// U8* _IO_buf_end
	public PointerPointer _IO_buf_endEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_IO_FILE.__IO_buf_endOffset_));
	}

	// U8* _IO_read_base
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__IO_read_baseOffset_", declaredType="U8*")
	public U8Pointer _IO_read_base() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(_IO_FILE.__IO_read_baseOffset_));
	}

	// U8* _IO_read_base
	public PointerPointer _IO_read_baseEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_IO_FILE.__IO_read_baseOffset_));
	}

	// U8* _IO_read_end
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__IO_read_endOffset_", declaredType="U8*")
	public U8Pointer _IO_read_end() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(_IO_FILE.__IO_read_endOffset_));
	}

	// U8* _IO_read_end
	public PointerPointer _IO_read_endEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_IO_FILE.__IO_read_endOffset_));
	}

	// U8* _IO_read_ptr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__IO_read_ptrOffset_", declaredType="U8*")
	public U8Pointer _IO_read_ptr() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(_IO_FILE.__IO_read_ptrOffset_));
	}

	// U8* _IO_read_ptr
	public PointerPointer _IO_read_ptrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_IO_FILE.__IO_read_ptrOffset_));
	}

	// U8* _IO_save_base
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__IO_save_baseOffset_", declaredType="U8*")
	public U8Pointer _IO_save_base() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(_IO_FILE.__IO_save_baseOffset_));
	}

	// U8* _IO_save_base
	public PointerPointer _IO_save_baseEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_IO_FILE.__IO_save_baseOffset_));
	}

	// U8* _IO_save_end
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__IO_save_endOffset_", declaredType="U8*")
	public U8Pointer _IO_save_end() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(_IO_FILE.__IO_save_endOffset_));
	}

	// U8* _IO_save_end
	public PointerPointer _IO_save_endEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_IO_FILE.__IO_save_endOffset_));
	}

	// U8* _IO_write_base
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__IO_write_baseOffset_", declaredType="U8*")
	public U8Pointer _IO_write_base() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(_IO_FILE.__IO_write_baseOffset_));
	}

	// U8* _IO_write_base
	public PointerPointer _IO_write_baseEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_IO_FILE.__IO_write_baseOffset_));
	}

	// U8* _IO_write_end
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__IO_write_endOffset_", declaredType="U8*")
	public U8Pointer _IO_write_end() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(_IO_FILE.__IO_write_endOffset_));
	}

	// U8* _IO_write_end
	public PointerPointer _IO_write_endEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_IO_FILE.__IO_write_endOffset_));
	}

	// U8* _IO_write_ptr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__IO_write_ptrOffset_", declaredType="U8*")
	public U8Pointer _IO_write_ptr() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(_IO_FILE.__IO_write_ptrOffset_));
	}

	// U8* _IO_write_ptr
	public PointerPointer _IO_write_ptrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_IO_FILE.__IO_write_ptrOffset_));
	}

	// void* __pad1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pad1Offset_", declaredType="void*")
	public VoidPointer __pad1() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_IO_FILE.___pad1Offset_));
	}

	// void* __pad1
	public PointerPointer __pad1EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_IO_FILE.___pad1Offset_));
	}

	// void* __pad2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pad2Offset_", declaredType="void*")
	public VoidPointer __pad2() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_IO_FILE.___pad2Offset_));
	}

	// void* __pad2
	public PointerPointer __pad2EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_IO_FILE.___pad2Offset_));
	}

	// void* __pad3
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pad3Offset_", declaredType="void*")
	public VoidPointer __pad3() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_IO_FILE.___pad3Offset_));
	}

	// void* __pad3
	public PointerPointer __pad3EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_IO_FILE.___pad3Offset_));
	}

	// void* __pad4
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pad4Offset_", declaredType="void*")
	public VoidPointer __pad4() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_IO_FILE.___pad4Offset_));
	}

	// void* __pad4
	public PointerPointer __pad4EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_IO_FILE.___pad4Offset_));
	}

	// size_t __pad5
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___pad5Offset_", declaredType="size_t")
	public UDATA __pad5() throws CorruptDataException {
		return new U64(getLongAtOffset(_IO_FILE.___pad5Offset_));
	}

	// size_t __pad5
	public UDATAPointer __pad5EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IO_FILE.___pad5Offset_));
	}

	// _IO_FILE* _chain
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__chainOffset_", declaredType="_IO_FILE*")
	public _IO_FILEPointer _chain() throws CorruptDataException {
		return _IO_FILEPointer.cast(getPointerAtOffset(_IO_FILE.__chainOffset_));
	}

	// _IO_FILE* _chain
	public PointerPointer _chainEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_IO_FILE.__chainOffset_));
	}

	// U16 _cur_column
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__cur_columnOffset_", declaredType="U16")
	public U16 _cur_column() throws CorruptDataException {
		return new U16(getShortAtOffset(_IO_FILE.__cur_columnOffset_));
	}

	// U16 _cur_column
	public U16Pointer _cur_columnEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IO_FILE.__cur_columnOffset_));
	}

	// I32 _fileno
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__filenoOffset_", declaredType="I32")
	public IDATA _fileno() throws CorruptDataException {
		return new I32(getIntAtOffset(_IO_FILE.__filenoOffset_));
	}

	// I32 _fileno
	public IDATAPointer _filenoEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_IO_FILE.__filenoOffset_));
	}

	// I32 _flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__flagsOffset_", declaredType="I32")
	public IDATA _flags() throws CorruptDataException {
		return new I32(getIntAtOffset(_IO_FILE.__flagsOffset_));
	}

	// I32 _flags
	public IDATAPointer _flagsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_IO_FILE.__flagsOffset_));
	}

	// I32 _flags2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__flags2Offset_", declaredType="I32")
	public IDATA _flags2() throws CorruptDataException {
		return new I32(getIntAtOffset(_IO_FILE.__flags2Offset_));
	}

	// I32 _flags2
	public IDATAPointer _flags2EA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_IO_FILE.__flags2Offset_));
	}

	// _IO_marker* _markers
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__markersOffset_", declaredType="_IO_marker*")
	public _IO_markerPointer _markers() throws CorruptDataException {
		return _IO_markerPointer.cast(getPointerAtOffset(_IO_FILE.__markersOffset_));
	}

	// _IO_marker* _markers
	public PointerPointer _markersEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_IO_FILE.__markersOffset_));
	}

	// I32 _mode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__modeOffset_", declaredType="I32")
	public IDATA _mode() throws CorruptDataException {
		return new I32(getIntAtOffset(_IO_FILE.__modeOffset_));
	}

	// I32 _mode
	public IDATAPointer _modeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_IO_FILE.__modeOffset_));
	}

	// __off64_t _offset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__offsetOffset_", declaredType="__off64_t")
	public IDATA _offset() throws CorruptDataException {
		return new I64(getLongAtOffset(_IO_FILE.__offsetOffset_));
	}

	// __off64_t _offset
	public IDATAPointer _offsetEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_IO_FILE.__offsetOffset_));
	}

	// __off_t _old_offset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__old_offsetOffset_", declaredType="__off_t")
	public IDATA _old_offset() throws CorruptDataException {
		return new I64(getLongAtOffset(_IO_FILE.__old_offsetOffset_));
	}

	// __off_t _old_offset
	public IDATAPointer _old_offsetEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_IO_FILE.__old_offsetOffset_));
	}

	// U8[] _shortbuf
	public U8Pointer _shortbufEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_IO_FILE.__shortbufOffset_));
	}

	// U8[] _unused2
	public U8Pointer _unused2EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_IO_FILE.__unused2Offset_));
	}

	// I8 _vtable_offset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__vtable_offsetOffset_", declaredType="I8")
	public I8 _vtable_offset() throws CorruptDataException {
		return new I8(getByteAtOffset(_IO_FILE.__vtable_offsetOffset_));
	}

	// I8 _vtable_offset
	public I8Pointer _vtable_offsetEA() throws CorruptDataException {
		return I8Pointer.cast(nonNullFieldEA(_IO_FILE.__vtable_offsetOffset_));
	}

}
