/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: sigaltstackPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the sigaltstackPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=sigaltstack.class)
public class sigaltstackPointer extends StructurePointer {

	// NULL
	public static final sigaltstackPointer NULL = new sigaltstackPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected sigaltstackPointer(long address) {
		super(address);
	}

	public static sigaltstackPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static sigaltstackPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static sigaltstackPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new sigaltstackPointer(address);
	}

	public sigaltstackPointer add(long count) {
		return sigaltstackPointer.cast(address + (sigaltstack.SIZEOF * count));
	}

	public sigaltstackPointer add(Scalar count) {
		return add(count.longValue());
	}

	public sigaltstackPointer addOffset(long offset) {
		return sigaltstackPointer.cast(address + offset);
	}

	public sigaltstackPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public sigaltstackPointer sub(long count) {
		return sigaltstackPointer.cast(address - (sigaltstack.SIZEOF * count));
	}

	public sigaltstackPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public sigaltstackPointer subOffset(long offset) {
		return sigaltstackPointer.cast(address - offset);
	}

	public sigaltstackPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public sigaltstackPointer untag(long mask) {
		return sigaltstackPointer.cast(address & ~mask);
	}

	public sigaltstackPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return sigaltstack.SIZEOF;
	}

	// Implementation methods

	// I32 ss_flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ss_flagsOffset_", declaredType="I32")
	public IDATA ss_flags() throws CorruptDataException {
		return new I32(getIntAtOffset(sigaltstack._ss_flagsOffset_));
	}

	// I32 ss_flags
	public IDATAPointer ss_flagsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(sigaltstack._ss_flagsOffset_));
	}

	// size_t ss_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ss_sizeOffset_", declaredType="size_t")
	public UDATA ss_size() throws CorruptDataException {
		return new U64(getLongAtOffset(sigaltstack._ss_sizeOffset_));
	}

	// size_t ss_size
	public UDATAPointer ss_sizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sigaltstack._ss_sizeOffset_));
	}

	// void* ss_sp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ss_spOffset_", declaredType="void*")
	public VoidPointer ss_sp() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(sigaltstack._ss_spOffset_));
	}

	// void* ss_sp
	public PointerPointer ss_spEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(sigaltstack._ss_spOffset_));
	}

}
