/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9JSRIData
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9JSRIData {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _branchStackOffset_;
	public static final int _bytesAddedByJSRInlinerOffset_;
	public static final int _codeAttributeOffset_;
	public static final int _codeBlockPoolOffset_;
	public static final int _constantPoolOffset_;
	public static final int _destBufferOffset_;
	public static final int _destBufferIndexOffset_;
	public static final int _destBufferSizeOffset_;
	public static final int _errorCodeOffset_;
	public static final int _errorLocalIndexOffset_;
	public static final int _exceptionListEntryPoolOffset_;
	public static final int _exceptionTableOffset_;
	public static final int _exceptionTableBufferOffset_;
	public static final int _exceptionTableBufferSizeOffset_;
	public static final int _firstOutputOffset_;
	public static final int _flagsOffset_;
	public static final int _freePointerOffset_;
	public static final int _jsrDataPoolOffset_;
	public static final int _lastOutputOffset_;
	public static final int _mapOffset_;
	public static final int _mapSizeOffset_;
	public static final int _maxLocalsOffset_;
	public static final int _maxStackOffset_;
	public static final int _originalExceptionTableOffset_;
	public static final int _portLibOffset_;
	public static final int _segmentEndOffset_;
	public static final int _sourceBufferOffset_;
	public static final int _sourceBufferSizeOffset_;
	public static final int _verboseErrorTypeOffset_;
	public static final int _verifyErrorOffset_;
	public static final int _verifyErrorPCOffset_;
	public static final int _wideBranchesNeededOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_branchStackOffset_ = 0;
		_bytesAddedByJSRInlinerOffset_ = 0;
		_codeAttributeOffset_ = 0;
		_codeBlockPoolOffset_ = 0;
		_constantPoolOffset_ = 0;
		_destBufferOffset_ = 0;
		_destBufferIndexOffset_ = 0;
		_destBufferSizeOffset_ = 0;
		_errorCodeOffset_ = 0;
		_errorLocalIndexOffset_ = 0;
		_exceptionListEntryPoolOffset_ = 0;
		_exceptionTableOffset_ = 0;
		_exceptionTableBufferOffset_ = 0;
		_exceptionTableBufferSizeOffset_ = 0;
		_firstOutputOffset_ = 0;
		_flagsOffset_ = 0;
		_freePointerOffset_ = 0;
		_jsrDataPoolOffset_ = 0;
		_lastOutputOffset_ = 0;
		_mapOffset_ = 0;
		_mapSizeOffset_ = 0;
		_maxLocalsOffset_ = 0;
		_maxStackOffset_ = 0;
		_originalExceptionTableOffset_ = 0;
		_portLibOffset_ = 0;
		_segmentEndOffset_ = 0;
		_sourceBufferOffset_ = 0;
		_sourceBufferSizeOffset_ = 0;
		_verboseErrorTypeOffset_ = 0;
		_verifyErrorOffset_ = 0;
		_verifyErrorPCOffset_ = 0;
		_wideBranchesNeededOffset_ = 0;
	}

}
