/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_GCExtensionsBase
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_GCExtensionsBase {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _RTC_FrequencyOffset_;
	public static final int __backOutStateOffset_;
	public static final int __compressObjectReferencesOffset_;
	public static final int __concurrentGlobalGCInProgressOffset_;
	public static final int __forceRandomBackoutsAfterScanOffset_;
	public static final int __forceRandomBackoutsAfterScanPeriodOffset_;
	public static final int __forgeOffset_;
	public static final int __globalCollectorOffset_;
	public static final int __guaranteedNurseryEndOffset_;
	public static final int __guaranteedNurseryStartOffset_;
	public static final int __holdRandomThreadBeforeHandlingWorkUnitOffset_;
	public static final int __holdRandomThreadBeforeHandlingWorkUnitPeriodOffset_;
	public static final int __isConcurrentCopyForwardOffset_;
	public static final int __isMetronomeGCOffset_;
	public static final int __isRememberedSetInOverflowOffset_;
	public static final int __isSegregatedHeapOffset_;
	public static final int __isStandardGCOffset_;
	public static final int __isVLHGCOffset_;
	public static final int __lazyCollectorInitOffset_;
	public static final int __lightweightNonReentrantLockPoolOffset_;
	public static final int __lightweightNonReentrantLockPoolMutexOffset_;
	public static final int __mainThreadCpuTimeNanosOffset_;
	public static final int __mainThreadTenureTLHRemainderBaseOffset_;
	public static final int __mainThreadTenureTLHRemainderTopOffset_;
	public static final int __numaManagerOffset_;
	public static final int __omrVMOffset_;
	public static final int __tenureBaseOffset_;
	public static final int __tenureSizeOffset_;
	public static final int _absoluteMinimumNewSubSpaceSizeOffset_;
	public static final int _absoluteMinimumOldSubSpaceSizeOffset_;
	public static final int _adaptiveGCThreadingOffset_;
	public static final int _adaptiveGcCountBetweenHotFieldSortOffset_;
	public static final int _adaptiveThreadBoosterOffset_;
	public static final int _adaptiveThreadingSensitivityFactorOffset_;
	public static final int _adaptiveThreadingWeightActiveThreadsOffset_;
	public static final int _aggressiveOffset_;
	public static final int _aliasInhibitingThresholdPercentageOffset_;
	public static final int _allocationCacheIncrementSizeOffset_;
	public static final int _allocationCacheInitialSizeOffset_;
	public static final int _allocationCacheMaximumSizeOffset_;
	public static final int _allocationCacheMinimumSizeOffset_;
	public static final int _allocationIncrementOffset_;
	public static final int _allocationIncrementSetByUserOffset_;
	public static final int _allocationStatsOffset_;
	public static final int _allocationTrackerFlushThresholdOffset_;
	public static final int _allocationTrackerMaxThresholdOffset_;
	public static final int _allocationTrackerMaxTotalErrorOffset_;
	public static final int _allowMergedSpacesOffset_;
	public static final int _allowPermanantHotFieldsOffset_;
	public static final int _alwaysCallReadBarrierOffset_;
	public static final int _alwaysCallWriteBarrierOffset_;
	public static final int _alwaysDepthCopyFirstOffsetOffset_;
	public static final int _arrayletsPerRegionOffset_;
	public static final int _batchClearTLHOffset_;
	public static final int _beatMicroOffset_;
	public static final int _bufferedLoggingOffset_;
	public static final int _bytesAllocatedMostOffset_;
	public static final int _cacheListSplitOffset_;
	public static final int _cacheListSplitForcedOffset_;
	public static final int _cardCleanPass2BoostOffset_;
	public static final int _cardCleaningPassesOffset_;
	public static final int _cardTableOffset_;
	public static final int _checkpointGCthreadCountOffset_;
	public static final int _classLoaderRememberedSetOffset_;
	public static final int _collectorLanguageInterfaceOffset_;
	public static final int _compactGroupPersistentStatsOffset_;
	public static final int _compactOnGlobalGCOffset_;
	public static final int _compactOnIdleOffset_;
	public static final int _compactOnSystemGCOffset_;
	public static final int _compactToSatisfyAllocateOffset_;
	public static final int _compressedCardTableOffset_;
	public static final int _concurrentBackgroundOffset_;
	public static final int _concurrentKickoffEnabledOffset_;
	public static final int _concurrentKickoffTenuringHeadroomOffset_;
	public static final int _concurrentLevelOffset_;
	public static final int _concurrentMarkOffset_;
	public static final int _concurrentMeteringOffset_;
	public static final int _concurrentScavengeExhaustiveTerminationOffset_;
	public static final int _concurrentScavengeTaxationHeadroomHighOffset_;
	public static final int _concurrentScavengeTaxationHeadroomLowOffset_;
	public static final int _concurrentScavengerOffset_;
	public static final int _concurrentScavengerAllocAverageBoostOffset_;
	public static final int _concurrentScavengerAllocDeviationBoostOffset_;
	public static final int _concurrentScavengerBackgroundThreadsOffset_;
	public static final int _concurrentScavengerBackgroundThreadsForcedOffset_;
	public static final int _concurrentScavengerForcedOffset_;
	public static final int _concurrentScavengerHWSupportOffset_;
	public static final int _concurrentScavengerPageSectionSizeOffset_;
	public static final int _concurrentScavengerPageStartAddressOffset_;
	public static final int _concurrentScavengerSlackOffset_;
	public static final int _concurrentSlackOffset_;
	public static final int _concurrentSlackFragmentationAdjustmentWeightOffset_;
	public static final int _concurrentSweepOffset_;
	public static final int _concurrentSweepingEnabledOffset_;
	public static final int _concurrentTracingEnabledOffset_;
	public static final int _configurationOffset_;
	public static final int _configurationOptionsOffset_;
	public static final int _copyScanRatioOffset_;
	public static final int _cpuUtilStatsOffset_;
	public static final int _currentEnvironmentCountOffset_;
	public static final int _darkMatterCompactThresholdOffset_;
	public static final int _darkMatterSampleRateOffset_;
	public static final int _debugOffset_;
	public static final int _debugConcurrentMarkOffset_;
	public static final int _debugConcurrentScavengerPageAlignmentOffset_;
	public static final int _debugDynamicNewSpaceSizingOffset_;
	public static final int _debugLOAAllocateOffset_;
	public static final int _debugLOAFreelistOffset_;
	public static final int _debugTiltedScavengeOffset_;
	public static final int _debugWriteBarrierOffset_;
	public static final int _decommitMinimumFreeOffset_;
	public static final int _defaultSizeClassesOffset_;
	public static final int _depthCopyMaxOffset_;
	public static final int _depthCopyThreePathsOffset_;
	public static final int _depthCopyTwoPathsOffset_;
	public static final int _didGlobalGCOffset_;
	public static final int _disableExplicitGCOffset_;
	public static final int _disableInlineAllocationForSamplingBytesGranularityOffset_;
	public static final int _disableInlineCacheForAllocationThresholdOffset_;
	public static final int _dispatcherOffset_;
	public static final int _dispatcherHybridNotifyThreadBoundOffset_;
	public static final int _distanceToYieldTimeCheckOffset_;
	public static final int _dnssAvoidMovingObjectsOffset_;
	public static final int _dnssExpectedRatioMaximumOffset_;
	public static final int _dnssExpectedRatioMinimumOffset_;
	public static final int _dnssMaximumContractionOffset_;
	public static final int _dnssMaximumExpansionOffset_;
	public static final int _dnssMinimumContractionOffset_;
	public static final int _dnssMinimumExpansionOffset_;
	public static final int _dnssWeightedTimeRatioFactorDecreaseOffset_;
	public static final int _dnssWeightedTimeRatioFactorIncreaseLargeOffset_;
	public static final int _dnssWeightedTimeRatioFactorIncreaseMediumOffset_;
	public static final int _dnssWeightedTimeRatioFactorIncreaseSmallOffset_;
	public static final int _doFrequentObjectAllocationSamplingOffset_;
	public static final int _doOutOfLineAllocationTraceOffset_;
	public static final int _dynamicNewSpaceSizingOffset_;
	public static final int _enableHybridMemoryPoolOffset_;
	public static final int _enableSplitHeapOffset_;
	public static final int _environmentsOffset_;
	public static final int _estimateFragmentationOffset_;
	public static final int _excessiveGCEnabledOffset_;
	public static final int _excessiveGCFreeSizeRatioOffset_;
	public static final int _excessiveGCLevelOffset_;
	public static final int _excessiveGCStatsOffset_;
	public static final int _excessiveGCnewRatioWeightOffset_;
	public static final int _excessiveGCratioOffset_;
	public static final int _extraYieldOffset_;
	public static final int _fixHeapForWalkOffset_;
	public static final int _fixedAllocationIncrementOffset_;
	public static final int _forcedShiftingCompressionAmountOffset_;
	public static final int _freeEntrySizeClassStatsSimulatedOffset_;
	public static final int _freeMemoryProfileMaxSizeClassesOffset_;
	public static final int _freeOldHeapSizeOnLastGlobalGCOffset_;
	public static final int _frequentObjectAllocationSamplingDepthOffset_;
	public static final int _frequentObjectAllocationSamplingRateOffset_;
	public static final int _frequentObjectsStatsOffset_;
	public static final int _fvtest_alwaysApplyOverflowRoundingOffset_;
	public static final int _fvtest_backoutCounterOffset_;
	public static final int _fvtest_concurrentCardTablePreparationDelayOffset_;
	public static final int _fvtest_disableExplictMainThreadOffset_;
	public static final int _fvtest_disableInlineAllocationOffset_;
	public static final int _fvtest_enableClassStaticsReadBarrierVerificationOffset_;
	public static final int _fvtest_enableHeapReadBarrierVerificationOffset_;
	public static final int _fvtest_enableJNIGlobalWeakReadBarrierVerificationOffset_;
	public static final int _fvtest_enableMonitorObjectsReadBarrierVerificationOffset_;
	public static final int _fvtest_enableReadBarrierVerificationOffset_;
	public static final int _fvtest_forceCardTableCommitFailureOffset_;
	public static final int _fvtest_forceCardTableCommitFailureCounterOffset_;
	public static final int _fvtest_forceCardTableDecommitFailureOffset_;
	public static final int _fvtest_forceCardTableDecommitFailureCounterOffset_;
	public static final int _fvtest_forceConcurrentTLHMarkMapCommitFailureOffset_;
	public static final int _fvtest_forceConcurrentTLHMarkMapCommitFailureCounterOffset_;
	public static final int _fvtest_forceConcurrentTLHMarkMapDecommitFailureOffset_;
	public static final int _fvtest_forceConcurrentTLHMarkMapDecommitFailureCounterOffset_;
	public static final int _fvtest_forceCopyForwardHybridRatioOffset_;
	public static final int _fvtest_forceExcessiveAllocFailureAfterOffset_;
	public static final int _fvtest_forceMarkMapCommitFailureOffset_;
	public static final int _fvtest_forceMarkMapCommitFailureCounterOffset_;
	public static final int _fvtest_forceMarkMapDecommitFailureOffset_;
	public static final int _fvtest_forceMarkMapDecommitFailureCounterOffset_;
	public static final int _fvtest_forceNurseryResizeOffset_;
	public static final int _fvtest_forceOldResizeOffset_;
	public static final int _fvtest_forcePoisonEvacuateOffset_;
	public static final int _fvtest_forceReferenceChainWalkerMarkMapCommitFailureOffset_;
	public static final int _fvtest_forceReferenceChainWalkerMarkMapCommitFailureCounterOffset_;
	public static final int _fvtest_forceScavengerBackoutOffset_;
	public static final int _fvtest_forceSweepChunkArrayCommitFailureOffset_;
	public static final int _fvtest_forceSweepChunkArrayCommitFailureCounterOffset_;
	public static final int _fvtest_nurseryResizeCounterOffset_;
	public static final int _fvtest_oldResizeCounterOffset_;
	public static final int _fvtest_scanCacheCountOffset_;
	public static final int _fvtest_tarokFirstContextOffset_;
	public static final int _fvtest_tarokForceNUMANodeOffset_;
	public static final int _fvtest_tarokVerifyMarkMapClosureOffset_;
	public static final int _fvtest_verifyHeapAboveOffset_;
	public static final int _fvtest_verifyHeapBelowOffset_;
	public static final int _gcCountBetweenHotFieldResetOffset_;
	public static final int _gcCountBetweenHotFieldSortOffset_;
	public static final int _gcCountBetweenHotFieldSortMaxOffset_;
	public static final int _gcExclusiveAccessMutexOffset_;
	public static final int _gcExclusiveAccessThreadIdOffset_;
	public static final int _gcInitialTriggerOffset_;
	public static final int _gcModeStringOffset_;
	public static final int _gcOnIdleOffset_;
	public static final int _gcStatsMutexOffset_;
	public static final int _gcThreadCountOffset_;
	public static final int _gcThreadCountForcedOffset_;
	public static final int _gcThreadCountSpecifiedOffset_;
	public static final int _gcTriggerOffset_;
	public static final int _gcmetadataPageFlagsOffset_;
	public static final int _gcmetadataPageSizeOffset_;
	public static final int _globalAllocationManagerOffset_;
	public static final int _globalGCStatsOffset_;
	public static final int _globalMaximumContractionOffset_;
	public static final int _globalMinimumContractionOffset_;
	public static final int _globalVLHGCStatsOffset_;
	public static final int _headRoomOffset_;
	public static final int _heapOffset_;
	public static final int _heapAlignmentOffset_;
	public static final int _heapBaseForBarrierRange0Offset_;
	public static final int _heapCeilingOffset_;
	public static final int _heapContractionGCRatioThresholdOffset_;
	public static final int _heapContractionStabilizationCountOffset_;
	public static final int _heapExpansionGCRatioThresholdOffset_;
	public static final int _heapExpansionMaximumSizeOffset_;
	public static final int _heapExpansionMinimumSizeOffset_;
	public static final int _heapExpansionStabilizationCountOffset_;
	public static final int _heapFreeMaximumRatioDivisorOffset_;
	public static final int _heapFreeMaximumRatioMultiplierOffset_;
	public static final int _heapFreeMinimumRatioDivisorOffset_;
	public static final int _heapFreeMinimumRatioMultiplierOffset_;
	public static final int _heapInitializationFailureReasonOffset_;
	public static final int _heapRegionManagerOffset_;
	public static final int _heapRegionStateTableOffset_;
	public static final int _heapSizeForBarrierRange0Offset_;
	public static final int _heapSizeStartupHintConservativeFactorOffset_;
	public static final int _heapSizeStartupHintWeightNewValueOffset_;
	public static final int _highAllocationThresholdOffset_;
	public static final int _hotFieldResettingEnabledOffset_;
	public static final int _hrtPeriodMicroOffset_;
	public static final int _incrementScavengerStatsOffset_;
	public static final int _indexableObjectModelOffset_;
	public static final int _initialMemorySizeOffset_;
	public static final int _instrumentableAllocateHookEnabledOffset_;
	public static final int _interRegionRememberedSetOffset_;
	public static final int _isArrayletDoubleMapAvailableOffset_;
	public static final int _isArrayletDoubleMapRequestedOffset_;
	public static final int _isRecursiveGCOffset_;
	public static final int _isVirtualLargeObjectHeapEnabledOffset_;
	public static final int _itPeriodMicroOffset_;
	public static final int _largeObjectAllocationProfilingSizeClassRatioOffset_;
	public static final int _largeObjectAllocationProfilingThresholdOffset_;
	public static final int _largeObjectAllocationProfilingTopKOffset_;
	public static final int _largeObjectAllocationProfilingVeryLargeObjectSizeClassOffset_;
	public static final int _largeObjectAllocationProfilingVeryLargeObjectThresholdOffset_;
	public static final int _largeObjectAreaOffset_;
	public static final int _largeObjectAreaInitialRatioOffset_;
	public static final int _largeObjectAreaMaximumRatioOffset_;
	public static final int _largeObjectAreaMinimumRatioOffset_;
	public static final int _largeObjectMinimumSizeOffset_;
	public static final int _largeObjectVirtualMemoryOffset_;
	public static final int _largePageFailOnErrorOffset_;
	public static final int _largePageFailedToSatisfyOffset_;
	public static final int _largePageWarnOnErrorOffset_;
	public static final int _lastGlobalGCFreeBytesOffset_;
	public static final int _lastGlobalGCFreeBytesLOAOffset_;
	public static final int _lnrlOptionsOffset_;
	public static final int _loaFreeHistorySizeOffset_;
	public static final int _lowAllocationThresholdOffset_;
	public static final int _lowMinimumOffset_;
	public static final int _managedAllocationContextCountOffset_;
	public static final int _markingArraySplitMaximumAmountOffset_;
	public static final int _markingArraySplitMinimumAmountOffset_;
	public static final int _maxConsecutiveHotFieldSelectionsOffset_;
	public static final int _maxHotFieldListLengthOffset_;
	public static final int _maxNewSpaceSizeOffset_;
	public static final int _maxOldSpaceSizeOffset_;
	public static final int _maxScavengeBeforeGlobalOffset_;
	public static final int _maxSizeDefaultMemorySpaceOffset_;
	public static final int _memoryManagerOffset_;
	public static final int _memoryMaxOffset_;
	public static final int _minArraySizeToSetAsScannedOffset_;
	public static final int _minCpuUtilOffset_;
	public static final int _minNewSpaceSizeOffset_;
	public static final int _minOldSpaceSizeOffset_;
	public static final int _minimumContractionRatioOffset_;
	public static final int _minimumFreeEntrySizeOffset_;
	public static final int _mixedObjectModelOffset_;
	public static final int _newSpaceSizeOffset_;
	public static final int _newThreadAllocationColorOffset_;
	public static final int _noCompactOnGlobalGCOffset_;
	public static final int _nocompactOnSystemGCOffset_;
	public static final int _nonDeterministicSweepOffset_;
	public static final int _numaForcedOffset_;
	public static final int _objectModelOffset_;
	public static final int _objectSamplingBytesGranularityOffset_;
	public static final int _oldHeapSizeOnLastGlobalGCOffset_;
	public static final int _oldSpaceSizeOffset_;
	public static final int _omrHookInterfaceOffset_;
	public static final int _oolObjectSamplingBytesGranularityOffset_;
	public static final int _optimizeConcurrentWBOffset_;
	public static final int _overflowCacheCountOffset_;
	public static final int _overflowSafeAllocSizeOffset_;
	public static final int _overrideHiresTimerCheckOffset_;
	public static final int _packetListSplitOffset_;
	public static final int _packetListSplitForcedOffset_;
	public static final int _padToPageSizeOffset_;
	public static final int _pageFragmentationCompactThresholdOffset_;
	public static final int _parSweepChunkSizeOffset_;
	public static final int _payAllocationTaxOffset_;
	public static final int _preferredHeapBaseOffset_;
	public static final int _pretouchHeapOnExpandOffset_;
	public static final int _previousMarkMapOffset_;
	public static final int _privateHookInterfaceOffset_;
	public static final int _processLargeAllocateStatsOffset_;
	public static final int _realtimeGCOffset_;
	public static final int _referenceChainWalkerMarkMapOffset_;
	public static final int _regionSizeOffset_;
	public static final int _rememberedSetOffset_;
	public static final int _rememberedSetCardBucketPoolOffset_;
	public static final int _requestedPageFlagsOffset_;
	public static final int _requestedPageSizeOffset_;
	public static final int _rootScannerStatsEnabledOffset_;
	public static final int _rootScannerStatsUsedOffset_;
	public static final int _sATBBarrierRememberedSetOffset_;
	public static final int _scavengerOffset_;
	public static final int _scavengerAlignHotFieldsOffset_;
	public static final int _scavengerCollectorExpandRatioOffset_;
	public static final int _scavengerEnabledOffset_;
	public static final int _scavengerFailedTenureThresholdOffset_;
	public static final int _scavengerMaximumCollectorExpandSizeOffset_;
	public static final int _scavengerRsoScanUnsafeOffset_;
	public static final int _scavengerScanCacheMaximumSizeOffset_;
	public static final int _scavengerScanCacheMinimumSizeOffset_;
	public static final int _scavengerScanOrderingOffset_;
	public static final int _scavengerStatsOffset_;
	public static final int _scvArraySplitMaximumAmountOffset_;
	public static final int _scvArraySplitMinimumAmountOffset_;
	public static final int _scvTenureAdaptiveTenureAgeOffset_;
	public static final int _scvTenureFixedTenureAgeOffset_;
	public static final int _scvTenureRatioHighOffset_;
	public static final int _scvTenureRatioLowOffset_;
	public static final int _scvTenureStrategyAdaptiveOffset_;
	public static final int _scvTenureStrategyFixedOffset_;
	public static final int _scvTenureStrategyHistoryOffset_;
	public static final int _scvTenureStrategyLookbackOffset_;
	public static final int _scvTenureStrategySurvivalThresholdOffset_;
	public static final int _shadowHeapBaseOffset_;
	public static final int _shadowHeapHandleOffset_;
	public static final int _shadowHeapTopOffset_;
	public static final int _shouldAllowShiftingCompressionOffset_;
	public static final int _shouldForceLowMemoryHeapCeilingShiftIfPossibleOffset_;
	public static final int _shouldForceSpecifiedShiftingCompressionOffset_;
	public static final int _shouldUseIntegerSizeToIndexOffset_;
	public static final int _softMxOffset_;
	public static final int _softwareRangeCheckReadBarrierOffset_;
	public static final int _softwareRangeCheckReadBarrierForcedOffset_;
	public static final int _sparseHeapPageFlagsOffset_;
	public static final int _sparseHeapPageSizeOffset_;
	public static final int _sparseHeapSizeRatioOffset_;
	public static final int _splitAvailableListSplitAmountOffset_;
	public static final int _splitFreeListAmountForcedOffset_;
	public static final int _splitFreeListNumberChunksPreparedOffset_;
	public static final int _splitFreeListSplitAmountOffset_;
	public static final int _splitHeapSectionOffset_;
	public static final int _suballocatorCommitSizeOffset_;
	public static final int _suballocatorIncrementSizeOffset_;
	public static final int _suballocatorInitialSizeOffset_;
	public static final int _suballocatorQuickAllocOffset_;
	public static final int _survivorSpaceMaximumSizeRatioOffset_;
	public static final int _survivorSpaceMinimumSizeRatioOffset_;
	public static final int _sweepCostToCheckYieldOffset_;
	public static final int _sweepHeapSectioningOffset_;
	public static final int _sweepPoolManagerAddressOrderedListOffset_;
	public static final int _sweepPoolManagerBumpPointerOffset_;
	public static final int _sweepPoolManagerSmallObjectAreaOffset_;
	public static final int _synchronousGCOnOOMOffset_;
	public static final int _targetUtilizationPercentageOffset_;
	public static final int _tarokAllocationAgeEnabledOffset_;
	public static final int _tarokAllocationAgeExponentBaseOffset_;
	public static final int _tarokAllocationAgeUnitOffset_;
	public static final int _tarokAttachedThreadsAreCommonOffset_;
	public static final int _tarokAutomaticDefragmentEmptinessThresholdOffset_;
	public static final int _tarokAutomaticGMPIntermissionOffset_;
	public static final int _tarokConcurrentMarkingCostWeightOffset_;
	public static final int _tarokCopyForwardFragmentationTargetOffset_;
	public static final int _tarokCoreSamplingAbsoluteBudgetOffset_;
	public static final int _tarokCoreSamplingPercentageBudgetOffset_;
	public static final int _tarokDebugEnabledOffset_;
	public static final int _tarokDefragmentEmptinessThresholdOffset_;
	public static final int _tarokDynamicCollectionSetSelectionAbsoluteBudgetOffset_;
	public static final int _tarokDynamicCollectionSetSelectionPercentageBudgetOffset_;
	public static final int _tarokEnableAllocationPointerAssertionOffset_;
	public static final int _tarokEnableCardScrubbingOffset_;
	public static final int _tarokEnableCompressedCardTableOffset_;
	public static final int _tarokEnableConcurrentGMPOffset_;
	public static final int _tarokEnableCopyForwardHybridOffset_;
	public static final int _tarokEnableDynamicCollectionSetSelectionOffset_;
	public static final int _tarokEnableExpensiveAssertionsOffset_;
	public static final int _tarokEnableIncrementalClassGCOffset_;
	public static final int _tarokEnableIncrementalGMPOffset_;
	public static final int _tarokEnableLeafFirstCopyingOffset_;
	public static final int _tarokEnableRecoverRegionTailsAfterSweepOffset_;
	public static final int _tarokEnableScoreBasedAtomicCompactOffset_;
	public static final int _tarokEnableStableRegionDetectionOffset_;
	public static final int _tarokForceKickoffHeadroomInBytesOffset_;
	public static final int _tarokGMPIntermissionOffset_;
	public static final int _tarokGlobalMarkIncrementTimeMillisOffset_;
	public static final int _tarokIdealEdenMaximumBytesOffset_;
	public static final int _tarokIdealEdenMinimumBytesOffset_;
	public static final int _tarokKickoffHeadroomInBytesOffset_;
	public static final int _tarokKickoffHeadroomRegionRateOffset_;
	public static final int _tarokMaximumAgeInBytesOffset_;
	public static final int _tarokMaximumNurseryAgeInBytesOffset_;
	public static final int _tarokMinimumGMPWorkTargetBytesOffset_;
	public static final int _tarokNurseryMaxAgeOffset_;
	public static final int _tarokPGCShouldCopyForwardOffset_;
	public static final int _tarokPGCShouldMarkCompactOffset_;
	public static final int _tarokPGCtoGMPDenominatorOffset_;
	public static final int _tarokPGCtoGMPNumeratorOffset_;
	public static final int _tarokRegionMaxAgeOffset_;
	public static final int _tarokRememberedSetCardListMaxSizeOffset_;
	public static final int _tarokRememberedSetCardListSizeOffset_;
	public static final int _tarokReserveRegionsFromCollectionSetOffset_;
	public static final int _tarokTailCandidateListSortOrderOffset_;
	public static final int _tarokTargetMaxPauseTimeOffset_;
	public static final int _tarokTgcEnableRememberedSetDuplicateDetectionOffset_;
	public static final int _tarokTgcSetSelectionDataTableOffset_;
	public static final int _tarokUseProjectedSurvivalCollectionSetOffset_;
	public static final int _tarokWorkSplittingPeriodOffset_;
	public static final int _tenureBytesDeviationBoostOffset_;
	public static final int _tiltedScavengeOffset_;
	public static final int _tiltedScavengeMaximumIncreaseOffset_;
	public static final int _timeWindowMicroOffset_;
	public static final int _tlhIncrementSizeOffset_;
	public static final int _tlhInitialSizeOffset_;
	public static final int _tlhMaximumSizeOffset_;
	public static final int _tlhMinimumSizeOffset_;
	public static final int _tlhSurvivorDiscardThresholdOffset_;
	public static final int _tlhTenureDiscardThresholdOffset_;
	public static final int _traceCostToCheckYieldOffset_;
	public static final int _trackMutatorThreadCategoryOffset_;
	public static final int _usablePhysicalMemoryOffset_;
	public static final int _useGCStartupHintsOffset_;
	public static final int _verboseOffset_;
	public static final int _verboseExtensionsOffset_;
	public static final int _verboseGCManagerOffset_;
	public static final int _verboseNewFormatOffset_;
	public static final int _verbosegcCycleTimeOffset_;
	public static final int _vmThreadAllocatedMostOffset_;
	public static final int _workpacketCountOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_RTC_FrequencyOffset_ = 0;
		__backOutStateOffset_ = 0;
		__compressObjectReferencesOffset_ = 0;
		__concurrentGlobalGCInProgressOffset_ = 0;
		__forceRandomBackoutsAfterScanOffset_ = 0;
		__forceRandomBackoutsAfterScanPeriodOffset_ = 0;
		__forgeOffset_ = 0;
		__globalCollectorOffset_ = 0;
		__guaranteedNurseryEndOffset_ = 0;
		__guaranteedNurseryStartOffset_ = 0;
		__holdRandomThreadBeforeHandlingWorkUnitOffset_ = 0;
		__holdRandomThreadBeforeHandlingWorkUnitPeriodOffset_ = 0;
		__isConcurrentCopyForwardOffset_ = 0;
		__isMetronomeGCOffset_ = 0;
		__isRememberedSetInOverflowOffset_ = 0;
		__isSegregatedHeapOffset_ = 0;
		__isStandardGCOffset_ = 0;
		__isVLHGCOffset_ = 0;
		__lazyCollectorInitOffset_ = 0;
		__lightweightNonReentrantLockPoolOffset_ = 0;
		__lightweightNonReentrantLockPoolMutexOffset_ = 0;
		__mainThreadCpuTimeNanosOffset_ = 0;
		__mainThreadTenureTLHRemainderBaseOffset_ = 0;
		__mainThreadTenureTLHRemainderTopOffset_ = 0;
		__numaManagerOffset_ = 0;
		__omrVMOffset_ = 0;
		__tenureBaseOffset_ = 0;
		__tenureSizeOffset_ = 0;
		_absoluteMinimumNewSubSpaceSizeOffset_ = 0;
		_absoluteMinimumOldSubSpaceSizeOffset_ = 0;
		_adaptiveGCThreadingOffset_ = 0;
		_adaptiveGcCountBetweenHotFieldSortOffset_ = 0;
		_adaptiveThreadBoosterOffset_ = 0;
		_adaptiveThreadingSensitivityFactorOffset_ = 0;
		_adaptiveThreadingWeightActiveThreadsOffset_ = 0;
		_aggressiveOffset_ = 0;
		_aliasInhibitingThresholdPercentageOffset_ = 0;
		_allocationCacheIncrementSizeOffset_ = 0;
		_allocationCacheInitialSizeOffset_ = 0;
		_allocationCacheMaximumSizeOffset_ = 0;
		_allocationCacheMinimumSizeOffset_ = 0;
		_allocationIncrementOffset_ = 0;
		_allocationIncrementSetByUserOffset_ = 0;
		_allocationStatsOffset_ = 0;
		_allocationTrackerFlushThresholdOffset_ = 0;
		_allocationTrackerMaxThresholdOffset_ = 0;
		_allocationTrackerMaxTotalErrorOffset_ = 0;
		_allowMergedSpacesOffset_ = 0;
		_allowPermanantHotFieldsOffset_ = 0;
		_alwaysCallReadBarrierOffset_ = 0;
		_alwaysCallWriteBarrierOffset_ = 0;
		_alwaysDepthCopyFirstOffsetOffset_ = 0;
		_arrayletsPerRegionOffset_ = 0;
		_batchClearTLHOffset_ = 0;
		_beatMicroOffset_ = 0;
		_bufferedLoggingOffset_ = 0;
		_bytesAllocatedMostOffset_ = 0;
		_cacheListSplitOffset_ = 0;
		_cacheListSplitForcedOffset_ = 0;
		_cardCleanPass2BoostOffset_ = 0;
		_cardCleaningPassesOffset_ = 0;
		_cardTableOffset_ = 0;
		_checkpointGCthreadCountOffset_ = 0;
		_classLoaderRememberedSetOffset_ = 0;
		_collectorLanguageInterfaceOffset_ = 0;
		_compactGroupPersistentStatsOffset_ = 0;
		_compactOnGlobalGCOffset_ = 0;
		_compactOnIdleOffset_ = 0;
		_compactOnSystemGCOffset_ = 0;
		_compactToSatisfyAllocateOffset_ = 0;
		_compressedCardTableOffset_ = 0;
		_concurrentBackgroundOffset_ = 0;
		_concurrentKickoffEnabledOffset_ = 0;
		_concurrentKickoffTenuringHeadroomOffset_ = 0;
		_concurrentLevelOffset_ = 0;
		_concurrentMarkOffset_ = 0;
		_concurrentMeteringOffset_ = 0;
		_concurrentScavengeExhaustiveTerminationOffset_ = 0;
		_concurrentScavengeTaxationHeadroomHighOffset_ = 0;
		_concurrentScavengeTaxationHeadroomLowOffset_ = 0;
		_concurrentScavengerOffset_ = 0;
		_concurrentScavengerAllocAverageBoostOffset_ = 0;
		_concurrentScavengerAllocDeviationBoostOffset_ = 0;
		_concurrentScavengerBackgroundThreadsOffset_ = 0;
		_concurrentScavengerBackgroundThreadsForcedOffset_ = 0;
		_concurrentScavengerForcedOffset_ = 0;
		_concurrentScavengerHWSupportOffset_ = 0;
		_concurrentScavengerPageSectionSizeOffset_ = 0;
		_concurrentScavengerPageStartAddressOffset_ = 0;
		_concurrentScavengerSlackOffset_ = 0;
		_concurrentSlackOffset_ = 0;
		_concurrentSlackFragmentationAdjustmentWeightOffset_ = 0;
		_concurrentSweepOffset_ = 0;
		_concurrentSweepingEnabledOffset_ = 0;
		_concurrentTracingEnabledOffset_ = 0;
		_configurationOffset_ = 0;
		_configurationOptionsOffset_ = 0;
		_copyScanRatioOffset_ = 0;
		_cpuUtilStatsOffset_ = 0;
		_currentEnvironmentCountOffset_ = 0;
		_darkMatterCompactThresholdOffset_ = 0;
		_darkMatterSampleRateOffset_ = 0;
		_debugOffset_ = 0;
		_debugConcurrentMarkOffset_ = 0;
		_debugConcurrentScavengerPageAlignmentOffset_ = 0;
		_debugDynamicNewSpaceSizingOffset_ = 0;
		_debugLOAAllocateOffset_ = 0;
		_debugLOAFreelistOffset_ = 0;
		_debugTiltedScavengeOffset_ = 0;
		_debugWriteBarrierOffset_ = 0;
		_decommitMinimumFreeOffset_ = 0;
		_defaultSizeClassesOffset_ = 0;
		_depthCopyMaxOffset_ = 0;
		_depthCopyThreePathsOffset_ = 0;
		_depthCopyTwoPathsOffset_ = 0;
		_didGlobalGCOffset_ = 0;
		_disableExplicitGCOffset_ = 0;
		_disableInlineAllocationForSamplingBytesGranularityOffset_ = 0;
		_disableInlineCacheForAllocationThresholdOffset_ = 0;
		_dispatcherOffset_ = 0;
		_dispatcherHybridNotifyThreadBoundOffset_ = 0;
		_distanceToYieldTimeCheckOffset_ = 0;
		_dnssAvoidMovingObjectsOffset_ = 0;
		_dnssExpectedRatioMaximumOffset_ = 0;
		_dnssExpectedRatioMinimumOffset_ = 0;
		_dnssMaximumContractionOffset_ = 0;
		_dnssMaximumExpansionOffset_ = 0;
		_dnssMinimumContractionOffset_ = 0;
		_dnssMinimumExpansionOffset_ = 0;
		_dnssWeightedTimeRatioFactorDecreaseOffset_ = 0;
		_dnssWeightedTimeRatioFactorIncreaseLargeOffset_ = 0;
		_dnssWeightedTimeRatioFactorIncreaseMediumOffset_ = 0;
		_dnssWeightedTimeRatioFactorIncreaseSmallOffset_ = 0;
		_doFrequentObjectAllocationSamplingOffset_ = 0;
		_doOutOfLineAllocationTraceOffset_ = 0;
		_dynamicNewSpaceSizingOffset_ = 0;
		_enableHybridMemoryPoolOffset_ = 0;
		_enableSplitHeapOffset_ = 0;
		_environmentsOffset_ = 0;
		_estimateFragmentationOffset_ = 0;
		_excessiveGCEnabledOffset_ = 0;
		_excessiveGCFreeSizeRatioOffset_ = 0;
		_excessiveGCLevelOffset_ = 0;
		_excessiveGCStatsOffset_ = 0;
		_excessiveGCnewRatioWeightOffset_ = 0;
		_excessiveGCratioOffset_ = 0;
		_extraYieldOffset_ = 0;
		_fixHeapForWalkOffset_ = 0;
		_fixedAllocationIncrementOffset_ = 0;
		_forcedShiftingCompressionAmountOffset_ = 0;
		_freeEntrySizeClassStatsSimulatedOffset_ = 0;
		_freeMemoryProfileMaxSizeClassesOffset_ = 0;
		_freeOldHeapSizeOnLastGlobalGCOffset_ = 0;
		_frequentObjectAllocationSamplingDepthOffset_ = 0;
		_frequentObjectAllocationSamplingRateOffset_ = 0;
		_frequentObjectsStatsOffset_ = 0;
		_fvtest_alwaysApplyOverflowRoundingOffset_ = 0;
		_fvtest_backoutCounterOffset_ = 0;
		_fvtest_concurrentCardTablePreparationDelayOffset_ = 0;
		_fvtest_disableExplictMainThreadOffset_ = 0;
		_fvtest_disableInlineAllocationOffset_ = 0;
		_fvtest_enableClassStaticsReadBarrierVerificationOffset_ = 0;
		_fvtest_enableHeapReadBarrierVerificationOffset_ = 0;
		_fvtest_enableJNIGlobalWeakReadBarrierVerificationOffset_ = 0;
		_fvtest_enableMonitorObjectsReadBarrierVerificationOffset_ = 0;
		_fvtest_enableReadBarrierVerificationOffset_ = 0;
		_fvtest_forceCardTableCommitFailureOffset_ = 0;
		_fvtest_forceCardTableCommitFailureCounterOffset_ = 0;
		_fvtest_forceCardTableDecommitFailureOffset_ = 0;
		_fvtest_forceCardTableDecommitFailureCounterOffset_ = 0;
		_fvtest_forceConcurrentTLHMarkMapCommitFailureOffset_ = 0;
		_fvtest_forceConcurrentTLHMarkMapCommitFailureCounterOffset_ = 0;
		_fvtest_forceConcurrentTLHMarkMapDecommitFailureOffset_ = 0;
		_fvtest_forceConcurrentTLHMarkMapDecommitFailureCounterOffset_ = 0;
		_fvtest_forceCopyForwardHybridRatioOffset_ = 0;
		_fvtest_forceExcessiveAllocFailureAfterOffset_ = 0;
		_fvtest_forceMarkMapCommitFailureOffset_ = 0;
		_fvtest_forceMarkMapCommitFailureCounterOffset_ = 0;
		_fvtest_forceMarkMapDecommitFailureOffset_ = 0;
		_fvtest_forceMarkMapDecommitFailureCounterOffset_ = 0;
		_fvtest_forceNurseryResizeOffset_ = 0;
		_fvtest_forceOldResizeOffset_ = 0;
		_fvtest_forcePoisonEvacuateOffset_ = 0;
		_fvtest_forceReferenceChainWalkerMarkMapCommitFailureOffset_ = 0;
		_fvtest_forceReferenceChainWalkerMarkMapCommitFailureCounterOffset_ = 0;
		_fvtest_forceScavengerBackoutOffset_ = 0;
		_fvtest_forceSweepChunkArrayCommitFailureOffset_ = 0;
		_fvtest_forceSweepChunkArrayCommitFailureCounterOffset_ = 0;
		_fvtest_nurseryResizeCounterOffset_ = 0;
		_fvtest_oldResizeCounterOffset_ = 0;
		_fvtest_scanCacheCountOffset_ = 0;
		_fvtest_tarokFirstContextOffset_ = 0;
		_fvtest_tarokForceNUMANodeOffset_ = 0;
		_fvtest_tarokVerifyMarkMapClosureOffset_ = 0;
		_fvtest_verifyHeapAboveOffset_ = 0;
		_fvtest_verifyHeapBelowOffset_ = 0;
		_gcCountBetweenHotFieldResetOffset_ = 0;
		_gcCountBetweenHotFieldSortOffset_ = 0;
		_gcCountBetweenHotFieldSortMaxOffset_ = 0;
		_gcExclusiveAccessMutexOffset_ = 0;
		_gcExclusiveAccessThreadIdOffset_ = 0;
		_gcInitialTriggerOffset_ = 0;
		_gcModeStringOffset_ = 0;
		_gcOnIdleOffset_ = 0;
		_gcStatsMutexOffset_ = 0;
		_gcThreadCountOffset_ = 0;
		_gcThreadCountForcedOffset_ = 0;
		_gcThreadCountSpecifiedOffset_ = 0;
		_gcTriggerOffset_ = 0;
		_gcmetadataPageFlagsOffset_ = 0;
		_gcmetadataPageSizeOffset_ = 0;
		_globalAllocationManagerOffset_ = 0;
		_globalGCStatsOffset_ = 0;
		_globalMaximumContractionOffset_ = 0;
		_globalMinimumContractionOffset_ = 0;
		_globalVLHGCStatsOffset_ = 0;
		_headRoomOffset_ = 0;
		_heapOffset_ = 0;
		_heapAlignmentOffset_ = 0;
		_heapBaseForBarrierRange0Offset_ = 0;
		_heapCeilingOffset_ = 0;
		_heapContractionGCRatioThresholdOffset_ = 0;
		_heapContractionStabilizationCountOffset_ = 0;
		_heapExpansionGCRatioThresholdOffset_ = 0;
		_heapExpansionMaximumSizeOffset_ = 0;
		_heapExpansionMinimumSizeOffset_ = 0;
		_heapExpansionStabilizationCountOffset_ = 0;
		_heapFreeMaximumRatioDivisorOffset_ = 0;
		_heapFreeMaximumRatioMultiplierOffset_ = 0;
		_heapFreeMinimumRatioDivisorOffset_ = 0;
		_heapFreeMinimumRatioMultiplierOffset_ = 0;
		_heapInitializationFailureReasonOffset_ = 0;
		_heapRegionManagerOffset_ = 0;
		_heapRegionStateTableOffset_ = 0;
		_heapSizeForBarrierRange0Offset_ = 0;
		_heapSizeStartupHintConservativeFactorOffset_ = 0;
		_heapSizeStartupHintWeightNewValueOffset_ = 0;
		_highAllocationThresholdOffset_ = 0;
		_hotFieldResettingEnabledOffset_ = 0;
		_hrtPeriodMicroOffset_ = 0;
		_incrementScavengerStatsOffset_ = 0;
		_indexableObjectModelOffset_ = 0;
		_initialMemorySizeOffset_ = 0;
		_instrumentableAllocateHookEnabledOffset_ = 0;
		_interRegionRememberedSetOffset_ = 0;
		_isArrayletDoubleMapAvailableOffset_ = 0;
		_isArrayletDoubleMapRequestedOffset_ = 0;
		_isRecursiveGCOffset_ = 0;
		_isVirtualLargeObjectHeapEnabledOffset_ = 0;
		_itPeriodMicroOffset_ = 0;
		_largeObjectAllocationProfilingSizeClassRatioOffset_ = 0;
		_largeObjectAllocationProfilingThresholdOffset_ = 0;
		_largeObjectAllocationProfilingTopKOffset_ = 0;
		_largeObjectAllocationProfilingVeryLargeObjectSizeClassOffset_ = 0;
		_largeObjectAllocationProfilingVeryLargeObjectThresholdOffset_ = 0;
		_largeObjectAreaOffset_ = 0;
		_largeObjectAreaInitialRatioOffset_ = 0;
		_largeObjectAreaMaximumRatioOffset_ = 0;
		_largeObjectAreaMinimumRatioOffset_ = 0;
		_largeObjectMinimumSizeOffset_ = 0;
		_largeObjectVirtualMemoryOffset_ = 0;
		_largePageFailOnErrorOffset_ = 0;
		_largePageFailedToSatisfyOffset_ = 0;
		_largePageWarnOnErrorOffset_ = 0;
		_lastGlobalGCFreeBytesOffset_ = 0;
		_lastGlobalGCFreeBytesLOAOffset_ = 0;
		_lnrlOptionsOffset_ = 0;
		_loaFreeHistorySizeOffset_ = 0;
		_lowAllocationThresholdOffset_ = 0;
		_lowMinimumOffset_ = 0;
		_managedAllocationContextCountOffset_ = 0;
		_markingArraySplitMaximumAmountOffset_ = 0;
		_markingArraySplitMinimumAmountOffset_ = 0;
		_maxConsecutiveHotFieldSelectionsOffset_ = 0;
		_maxHotFieldListLengthOffset_ = 0;
		_maxNewSpaceSizeOffset_ = 0;
		_maxOldSpaceSizeOffset_ = 0;
		_maxScavengeBeforeGlobalOffset_ = 0;
		_maxSizeDefaultMemorySpaceOffset_ = 0;
		_memoryManagerOffset_ = 0;
		_memoryMaxOffset_ = 0;
		_minArraySizeToSetAsScannedOffset_ = 0;
		_minCpuUtilOffset_ = 0;
		_minNewSpaceSizeOffset_ = 0;
		_minOldSpaceSizeOffset_ = 0;
		_minimumContractionRatioOffset_ = 0;
		_minimumFreeEntrySizeOffset_ = 0;
		_mixedObjectModelOffset_ = 0;
		_newSpaceSizeOffset_ = 0;
		_newThreadAllocationColorOffset_ = 0;
		_noCompactOnGlobalGCOffset_ = 0;
		_nocompactOnSystemGCOffset_ = 0;
		_nonDeterministicSweepOffset_ = 0;
		_numaForcedOffset_ = 0;
		_objectModelOffset_ = 0;
		_objectSamplingBytesGranularityOffset_ = 0;
		_oldHeapSizeOnLastGlobalGCOffset_ = 0;
		_oldSpaceSizeOffset_ = 0;
		_omrHookInterfaceOffset_ = 0;
		_oolObjectSamplingBytesGranularityOffset_ = 0;
		_optimizeConcurrentWBOffset_ = 0;
		_overflowCacheCountOffset_ = 0;
		_overflowSafeAllocSizeOffset_ = 0;
		_overrideHiresTimerCheckOffset_ = 0;
		_packetListSplitOffset_ = 0;
		_packetListSplitForcedOffset_ = 0;
		_padToPageSizeOffset_ = 0;
		_pageFragmentationCompactThresholdOffset_ = 0;
		_parSweepChunkSizeOffset_ = 0;
		_payAllocationTaxOffset_ = 0;
		_preferredHeapBaseOffset_ = 0;
		_pretouchHeapOnExpandOffset_ = 0;
		_previousMarkMapOffset_ = 0;
		_privateHookInterfaceOffset_ = 0;
		_processLargeAllocateStatsOffset_ = 0;
		_realtimeGCOffset_ = 0;
		_referenceChainWalkerMarkMapOffset_ = 0;
		_regionSizeOffset_ = 0;
		_rememberedSetOffset_ = 0;
		_rememberedSetCardBucketPoolOffset_ = 0;
		_requestedPageFlagsOffset_ = 0;
		_requestedPageSizeOffset_ = 0;
		_rootScannerStatsEnabledOffset_ = 0;
		_rootScannerStatsUsedOffset_ = 0;
		_sATBBarrierRememberedSetOffset_ = 0;
		_scavengerOffset_ = 0;
		_scavengerAlignHotFieldsOffset_ = 0;
		_scavengerCollectorExpandRatioOffset_ = 0;
		_scavengerEnabledOffset_ = 0;
		_scavengerFailedTenureThresholdOffset_ = 0;
		_scavengerMaximumCollectorExpandSizeOffset_ = 0;
		_scavengerRsoScanUnsafeOffset_ = 0;
		_scavengerScanCacheMaximumSizeOffset_ = 0;
		_scavengerScanCacheMinimumSizeOffset_ = 0;
		_scavengerScanOrderingOffset_ = 0;
		_scavengerStatsOffset_ = 0;
		_scvArraySplitMaximumAmountOffset_ = 0;
		_scvArraySplitMinimumAmountOffset_ = 0;
		_scvTenureAdaptiveTenureAgeOffset_ = 0;
		_scvTenureFixedTenureAgeOffset_ = 0;
		_scvTenureRatioHighOffset_ = 0;
		_scvTenureRatioLowOffset_ = 0;
		_scvTenureStrategyAdaptiveOffset_ = 0;
		_scvTenureStrategyFixedOffset_ = 0;
		_scvTenureStrategyHistoryOffset_ = 0;
		_scvTenureStrategyLookbackOffset_ = 0;
		_scvTenureStrategySurvivalThresholdOffset_ = 0;
		_shadowHeapBaseOffset_ = 0;
		_shadowHeapHandleOffset_ = 0;
		_shadowHeapTopOffset_ = 0;
		_shouldAllowShiftingCompressionOffset_ = 0;
		_shouldForceLowMemoryHeapCeilingShiftIfPossibleOffset_ = 0;
		_shouldForceSpecifiedShiftingCompressionOffset_ = 0;
		_shouldUseIntegerSizeToIndexOffset_ = 0;
		_softMxOffset_ = 0;
		_softwareRangeCheckReadBarrierOffset_ = 0;
		_softwareRangeCheckReadBarrierForcedOffset_ = 0;
		_sparseHeapPageFlagsOffset_ = 0;
		_sparseHeapPageSizeOffset_ = 0;
		_sparseHeapSizeRatioOffset_ = 0;
		_splitAvailableListSplitAmountOffset_ = 0;
		_splitFreeListAmountForcedOffset_ = 0;
		_splitFreeListNumberChunksPreparedOffset_ = 0;
		_splitFreeListSplitAmountOffset_ = 0;
		_splitHeapSectionOffset_ = 0;
		_suballocatorCommitSizeOffset_ = 0;
		_suballocatorIncrementSizeOffset_ = 0;
		_suballocatorInitialSizeOffset_ = 0;
		_suballocatorQuickAllocOffset_ = 0;
		_survivorSpaceMaximumSizeRatioOffset_ = 0;
		_survivorSpaceMinimumSizeRatioOffset_ = 0;
		_sweepCostToCheckYieldOffset_ = 0;
		_sweepHeapSectioningOffset_ = 0;
		_sweepPoolManagerAddressOrderedListOffset_ = 0;
		_sweepPoolManagerBumpPointerOffset_ = 0;
		_sweepPoolManagerSmallObjectAreaOffset_ = 0;
		_synchronousGCOnOOMOffset_ = 0;
		_targetUtilizationPercentageOffset_ = 0;
		_tarokAllocationAgeEnabledOffset_ = 0;
		_tarokAllocationAgeExponentBaseOffset_ = 0;
		_tarokAllocationAgeUnitOffset_ = 0;
		_tarokAttachedThreadsAreCommonOffset_ = 0;
		_tarokAutomaticDefragmentEmptinessThresholdOffset_ = 0;
		_tarokAutomaticGMPIntermissionOffset_ = 0;
		_tarokConcurrentMarkingCostWeightOffset_ = 0;
		_tarokCopyForwardFragmentationTargetOffset_ = 0;
		_tarokCoreSamplingAbsoluteBudgetOffset_ = 0;
		_tarokCoreSamplingPercentageBudgetOffset_ = 0;
		_tarokDebugEnabledOffset_ = 0;
		_tarokDefragmentEmptinessThresholdOffset_ = 0;
		_tarokDynamicCollectionSetSelectionAbsoluteBudgetOffset_ = 0;
		_tarokDynamicCollectionSetSelectionPercentageBudgetOffset_ = 0;
		_tarokEnableAllocationPointerAssertionOffset_ = 0;
		_tarokEnableCardScrubbingOffset_ = 0;
		_tarokEnableCompressedCardTableOffset_ = 0;
		_tarokEnableConcurrentGMPOffset_ = 0;
		_tarokEnableCopyForwardHybridOffset_ = 0;
		_tarokEnableDynamicCollectionSetSelectionOffset_ = 0;
		_tarokEnableExpensiveAssertionsOffset_ = 0;
		_tarokEnableIncrementalClassGCOffset_ = 0;
		_tarokEnableIncrementalGMPOffset_ = 0;
		_tarokEnableLeafFirstCopyingOffset_ = 0;
		_tarokEnableRecoverRegionTailsAfterSweepOffset_ = 0;
		_tarokEnableScoreBasedAtomicCompactOffset_ = 0;
		_tarokEnableStableRegionDetectionOffset_ = 0;
		_tarokForceKickoffHeadroomInBytesOffset_ = 0;
		_tarokGMPIntermissionOffset_ = 0;
		_tarokGlobalMarkIncrementTimeMillisOffset_ = 0;
		_tarokIdealEdenMaximumBytesOffset_ = 0;
		_tarokIdealEdenMinimumBytesOffset_ = 0;
		_tarokKickoffHeadroomInBytesOffset_ = 0;
		_tarokKickoffHeadroomRegionRateOffset_ = 0;
		_tarokMaximumAgeInBytesOffset_ = 0;
		_tarokMaximumNurseryAgeInBytesOffset_ = 0;
		_tarokMinimumGMPWorkTargetBytesOffset_ = 0;
		_tarokNurseryMaxAgeOffset_ = 0;
		_tarokPGCShouldCopyForwardOffset_ = 0;
		_tarokPGCShouldMarkCompactOffset_ = 0;
		_tarokPGCtoGMPDenominatorOffset_ = 0;
		_tarokPGCtoGMPNumeratorOffset_ = 0;
		_tarokRegionMaxAgeOffset_ = 0;
		_tarokRememberedSetCardListMaxSizeOffset_ = 0;
		_tarokRememberedSetCardListSizeOffset_ = 0;
		_tarokReserveRegionsFromCollectionSetOffset_ = 0;
		_tarokTailCandidateListSortOrderOffset_ = 0;
		_tarokTargetMaxPauseTimeOffset_ = 0;
		_tarokTgcEnableRememberedSetDuplicateDetectionOffset_ = 0;
		_tarokTgcSetSelectionDataTableOffset_ = 0;
		_tarokUseProjectedSurvivalCollectionSetOffset_ = 0;
		_tarokWorkSplittingPeriodOffset_ = 0;
		_tenureBytesDeviationBoostOffset_ = 0;
		_tiltedScavengeOffset_ = 0;
		_tiltedScavengeMaximumIncreaseOffset_ = 0;
		_timeWindowMicroOffset_ = 0;
		_tlhIncrementSizeOffset_ = 0;
		_tlhInitialSizeOffset_ = 0;
		_tlhMaximumSizeOffset_ = 0;
		_tlhMinimumSizeOffset_ = 0;
		_tlhSurvivorDiscardThresholdOffset_ = 0;
		_tlhTenureDiscardThresholdOffset_ = 0;
		_traceCostToCheckYieldOffset_ = 0;
		_trackMutatorThreadCategoryOffset_ = 0;
		_usablePhysicalMemoryOffset_ = 0;
		_useGCStartupHintsOffset_ = 0;
		_verboseOffset_ = 0;
		_verboseExtensionsOffset_ = 0;
		_verboseGCManagerOffset_ = 0;
		_verboseNewFormatOffset_ = 0;
		_verbosegcCycleTimeOffset_ = 0;
		_vmThreadAllocatedMostOffset_ = 0;
		_workpacketCountOffset_ = 0;
	}

}
