/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: SharedconstsConstants
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class SharedconstsConstants {

	// VM Constants

	public static final long SIZEOF;
	public static final long ACQUIRE_HEADER_WRITE_LOCK_FAILED;
	public static final long CACHE_BAD_CC_INIT;
	public static final long CACHE_CRC_INVALID;
	public static final long CACHE_DATA_NULL;
	public static final long CACHE_DEBUGAREA_BAD_FREE_SPACE;
	public static final long CACHE_DEBUGAREA_BAD_FREE_SPACE_SIZE;
	public static final long CACHE_DEBUGAREA_BAD_LNT_HEADER_INFO;
	public static final long CACHE_DEBUGAREA_BAD_LVT_HEADER_INFO;
	public static final long CACHE_DEBUGAREA_BAD_SIZE;
	public static final long CACHE_DEBUGAREA_BAD_SIZES_FOR_COMMIT;
	public static final long CACHE_HEADER_BAD_EYECATCHER;
	public static final long CACHE_HEADER_INCORRECT_CACHE_SIZE;
	public static final long CACHE_HEADER_INCORRECT_DATA_LENGTH;
	public static final long CACHE_HEADER_INCORRECT_DATA_START_ADDRESS;
	public static final long CACHE_ROOT_MAXLEN;
	public static final long CACHE_SEMAPHORE_MISMATCH;
	public static final long CACHE_SIZE_INVALID;
	public static final long FREE_PATH_IN_CLEANUP;
	public static final long HELPERID_NOT_APPLICABLE;
	public static final long IS_IN_CACHE_FLAG;
	public static final long ITEM_LENGTH_CORRUPT;
	public static final long ITEM_TYPE_CORRUPT;
	public static final long J9OSCACHE_DATA_READ_LOCK;
	public static final long J9OSCACHE_DATA_WRITE_LOCK;
	public static final long J9OSCACHE_OPEN_MODE_CHECKBUILDID;
	public static final long J9OSCACHE_OPEN_MODE_CHECK_NETWORK_CACHE;
	public static final long J9OSCACHE_OPEN_MODE_DO_READONLY;
	public static final long J9OSCACHE_OPEN_MODE_GROUPACCESS;
	public static final long J9OSCACHE_OPEN_MODE_TRY_READONLY_ON_FAIL;
	public static final long J9SHR_STRING_POOL_FAILED_CONSISTENCY;
	public static final long J9SHR_STRING_POOL_FAILED_VERIFY;
	public static final long J9SHR_STRING_POOL_OK;
	public static final long J9SH_CACHE_FILE_MODE_DEFAULTDIR_WITHOUT_GROUPACCESS;
	public static final long J9SH_CACHE_FILE_MODE_DEFAULTDIR_WITH_GROUPACCESS;
	public static final long J9SH_CACHE_FILE_MODE_USERDIR_WITHOUT_GROUPACCESS;
	public static final long J9SH_CACHE_FILE_MODE_USERDIR_WITH_GROUPACCESS;
	public static final long MANAGER_STATE_INITIALIZED;
	public static final long MANAGER_STATE_SHUTDOWN;
	public static final long MANAGER_STATE_STARTED;
	public static final long MANAGER_STATE_STARTING;
	public static final long MARKED_STALE_FLAG;
	public static final long MONITOR_ENTER_RETRY_TIMES;
	public static final long NO_CORRUPTION;
	public static final long PRINTSTATS_SHOW_ALL_STALE;
	public static final long PRINTSTATS_SHOW_AOT;
	public static final long PRINTSTATS_SHOW_AOTCH;
	public static final long PRINTSTATS_SHOW_AOTDATA;
	public static final long PRINTSTATS_SHOW_AOTTHUNK;
	public static final long PRINTSTATS_SHOW_BYTEDATA;
	public static final long PRINTSTATS_SHOW_CLASSPATH;
	public static final long PRINTSTATS_SHOW_HELP;
	public static final long PRINTSTATS_SHOW_INVALIDATEDAOT;
	public static final long PRINTSTATS_SHOW_JCL;
	public static final long PRINTSTATS_SHOW_JITHINT;
	public static final long PRINTSTATS_SHOW_JITPROFILE;
	public static final long PRINTSTATS_SHOW_MOREHELP;
	public static final long PRINTSTATS_SHOW_NONE;
	public static final long PRINTSTATS_SHOW_ORPHAN;
	public static final long PRINTSTATS_SHOW_ROMCLASS;
	public static final long PRINTSTATS_SHOW_ROMMETHOD;
	public static final long PRINTSTATS_SHOW_TOKEN;
	public static final long PRINTSTATS_SHOW_URL;
	public static final long PRINTSTATS_SHOW_ZIPCACHE;
	public static final long PROTO_DIR;
	public static final long PROTO_JAR;
	public static final long PROTO_JIMAGE;
	public static final long PROTO_TOKEN;
	public static final long PROTO_UNKNOWN;
	public static final long ROMCLASS_CORRUPT;
	public static final long SHARE_CLASS_FILE_EXT_STRLEN;
	public static final long SHARE_PATHBUF_SIZE;
	public static final long SHR_FIND_AOT_METHOTHODS;
	public static final long SHR_INVALIDATE_AOT_METHOTHODS;
	public static final long SHR_METHOD_SPEC_TABLE_MAX_SIZE;
	public static final long SHR_REVALIDATE_AOT_METHOTHODS;
	public static final long SHR_STARTUP_REASON_DESTROY;
	public static final long SHR_STARTUP_REASON_EXPIRE;
	public static final long SHR_STARTUP_REASON_NORMAL;
	public static final long SHR_STATS_REASON_DESTROY;
	public static final long SHR_STATS_REASON_EXPIRE;
	public static final long SHR_STATS_REASON_GETNAME;
	public static final long SHR_STATS_REASON_ITERATE;
	public static final long SHR_STATS_REASON_LIST;
	public static final long SHR_STATS_REASON_TEST;
	public static final long TIMESTAMP_DISAPPEARED;
	public static final long TIMESTAMP_DOES_NOT_EXIST;
	public static final long TIMESTAMP_UNCHANGED;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		ACQUIRE_HEADER_WRITE_LOCK_FAILED = 0;
		CACHE_BAD_CC_INIT = 0;
		CACHE_CRC_INVALID = 0;
		CACHE_DATA_NULL = 0;
		CACHE_DEBUGAREA_BAD_FREE_SPACE = 0;
		CACHE_DEBUGAREA_BAD_FREE_SPACE_SIZE = 0;
		CACHE_DEBUGAREA_BAD_LNT_HEADER_INFO = 0;
		CACHE_DEBUGAREA_BAD_LVT_HEADER_INFO = 0;
		CACHE_DEBUGAREA_BAD_SIZE = 0;
		CACHE_DEBUGAREA_BAD_SIZES_FOR_COMMIT = 0;
		CACHE_HEADER_BAD_EYECATCHER = 0;
		CACHE_HEADER_INCORRECT_CACHE_SIZE = 0;
		CACHE_HEADER_INCORRECT_DATA_LENGTH = 0;
		CACHE_HEADER_INCORRECT_DATA_START_ADDRESS = 0;
		CACHE_ROOT_MAXLEN = 0;
		CACHE_SEMAPHORE_MISMATCH = 0;
		CACHE_SIZE_INVALID = 0;
		FREE_PATH_IN_CLEANUP = 0;
		HELPERID_NOT_APPLICABLE = 0;
		IS_IN_CACHE_FLAG = 0;
		ITEM_LENGTH_CORRUPT = 0;
		ITEM_TYPE_CORRUPT = 0;
		J9OSCACHE_DATA_READ_LOCK = 0;
		J9OSCACHE_DATA_WRITE_LOCK = 0;
		J9OSCACHE_OPEN_MODE_CHECKBUILDID = 0;
		J9OSCACHE_OPEN_MODE_CHECK_NETWORK_CACHE = 0;
		J9OSCACHE_OPEN_MODE_DO_READONLY = 0;
		J9OSCACHE_OPEN_MODE_GROUPACCESS = 0;
		J9OSCACHE_OPEN_MODE_TRY_READONLY_ON_FAIL = 0;
		J9SHR_STRING_POOL_FAILED_CONSISTENCY = 0;
		J9SHR_STRING_POOL_FAILED_VERIFY = 0;
		J9SHR_STRING_POOL_OK = 0;
		J9SH_CACHE_FILE_MODE_DEFAULTDIR_WITHOUT_GROUPACCESS = 0;
		J9SH_CACHE_FILE_MODE_DEFAULTDIR_WITH_GROUPACCESS = 0;
		J9SH_CACHE_FILE_MODE_USERDIR_WITHOUT_GROUPACCESS = 0;
		J9SH_CACHE_FILE_MODE_USERDIR_WITH_GROUPACCESS = 0;
		MANAGER_STATE_INITIALIZED = 0;
		MANAGER_STATE_SHUTDOWN = 0;
		MANAGER_STATE_STARTED = 0;
		MANAGER_STATE_STARTING = 0;
		MARKED_STALE_FLAG = 0;
		MONITOR_ENTER_RETRY_TIMES = 0;
		NO_CORRUPTION = 0;
		PRINTSTATS_SHOW_ALL_STALE = 0;
		PRINTSTATS_SHOW_AOT = 0;
		PRINTSTATS_SHOW_AOTCH = 0;
		PRINTSTATS_SHOW_AOTDATA = 0;
		PRINTSTATS_SHOW_AOTTHUNK = 0;
		PRINTSTATS_SHOW_BYTEDATA = 0;
		PRINTSTATS_SHOW_CLASSPATH = 0;
		PRINTSTATS_SHOW_HELP = 0;
		PRINTSTATS_SHOW_INVALIDATEDAOT = 0;
		PRINTSTATS_SHOW_JCL = 0;
		PRINTSTATS_SHOW_JITHINT = 0;
		PRINTSTATS_SHOW_JITPROFILE = 0;
		PRINTSTATS_SHOW_MOREHELP = 0;
		PRINTSTATS_SHOW_NONE = 0;
		PRINTSTATS_SHOW_ORPHAN = 0;
		PRINTSTATS_SHOW_ROMCLASS = 0;
		PRINTSTATS_SHOW_ROMMETHOD = 0;
		PRINTSTATS_SHOW_TOKEN = 0;
		PRINTSTATS_SHOW_URL = 0;
		PRINTSTATS_SHOW_ZIPCACHE = 0;
		PROTO_DIR = 0;
		PROTO_JAR = 0;
		PROTO_JIMAGE = 0;
		PROTO_TOKEN = 0;
		PROTO_UNKNOWN = 0;
		ROMCLASS_CORRUPT = 0;
		SHARE_CLASS_FILE_EXT_STRLEN = 0;
		SHARE_PATHBUF_SIZE = 0;
		SHR_FIND_AOT_METHOTHODS = 0;
		SHR_INVALIDATE_AOT_METHOTHODS = 0;
		SHR_METHOD_SPEC_TABLE_MAX_SIZE = 0;
		SHR_REVALIDATE_AOT_METHOTHODS = 0;
		SHR_STARTUP_REASON_DESTROY = 0;
		SHR_STARTUP_REASON_EXPIRE = 0;
		SHR_STARTUP_REASON_NORMAL = 0;
		SHR_STATS_REASON_DESTROY = 0;
		SHR_STATS_REASON_EXPIRE = 0;
		SHR_STATS_REASON_GETNAME = 0;
		SHR_STATS_REASON_ITERATE = 0;
		SHR_STATS_REASON_LIST = 0;
		SHR_STATS_REASON_TEST = 0;
		TIMESTAMP_DISAPPEARED = 0;
		TIMESTAMP_DOES_NOT_EXIST = 0;
		TIMESTAMP_UNCHANGED = 0;
	}

}
