/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: modRM_encodingPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the modRM_encodingPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=modRM_encoding.class)
public class modRM_encodingPointer extends StructurePointer {

	// NULL
	public static final modRM_encodingPointer NULL = new modRM_encodingPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected modRM_encodingPointer(long address) {
		super(address);
	}

	public static modRM_encodingPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static modRM_encodingPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static modRM_encodingPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new modRM_encodingPointer(address);
	}

	public modRM_encodingPointer add(long count) {
		return modRM_encodingPointer.cast(address + (modRM_encoding.SIZEOF * count));
	}

	public modRM_encodingPointer add(Scalar count) {
		return add(count.longValue());
	}

	public modRM_encodingPointer addOffset(long offset) {
		return modRM_encodingPointer.cast(address + offset);
	}

	public modRM_encodingPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public modRM_encodingPointer sub(long count) {
		return modRM_encodingPointer.cast(address - (modRM_encoding.SIZEOF * count));
	}

	public modRM_encodingPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public modRM_encodingPointer subOffset(long offset) {
		return modRM_encodingPointer.cast(address - offset);
	}

	public modRM_encodingPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public modRM_encodingPointer untag(long mask) {
		return modRM_encodingPointer.cast(address & ~mask);
	}

	public modRM_encodingPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return modRM_encoding.SIZEOF;
	}

	// Implementation methods

	// U8 reg
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_regOffset_", declaredType="U8")
	public U8 reg() throws CorruptDataException {
		return new U8(getByteAtOffset(modRM_encoding._regOffset_));
	}

	// U8 reg
	public U8Pointer regEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(modRM_encoding._regOffset_));
	}

	// U8 rexb
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rexbOffset_", declaredType="U8")
	public U8 rexb() throws CorruptDataException {
		return new U8(getByteAtOffset(modRM_encoding._rexbOffset_));
	}

	// U8 rexb
	public U8Pointer rexbEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(modRM_encoding._rexbOffset_));
	}

	// U8 rexr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rexrOffset_", declaredType="U8")
	public U8 rexr() throws CorruptDataException {
		return new U8(getByteAtOffset(modRM_encoding._rexrOffset_));
	}

	// U8 rexr
	public U8Pointer rexrEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(modRM_encoding._rexrOffset_));
	}

	// U8 rm
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rmOffset_", declaredType="U8")
	public U8 rm() throws CorruptDataException {
		return new U8(getByteAtOffset(modRM_encoding._rmOffset_));
	}

	// U8 rm
	public U8Pointer rmEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(modRM_encoding._rmOffset_));
	}

}
