/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: jvmtiError
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class jvmtiError {

	// VM Constants

	public static final long SIZEOF;
	public static final long JVMTI_ERROR_ABSENT_INFORMATION;
	public static final long JVMTI_ERROR_ACCESS_DENIED;
	public static final long JVMTI_ERROR_CIRCULAR_CLASS_DEFINITION;
	public static final long JVMTI_ERROR_CLASS_LOADER_UNSUPPORTED;
	public static final long JVMTI_ERROR_CLASS_NOT_PREPARED;
	public static final long JVMTI_ERROR_DUPLICATE;
	public static final long JVMTI_ERROR_FAILS_VERIFICATION;
	public static final long JVMTI_ERROR_ILLEGAL_ARGUMENT;
	public static final long JVMTI_ERROR_INTERNAL;
	public static final long JVMTI_ERROR_INTERRUPT;
	public static final long JVMTI_ERROR_INVALID_CLASS;
	public static final long JVMTI_ERROR_INVALID_CLASS_FORMAT;
	public static final long JVMTI_ERROR_INVALID_ENVIRONMENT;
	public static final long JVMTI_ERROR_INVALID_EVENT_TYPE;
	public static final long JVMTI_ERROR_INVALID_FIELDID;
	public static final long JVMTI_ERROR_INVALID_LOCATION;
	public static final long JVMTI_ERROR_INVALID_METHODID;
	public static final long JVMTI_ERROR_INVALID_MODULE;
	public static final long JVMTI_ERROR_INVALID_MONITOR;
	public static final long JVMTI_ERROR_INVALID_OBJECT;
	public static final long JVMTI_ERROR_INVALID_PRIORITY;
	public static final long JVMTI_ERROR_INVALID_SLOT;
	public static final long JVMTI_ERROR_INVALID_THREAD;
	public static final long JVMTI_ERROR_INVALID_THREAD_GROUP;
	public static final long JVMTI_ERROR_INVALID_TYPESTATE;
	public static final long JVMTI_ERROR_MAX;
	public static final long JVMTI_ERROR_MUST_POSSESS_CAPABILITY;
	public static final long JVMTI_ERROR_NAMES_DONT_MATCH;
	public static final long JVMTI_ERROR_NATIVE_METHOD;
	public static final long JVMTI_ERROR_NONE;
	public static final long JVMTI_ERROR_NOT_AVAILABLE;
	public static final long JVMTI_ERROR_NOT_FOUND;
	public static final long JVMTI_ERROR_NOT_MONITOR_OWNER;
	public static final long JVMTI_ERROR_NO_MORE_FRAMES;
	public static final long JVMTI_ERROR_NULL_POINTER;
	public static final long JVMTI_ERROR_OPAQUE_FRAME;
	public static final long JVMTI_ERROR_OUT_OF_MEMORY;
	public static final long JVMTI_ERROR_THREAD_NOT_ALIVE;
	public static final long JVMTI_ERROR_THREAD_NOT_SUSPENDED;
	public static final long JVMTI_ERROR_THREAD_SUSPENDED;
	public static final long JVMTI_ERROR_TYPE_MISMATCH;
	public static final long JVMTI_ERROR_UNATTACHED_THREAD;
	public static final long JVMTI_ERROR_UNMODIFIABLE_CLASS;
	public static final long JVMTI_ERROR_UNSUPPORTED_REDEFINITION_CLASS_MODIFIERS_CHANGED;
	public static final long JVMTI_ERROR_UNSUPPORTED_REDEFINITION_HIERARCHY_CHANGED;
	public static final long JVMTI_ERROR_UNSUPPORTED_REDEFINITION_METHOD_ADDED;
	public static final long JVMTI_ERROR_UNSUPPORTED_REDEFINITION_METHOD_DELETED;
	public static final long JVMTI_ERROR_UNSUPPORTED_REDEFINITION_METHOD_MODIFIERS_CHANGED;
	public static final long JVMTI_ERROR_UNSUPPORTED_REDEFINITION_SCHEMA_CHANGED;
	public static final long JVMTI_ERROR_UNSUPPORTED_VERSION;
	public static final long JVMTI_ERROR_WRONG_PHASE;
	public static final long jvmtiErrorEnsureWideEnum;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		JVMTI_ERROR_ABSENT_INFORMATION = 0;
		JVMTI_ERROR_ACCESS_DENIED = 0;
		JVMTI_ERROR_CIRCULAR_CLASS_DEFINITION = 0;
		JVMTI_ERROR_CLASS_LOADER_UNSUPPORTED = 0;
		JVMTI_ERROR_CLASS_NOT_PREPARED = 0;
		JVMTI_ERROR_DUPLICATE = 0;
		JVMTI_ERROR_FAILS_VERIFICATION = 0;
		JVMTI_ERROR_ILLEGAL_ARGUMENT = 0;
		JVMTI_ERROR_INTERNAL = 0;
		JVMTI_ERROR_INTERRUPT = 0;
		JVMTI_ERROR_INVALID_CLASS = 0;
		JVMTI_ERROR_INVALID_CLASS_FORMAT = 0;
		JVMTI_ERROR_INVALID_ENVIRONMENT = 0;
		JVMTI_ERROR_INVALID_EVENT_TYPE = 0;
		JVMTI_ERROR_INVALID_FIELDID = 0;
		JVMTI_ERROR_INVALID_LOCATION = 0;
		JVMTI_ERROR_INVALID_METHODID = 0;
		JVMTI_ERROR_INVALID_MODULE = 0;
		JVMTI_ERROR_INVALID_MONITOR = 0;
		JVMTI_ERROR_INVALID_OBJECT = 0;
		JVMTI_ERROR_INVALID_PRIORITY = 0;
		JVMTI_ERROR_INVALID_SLOT = 0;
		JVMTI_ERROR_INVALID_THREAD = 0;
		JVMTI_ERROR_INVALID_THREAD_GROUP = 0;
		JVMTI_ERROR_INVALID_TYPESTATE = 0;
		JVMTI_ERROR_MAX = 0;
		JVMTI_ERROR_MUST_POSSESS_CAPABILITY = 0;
		JVMTI_ERROR_NAMES_DONT_MATCH = 0;
		JVMTI_ERROR_NATIVE_METHOD = 0;
		JVMTI_ERROR_NONE = 0;
		JVMTI_ERROR_NOT_AVAILABLE = 0;
		JVMTI_ERROR_NOT_FOUND = 0;
		JVMTI_ERROR_NOT_MONITOR_OWNER = 0;
		JVMTI_ERROR_NO_MORE_FRAMES = 0;
		JVMTI_ERROR_NULL_POINTER = 0;
		JVMTI_ERROR_OPAQUE_FRAME = 0;
		JVMTI_ERROR_OUT_OF_MEMORY = 0;
		JVMTI_ERROR_THREAD_NOT_ALIVE = 0;
		JVMTI_ERROR_THREAD_NOT_SUSPENDED = 0;
		JVMTI_ERROR_THREAD_SUSPENDED = 0;
		JVMTI_ERROR_TYPE_MISMATCH = 0;
		JVMTI_ERROR_UNATTACHED_THREAD = 0;
		JVMTI_ERROR_UNMODIFIABLE_CLASS = 0;
		JVMTI_ERROR_UNSUPPORTED_REDEFINITION_CLASS_MODIFIERS_CHANGED = 0;
		JVMTI_ERROR_UNSUPPORTED_REDEFINITION_HIERARCHY_CHANGED = 0;
		JVMTI_ERROR_UNSUPPORTED_REDEFINITION_METHOD_ADDED = 0;
		JVMTI_ERROR_UNSUPPORTED_REDEFINITION_METHOD_DELETED = 0;
		JVMTI_ERROR_UNSUPPORTED_REDEFINITION_METHOD_MODIFIERS_CHANGED = 0;
		JVMTI_ERROR_UNSUPPORTED_REDEFINITION_SCHEMA_CHANGED = 0;
		JVMTI_ERROR_UNSUPPORTED_VERSION = 0;
		JVMTI_ERROR_WRONG_PHASE = 0;
		jvmtiErrorEnsureWideEnum = 0;
	}

}
