/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: shmid_dsPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the shmid_dsPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=shmid_ds.class)
public class shmid_dsPointer extends StructurePointer {

	// NULL
	public static final shmid_dsPointer NULL = new shmid_dsPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected shmid_dsPointer(long address) {
		super(address);
	}

	public static shmid_dsPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static shmid_dsPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static shmid_dsPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new shmid_dsPointer(address);
	}

	public shmid_dsPointer add(long count) {
		return shmid_dsPointer.cast(address + (shmid_ds.SIZEOF * count));
	}

	public shmid_dsPointer add(Scalar count) {
		return add(count.longValue());
	}

	public shmid_dsPointer addOffset(long offset) {
		return shmid_dsPointer.cast(address + offset);
	}

	public shmid_dsPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public shmid_dsPointer sub(long count) {
		return shmid_dsPointer.cast(address - (shmid_ds.SIZEOF * count));
	}

	public shmid_dsPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public shmid_dsPointer subOffset(long offset) {
		return shmid_dsPointer.cast(address - offset);
	}

	public shmid_dsPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public shmid_dsPointer untag(long mask) {
		return shmid_dsPointer.cast(address & ~mask);
	}

	public shmid_dsPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return shmid_ds.SIZEOF;
	}

	// Implementation methods

	// __syscall_ulong_t __unused4
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___unused4Offset_", declaredType="__syscall_ulong_t")
	public UDATA __unused4() throws CorruptDataException {
		return new U64(getLongAtOffset(shmid_ds.___unused4Offset_));
	}

	// __syscall_ulong_t __unused4
	public UDATAPointer __unused4EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(shmid_ds.___unused4Offset_));
	}

	// __syscall_ulong_t __unused5
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___unused5Offset_", declaredType="__syscall_ulong_t")
	public UDATA __unused5() throws CorruptDataException {
		return new U64(getLongAtOffset(shmid_ds.___unused5Offset_));
	}

	// __syscall_ulong_t __unused5
	public UDATAPointer __unused5EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(shmid_ds.___unused5Offset_));
	}

	// __time_t shm_atime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shm_atimeOffset_", declaredType="__time_t")
	public IDATA shm_atime() throws CorruptDataException {
		return new I64(getLongAtOffset(shmid_ds._shm_atimeOffset_));
	}

	// __time_t shm_atime
	public IDATAPointer shm_atimeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(shmid_ds._shm_atimeOffset_));
	}

	// __pid_t shm_cpid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shm_cpidOffset_", declaredType="__pid_t")
	public IDATA shm_cpid() throws CorruptDataException {
		return new I32(getIntAtOffset(shmid_ds._shm_cpidOffset_));
	}

	// __pid_t shm_cpid
	public IDATAPointer shm_cpidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(shmid_ds._shm_cpidOffset_));
	}

	// __time_t shm_ctime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shm_ctimeOffset_", declaredType="__time_t")
	public IDATA shm_ctime() throws CorruptDataException {
		return new I64(getLongAtOffset(shmid_ds._shm_ctimeOffset_));
	}

	// __time_t shm_ctime
	public IDATAPointer shm_ctimeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(shmid_ds._shm_ctimeOffset_));
	}

	// __time_t shm_dtime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shm_dtimeOffset_", declaredType="__time_t")
	public IDATA shm_dtime() throws CorruptDataException {
		return new I64(getLongAtOffset(shmid_ds._shm_dtimeOffset_));
	}

	// __time_t shm_dtime
	public IDATAPointer shm_dtimeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(shmid_ds._shm_dtimeOffset_));
	}

	// __pid_t shm_lpid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shm_lpidOffset_", declaredType="__pid_t")
	public IDATA shm_lpid() throws CorruptDataException {
		return new I32(getIntAtOffset(shmid_ds._shm_lpidOffset_));
	}

	// __pid_t shm_lpid
	public IDATAPointer shm_lpidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(shmid_ds._shm_lpidOffset_));
	}

	// shmatt_t shm_nattch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shm_nattchOffset_", declaredType="shmatt_t")
	public UDATA shm_nattch() throws CorruptDataException {
		return new U64(getLongAtOffset(shmid_ds._shm_nattchOffset_));
	}

	// shmatt_t shm_nattch
	public UDATAPointer shm_nattchEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(shmid_ds._shm_nattchOffset_));
	}

	// ipc_perm shm_perm
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shm_permOffset_", declaredType="ipc_perm")
	public ipc_permPointer shm_perm() throws CorruptDataException {
		return ipc_permPointer.cast(nonNullFieldEA(shmid_ds._shm_permOffset_));
	}

	// ipc_perm shm_perm
	public PointerPointer shm_permEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(shmid_ds._shm_permOffset_));
	}

	// size_t shm_segsz
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shm_segszOffset_", declaredType="size_t")
	public UDATA shm_segsz() throws CorruptDataException {
		return new U64(getLongAtOffset(shmid_ds._shm_segszOffset_));
	}

	// size_t shm_segsz
	public UDATAPointer shm_segszEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(shmid_ds._shm_segszOffset_));
	}

}
