/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _fpstatePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _fpstatePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_fpstate.class)
public class _fpstatePointer extends StructurePointer {

	// NULL
	public static final _fpstatePointer NULL = new _fpstatePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _fpstatePointer(long address) {
		super(address);
	}

	public static _fpstatePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _fpstatePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _fpstatePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _fpstatePointer(address);
	}

	public _fpstatePointer add(long count) {
		return _fpstatePointer.cast(address + (_fpstate.SIZEOF * count));
	}

	public _fpstatePointer add(Scalar count) {
		return add(count.longValue());
	}

	public _fpstatePointer addOffset(long offset) {
		return _fpstatePointer.cast(address + offset);
	}

	public _fpstatePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _fpstatePointer sub(long count) {
		return _fpstatePointer.cast(address - (_fpstate.SIZEOF * count));
	}

	public _fpstatePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _fpstatePointer subOffset(long offset) {
		return _fpstatePointer.cast(address - offset);
	}

	public _fpstatePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _fpstatePointer untag(long mask) {
		return _fpstatePointer.cast(address & ~mask);
	}

	public _fpstatePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _fpstate.SIZEOF;
	}

	// Implementation methods

	// _fpxreg[] _st
	public _fpxregPointer _stEA() throws CorruptDataException {
		return _fpxregPointer.cast(nonNullFieldEA(_fpstate.__stOffset_));
	}

	// _xmmreg[] _xmm
	public _xmmregPointer _xmmEA() throws CorruptDataException {
		return _xmmregPointer.cast(nonNullFieldEA(_fpstate.__xmmOffset_));
	}

	// U16 cwd
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cwdOffset_", declaredType="U16")
	public U16 cwd() throws CorruptDataException {
		return new U16(getShortAtOffset(_fpstate._cwdOffset_));
	}

	// U16 cwd
	public U16Pointer cwdEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_fpstate._cwdOffset_));
	}

	// U16 fop
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fopOffset_", declaredType="U16")
	public U16 fop() throws CorruptDataException {
		return new U16(getShortAtOffset(_fpstate._fopOffset_));
	}

	// U16 fop
	public U16Pointer fopEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_fpstate._fopOffset_));
	}

	// U16 ftw
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ftwOffset_", declaredType="U16")
	public U16 ftw() throws CorruptDataException {
		return new U16(getShortAtOffset(_fpstate._ftwOffset_));
	}

	// U16 ftw
	public U16Pointer ftwEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_fpstate._ftwOffset_));
	}

	// U32 mxcr_mask
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mxcr_maskOffset_", declaredType="U32")
	public UDATA mxcr_mask() throws CorruptDataException {
		return new U32(getIntAtOffset(_fpstate._mxcr_maskOffset_));
	}

	// U32 mxcr_mask
	public UDATAPointer mxcr_maskEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_fpstate._mxcr_maskOffset_));
	}

	// U32 mxcsr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mxcsrOffset_", declaredType="U32")
	public UDATA mxcsr() throws CorruptDataException {
		return new U32(getIntAtOffset(_fpstate._mxcsrOffset_));
	}

	// U32 mxcsr
	public UDATAPointer mxcsrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_fpstate._mxcsrOffset_));
	}

	// U32[] padding
	public UDATAPointer paddingEA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(_fpstate._paddingOffset_));
	}

	// U64 rdp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_rdpOffset_", declaredType="U64")
	public UDATA rdp() throws CorruptDataException {
		return new U64(getLongAtOffset(_fpstate._rdpOffset_));
	}

	// U64 rdp
	public UDATAPointer rdpEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_fpstate._rdpOffset_));
	}

	// U64 rip
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ripOffset_", declaredType="U64")
	public UDATA rip() throws CorruptDataException {
		return new U64(getLongAtOffset(_fpstate._ripOffset_));
	}

	// U64 rip
	public UDATAPointer ripEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_fpstate._ripOffset_));
	}

	// U16 swd
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_swdOffset_", declaredType="U16")
	public U16 swd() throws CorruptDataException {
		return new U16(getShortAtOffset(_fpstate._swdOffset_));
	}

	// U16 swd
	public U16Pointer swdEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_fpstate._swdOffset_));
	}

}
