/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: JVMTINativeInterface_
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class JVMTINativeInterface_ {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _AddCapabilitiesOffset_;
	public static final int _AddModuleExportsOffset_;
	public static final int _AddModuleOpensOffset_;
	public static final int _AddModuleProvidesOffset_;
	public static final int _AddModuleReadsOffset_;
	public static final int _AddModuleUsesOffset_;
	public static final int _AddToBootstrapClassLoaderSearchOffset_;
	public static final int _AddToSystemClassLoaderSearchOffset_;
	public static final int _AllocateOffset_;
	public static final int _ClearBreakpointOffset_;
	public static final int _ClearFieldAccessWatchOffset_;
	public static final int _ClearFieldModificationWatchOffset_;
	public static final int _CreateRawMonitorOffset_;
	public static final int _DeallocateOffset_;
	public static final int _DestroyRawMonitorOffset_;
	public static final int _DisposeEnvironmentOffset_;
	public static final int _FollowReferencesOffset_;
	public static final int _ForceEarlyReturnDoubleOffset_;
	public static final int _ForceEarlyReturnFloatOffset_;
	public static final int _ForceEarlyReturnIntOffset_;
	public static final int _ForceEarlyReturnLongOffset_;
	public static final int _ForceEarlyReturnObjectOffset_;
	public static final int _ForceEarlyReturnVoidOffset_;
	public static final int _ForceGarbageCollectionOffset_;
	public static final int _GenerateEventsOffset_;
	public static final int _GetAllModulesOffset_;
	public static final int _GetAllStackTracesOffset_;
	public static final int _GetAllThreadsOffset_;
	public static final int _GetArgumentsSizeOffset_;
	public static final int _GetAvailableProcessorsOffset_;
	public static final int _GetBytecodesOffset_;
	public static final int _GetCapabilitiesOffset_;
	public static final int _GetClassFieldsOffset_;
	public static final int _GetClassLoaderOffset_;
	public static final int _GetClassLoaderClassesOffset_;
	public static final int _GetClassMethodsOffset_;
	public static final int _GetClassModifiersOffset_;
	public static final int _GetClassSignatureOffset_;
	public static final int _GetClassStatusOffset_;
	public static final int _GetClassVersionNumbersOffset_;
	public static final int _GetConstantPoolOffset_;
	public static final int _GetCurrentContendedMonitorOffset_;
	public static final int _GetCurrentThreadOffset_;
	public static final int _GetCurrentThreadCpuTimeOffset_;
	public static final int _GetCurrentThreadCpuTimerInfoOffset_;
	public static final int _GetEnvironmentLocalStorageOffset_;
	public static final int _GetErrorNameOffset_;
	public static final int _GetExtensionEventsOffset_;
	public static final int _GetExtensionFunctionsOffset_;
	public static final int _GetFieldDeclaringClassOffset_;
	public static final int _GetFieldModifiersOffset_;
	public static final int _GetFieldNameOffset_;
	public static final int _GetFrameCountOffset_;
	public static final int _GetFrameLocationOffset_;
	public static final int _GetImplementedInterfacesOffset_;
	public static final int _GetJLocationFormatOffset_;
	public static final int _GetJNIFunctionTableOffset_;
	public static final int _GetLineNumberTableOffset_;
	public static final int _GetLoadedClassesOffset_;
	public static final int _GetLocalDoubleOffset_;
	public static final int _GetLocalFloatOffset_;
	public static final int _GetLocalInstanceOffset_;
	public static final int _GetLocalIntOffset_;
	public static final int _GetLocalLongOffset_;
	public static final int _GetLocalObjectOffset_;
	public static final int _GetLocalVariableTableOffset_;
	public static final int _GetMaxLocalsOffset_;
	public static final int _GetMethodDeclaringClassOffset_;
	public static final int _GetMethodLocationOffset_;
	public static final int _GetMethodModifiersOffset_;
	public static final int _GetMethodNameOffset_;
	public static final int _GetNamedModuleOffset_;
	public static final int _GetObjectHashCodeOffset_;
	public static final int _GetObjectMonitorUsageOffset_;
	public static final int _GetObjectSizeOffset_;
	public static final int _GetObjectsWithTagsOffset_;
	public static final int _GetOwnedMonitorInfoOffset_;
	public static final int _GetOwnedMonitorStackDepthInfoOffset_;
	public static final int _GetPhaseOffset_;
	public static final int _GetPotentialCapabilitiesOffset_;
	public static final int _GetSourceDebugExtensionOffset_;
	public static final int _GetSourceFileNameOffset_;
	public static final int _GetStackTraceOffset_;
	public static final int _GetSystemPropertiesOffset_;
	public static final int _GetSystemPropertyOffset_;
	public static final int _GetTagOffset_;
	public static final int _GetThreadCpuTimeOffset_;
	public static final int _GetThreadCpuTimerInfoOffset_;
	public static final int _GetThreadGroupChildrenOffset_;
	public static final int _GetThreadGroupInfoOffset_;
	public static final int _GetThreadInfoOffset_;
	public static final int _GetThreadListStackTracesOffset_;
	public static final int _GetThreadLocalStorageOffset_;
	public static final int _GetThreadStateOffset_;
	public static final int _GetTimeOffset_;
	public static final int _GetTimerInfoOffset_;
	public static final int _GetTopThreadGroupsOffset_;
	public static final int _GetVersionNumberOffset_;
	public static final int _InterruptThreadOffset_;
	public static final int _IsArrayClassOffset_;
	public static final int _IsFieldSyntheticOffset_;
	public static final int _IsInterfaceOffset_;
	public static final int _IsMethodNativeOffset_;
	public static final int _IsMethodObsoleteOffset_;
	public static final int _IsMethodSyntheticOffset_;
	public static final int _IsModifiableClassOffset_;
	public static final int _IsModifiableModuleOffset_;
	public static final int _IterateOverHeapOffset_;
	public static final int _IterateOverInstancesOfClassOffset_;
	public static final int _IterateOverObjectsReachableFromObjectOffset_;
	public static final int _IterateOverReachableObjectsOffset_;
	public static final int _IterateThroughHeapOffset_;
	public static final int _NotifyFramePopOffset_;
	public static final int _PopFrameOffset_;
	public static final int _RawMonitorEnterOffset_;
	public static final int _RawMonitorExitOffset_;
	public static final int _RawMonitorNotifyOffset_;
	public static final int _RawMonitorNotifyAllOffset_;
	public static final int _RawMonitorWaitOffset_;
	public static final int _RedefineClassesOffset_;
	public static final int _RelinquishCapabilitiesOffset_;
	public static final int _ResumeAllVirtualThreadsOffset_;
	public static final int _ResumeThreadOffset_;
	public static final int _ResumeThreadListOffset_;
	public static final int _RetransformClassesOffset_;
	public static final int _RunAgentThreadOffset_;
	public static final int _SetBreakpointOffset_;
	public static final int _SetEnvironmentLocalStorageOffset_;
	public static final int _SetEventCallbacksOffset_;
	public static final int _SetEventNotificationModeOffset_;
	public static final int _SetExtensionEventCallbackOffset_;
	public static final int _SetFieldAccessWatchOffset_;
	public static final int _SetFieldModificationWatchOffset_;
	public static final int _SetHeapSamplingIntervalOffset_;
	public static final int _SetJNIFunctionTableOffset_;
	public static final int _SetLocalDoubleOffset_;
	public static final int _SetLocalFloatOffset_;
	public static final int _SetLocalIntOffset_;
	public static final int _SetLocalLongOffset_;
	public static final int _SetLocalObjectOffset_;
	public static final int _SetNativeMethodPrefixOffset_;
	public static final int _SetNativeMethodPrefixesOffset_;
	public static final int _SetSystemPropertyOffset_;
	public static final int _SetTagOffset_;
	public static final int _SetThreadLocalStorageOffset_;
	public static final int _SetVerboseFlagOffset_;
	public static final int _StopThreadOffset_;
	public static final int _SuspendAllVirtualThreadsOffset_;
	public static final int _SuspendThreadOffset_;
	public static final int _SuspendThreadListOffset_;
	public static final int _reserved1Offset_;
	public static final int _reserved105Offset_;
	public static final int _reserved113Offset_;
	public static final int _reserved117Offset_;
	public static final int _reserved141Offset_;
	public static final int _reserved67Offset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_AddCapabilitiesOffset_ = 0;
		_AddModuleExportsOffset_ = 0;
		_AddModuleOpensOffset_ = 0;
		_AddModuleProvidesOffset_ = 0;
		_AddModuleReadsOffset_ = 0;
		_AddModuleUsesOffset_ = 0;
		_AddToBootstrapClassLoaderSearchOffset_ = 0;
		_AddToSystemClassLoaderSearchOffset_ = 0;
		_AllocateOffset_ = 0;
		_ClearBreakpointOffset_ = 0;
		_ClearFieldAccessWatchOffset_ = 0;
		_ClearFieldModificationWatchOffset_ = 0;
		_CreateRawMonitorOffset_ = 0;
		_DeallocateOffset_ = 0;
		_DestroyRawMonitorOffset_ = 0;
		_DisposeEnvironmentOffset_ = 0;
		_FollowReferencesOffset_ = 0;
		_ForceEarlyReturnDoubleOffset_ = 0;
		_ForceEarlyReturnFloatOffset_ = 0;
		_ForceEarlyReturnIntOffset_ = 0;
		_ForceEarlyReturnLongOffset_ = 0;
		_ForceEarlyReturnObjectOffset_ = 0;
		_ForceEarlyReturnVoidOffset_ = 0;
		_ForceGarbageCollectionOffset_ = 0;
		_GenerateEventsOffset_ = 0;
		_GetAllModulesOffset_ = 0;
		_GetAllStackTracesOffset_ = 0;
		_GetAllThreadsOffset_ = 0;
		_GetArgumentsSizeOffset_ = 0;
		_GetAvailableProcessorsOffset_ = 0;
		_GetBytecodesOffset_ = 0;
		_GetCapabilitiesOffset_ = 0;
		_GetClassFieldsOffset_ = 0;
		_GetClassLoaderOffset_ = 0;
		_GetClassLoaderClassesOffset_ = 0;
		_GetClassMethodsOffset_ = 0;
		_GetClassModifiersOffset_ = 0;
		_GetClassSignatureOffset_ = 0;
		_GetClassStatusOffset_ = 0;
		_GetClassVersionNumbersOffset_ = 0;
		_GetConstantPoolOffset_ = 0;
		_GetCurrentContendedMonitorOffset_ = 0;
		_GetCurrentThreadOffset_ = 0;
		_GetCurrentThreadCpuTimeOffset_ = 0;
		_GetCurrentThreadCpuTimerInfoOffset_ = 0;
		_GetEnvironmentLocalStorageOffset_ = 0;
		_GetErrorNameOffset_ = 0;
		_GetExtensionEventsOffset_ = 0;
		_GetExtensionFunctionsOffset_ = 0;
		_GetFieldDeclaringClassOffset_ = 0;
		_GetFieldModifiersOffset_ = 0;
		_GetFieldNameOffset_ = 0;
		_GetFrameCountOffset_ = 0;
		_GetFrameLocationOffset_ = 0;
		_GetImplementedInterfacesOffset_ = 0;
		_GetJLocationFormatOffset_ = 0;
		_GetJNIFunctionTableOffset_ = 0;
		_GetLineNumberTableOffset_ = 0;
		_GetLoadedClassesOffset_ = 0;
		_GetLocalDoubleOffset_ = 0;
		_GetLocalFloatOffset_ = 0;
		_GetLocalInstanceOffset_ = 0;
		_GetLocalIntOffset_ = 0;
		_GetLocalLongOffset_ = 0;
		_GetLocalObjectOffset_ = 0;
		_GetLocalVariableTableOffset_ = 0;
		_GetMaxLocalsOffset_ = 0;
		_GetMethodDeclaringClassOffset_ = 0;
		_GetMethodLocationOffset_ = 0;
		_GetMethodModifiersOffset_ = 0;
		_GetMethodNameOffset_ = 0;
		_GetNamedModuleOffset_ = 0;
		_GetObjectHashCodeOffset_ = 0;
		_GetObjectMonitorUsageOffset_ = 0;
		_GetObjectSizeOffset_ = 0;
		_GetObjectsWithTagsOffset_ = 0;
		_GetOwnedMonitorInfoOffset_ = 0;
		_GetOwnedMonitorStackDepthInfoOffset_ = 0;
		_GetPhaseOffset_ = 0;
		_GetPotentialCapabilitiesOffset_ = 0;
		_GetSourceDebugExtensionOffset_ = 0;
		_GetSourceFileNameOffset_ = 0;
		_GetStackTraceOffset_ = 0;
		_GetSystemPropertiesOffset_ = 0;
		_GetSystemPropertyOffset_ = 0;
		_GetTagOffset_ = 0;
		_GetThreadCpuTimeOffset_ = 0;
		_GetThreadCpuTimerInfoOffset_ = 0;
		_GetThreadGroupChildrenOffset_ = 0;
		_GetThreadGroupInfoOffset_ = 0;
		_GetThreadInfoOffset_ = 0;
		_GetThreadListStackTracesOffset_ = 0;
		_GetThreadLocalStorageOffset_ = 0;
		_GetThreadStateOffset_ = 0;
		_GetTimeOffset_ = 0;
		_GetTimerInfoOffset_ = 0;
		_GetTopThreadGroupsOffset_ = 0;
		_GetVersionNumberOffset_ = 0;
		_InterruptThreadOffset_ = 0;
		_IsArrayClassOffset_ = 0;
		_IsFieldSyntheticOffset_ = 0;
		_IsInterfaceOffset_ = 0;
		_IsMethodNativeOffset_ = 0;
		_IsMethodObsoleteOffset_ = 0;
		_IsMethodSyntheticOffset_ = 0;
		_IsModifiableClassOffset_ = 0;
		_IsModifiableModuleOffset_ = 0;
		_IterateOverHeapOffset_ = 0;
		_IterateOverInstancesOfClassOffset_ = 0;
		_IterateOverObjectsReachableFromObjectOffset_ = 0;
		_IterateOverReachableObjectsOffset_ = 0;
		_IterateThroughHeapOffset_ = 0;
		_NotifyFramePopOffset_ = 0;
		_PopFrameOffset_ = 0;
		_RawMonitorEnterOffset_ = 0;
		_RawMonitorExitOffset_ = 0;
		_RawMonitorNotifyOffset_ = 0;
		_RawMonitorNotifyAllOffset_ = 0;
		_RawMonitorWaitOffset_ = 0;
		_RedefineClassesOffset_ = 0;
		_RelinquishCapabilitiesOffset_ = 0;
		_ResumeAllVirtualThreadsOffset_ = 0;
		_ResumeThreadOffset_ = 0;
		_ResumeThreadListOffset_ = 0;
		_RetransformClassesOffset_ = 0;
		_RunAgentThreadOffset_ = 0;
		_SetBreakpointOffset_ = 0;
		_SetEnvironmentLocalStorageOffset_ = 0;
		_SetEventCallbacksOffset_ = 0;
		_SetEventNotificationModeOffset_ = 0;
		_SetExtensionEventCallbackOffset_ = 0;
		_SetFieldAccessWatchOffset_ = 0;
		_SetFieldModificationWatchOffset_ = 0;
		_SetHeapSamplingIntervalOffset_ = 0;
		_SetJNIFunctionTableOffset_ = 0;
		_SetLocalDoubleOffset_ = 0;
		_SetLocalFloatOffset_ = 0;
		_SetLocalIntOffset_ = 0;
		_SetLocalLongOffset_ = 0;
		_SetLocalObjectOffset_ = 0;
		_SetNativeMethodPrefixOffset_ = 0;
		_SetNativeMethodPrefixesOffset_ = 0;
		_SetSystemPropertyOffset_ = 0;
		_SetTagOffset_ = 0;
		_SetThreadLocalStorageOffset_ = 0;
		_SetVerboseFlagOffset_ = 0;
		_StopThreadOffset_ = 0;
		_SuspendAllVirtualThreadsOffset_ = 0;
		_SuspendThreadOffset_ = 0;
		_SuspendThreadListOffset_ = 0;
		_reserved1Offset_ = 0;
		_reserved105Offset_ = 0;
		_reserved113Offset_ = 0;
		_reserved117Offset_ = 0;
		_reserved141Offset_ = 0;
		_reserved67Offset_ = 0;
	}

}
