/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: MM_ContinuationObjectListPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the MM_ContinuationObjectListPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=MM_ContinuationObjectList.class)
public class MM_ContinuationObjectListPointer extends MM_BaseNonVirtualPointer {

	// NULL
	public static final MM_ContinuationObjectListPointer NULL = new MM_ContinuationObjectListPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected MM_ContinuationObjectListPointer(long address) {
		super(address);
	}

	public static MM_ContinuationObjectListPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static MM_ContinuationObjectListPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static MM_ContinuationObjectListPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new MM_ContinuationObjectListPointer(address);
	}

	public MM_ContinuationObjectListPointer add(long count) {
		return MM_ContinuationObjectListPointer.cast(address + (MM_ContinuationObjectList.SIZEOF * count));
	}

	public MM_ContinuationObjectListPointer add(Scalar count) {
		return add(count.longValue());
	}

	public MM_ContinuationObjectListPointer addOffset(long offset) {
		return MM_ContinuationObjectListPointer.cast(address + offset);
	}

	public MM_ContinuationObjectListPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public MM_ContinuationObjectListPointer sub(long count) {
		return MM_ContinuationObjectListPointer.cast(address - (MM_ContinuationObjectList.SIZEOF * count));
	}

	public MM_ContinuationObjectListPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public MM_ContinuationObjectListPointer subOffset(long offset) {
		return MM_ContinuationObjectListPointer.cast(address - offset);
	}

	public MM_ContinuationObjectListPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public MM_ContinuationObjectListPointer untag(long mask) {
		return MM_ContinuationObjectListPointer.cast(address & ~mask);
	}

	public MM_ContinuationObjectListPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return MM_ContinuationObjectList.SIZEOF;
	}

	// Implementation methods

	// volatile J9Object* _head
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__headOffset_", declaredType="volatile J9Object*")
	public J9ObjectPointer _head() throws CorruptDataException, NoSuchFieldException {
	try {
		return J9ObjectPointer.cast(getPointerAtOffset(MM_ContinuationObjectList.__headOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

	// volatile J9Object* _head
	public PointerPointer _headEA() throws CorruptDataException, NoSuchFieldException {
	try {
		return PointerPointer.cast(nonNullFieldEA(MM_ContinuationObjectList.__headOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

	// MM_ContinuationObjectList* _nextList
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__nextListOffset_", declaredType="MM_ContinuationObjectList*")
	public MM_ContinuationObjectListPointer _nextList() throws CorruptDataException, NoSuchFieldException {
	try {
		return MM_ContinuationObjectListPointer.cast(getPointerAtOffset(MM_ContinuationObjectList.__nextListOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

	// MM_ContinuationObjectList* _nextList
	public PointerPointer _nextListEA() throws CorruptDataException, NoSuchFieldException {
	try {
		return PointerPointer.cast(nonNullFieldEA(MM_ContinuationObjectList.__nextListOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

	// U64 _objectCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__objectCountOffset_", declaredType="U64")
	public UDATA _objectCount() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_ContinuationObjectList.__objectCountOffset_));
	}

	// U64 _objectCount
	public UDATAPointer _objectCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_ContinuationObjectList.__objectCountOffset_));
	}

	// MM_ContinuationObjectList* _previousList
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__previousListOffset_", declaredType="MM_ContinuationObjectList*")
	public MM_ContinuationObjectListPointer _previousList() throws CorruptDataException {
		return MM_ContinuationObjectListPointer.cast(getPointerAtOffset(MM_ContinuationObjectList.__previousListOffset_));
	}

	// MM_ContinuationObjectList* _previousList
	public PointerPointer _previousListEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_ContinuationObjectList.__previousListOffset_));
	}

	// J9Object* _priorHead
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__priorHeadOffset_", declaredType="J9Object*")
	public J9ObjectPointer _priorHead() throws CorruptDataException {
		return J9ObjectPointer.cast(getPointerAtOffset(MM_ContinuationObjectList.__priorHeadOffset_));
	}

	// J9Object* _priorHead
	public PointerPointer _priorHeadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_ContinuationObjectList.__priorHeadOffset_));
	}

}
