/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _MEMORYSTATUSEXPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _MEMORYSTATUSEXPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_MEMORYSTATUSEX.class)
public class _MEMORYSTATUSEXPointer extends StructurePointer {

	// NULL
	public static final _MEMORYSTATUSEXPointer NULL = new _MEMORYSTATUSEXPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _MEMORYSTATUSEXPointer(long address) {
		super(address);
	}

	public static _MEMORYSTATUSEXPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _MEMORYSTATUSEXPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _MEMORYSTATUSEXPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _MEMORYSTATUSEXPointer(address);
	}

	public _MEMORYSTATUSEXPointer add(long count) {
		return _MEMORYSTATUSEXPointer.cast(address + (_MEMORYSTATUSEX.SIZEOF * count));
	}

	public _MEMORYSTATUSEXPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _MEMORYSTATUSEXPointer addOffset(long offset) {
		return _MEMORYSTATUSEXPointer.cast(address + offset);
	}

	public _MEMORYSTATUSEXPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _MEMORYSTATUSEXPointer sub(long count) {
		return _MEMORYSTATUSEXPointer.cast(address - (_MEMORYSTATUSEX.SIZEOF * count));
	}

	public _MEMORYSTATUSEXPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _MEMORYSTATUSEXPointer subOffset(long offset) {
		return _MEMORYSTATUSEXPointer.cast(address - offset);
	}

	public _MEMORYSTATUSEXPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _MEMORYSTATUSEXPointer untag(long mask) {
		return _MEMORYSTATUSEXPointer.cast(address & ~mask);
	}

	public _MEMORYSTATUSEXPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _MEMORYSTATUSEX.SIZEOF;
	}

	// Implementation methods

	// U32 dwLength
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwLengthOffset_", declaredType="U32")
	public UDATA dwLength() throws CorruptDataException {
		return new U32(getIntAtOffset(_MEMORYSTATUSEX._dwLengthOffset_));
	}

	// U32 dwLength
	public UDATAPointer dwLengthEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MEMORYSTATUSEX._dwLengthOffset_));
	}

	// U32 dwMemoryLoad
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwMemoryLoadOffset_", declaredType="U32")
	public UDATA dwMemoryLoad() throws CorruptDataException {
		return new U32(getIntAtOffset(_MEMORYSTATUSEX._dwMemoryLoadOffset_));
	}

	// U32 dwMemoryLoad
	public UDATAPointer dwMemoryLoadEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MEMORYSTATUSEX._dwMemoryLoadOffset_));
	}

	// U64 ullAvailExtendedVirtual
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ullAvailExtendedVirtualOffset_", declaredType="U64")
	public UDATA ullAvailExtendedVirtual() throws CorruptDataException {
		return new U64(getLongAtOffset(_MEMORYSTATUSEX._ullAvailExtendedVirtualOffset_));
	}

	// U64 ullAvailExtendedVirtual
	public UDATAPointer ullAvailExtendedVirtualEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MEMORYSTATUSEX._ullAvailExtendedVirtualOffset_));
	}

	// U64 ullAvailPageFile
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ullAvailPageFileOffset_", declaredType="U64")
	public UDATA ullAvailPageFile() throws CorruptDataException {
		return new U64(getLongAtOffset(_MEMORYSTATUSEX._ullAvailPageFileOffset_));
	}

	// U64 ullAvailPageFile
	public UDATAPointer ullAvailPageFileEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MEMORYSTATUSEX._ullAvailPageFileOffset_));
	}

	// U64 ullAvailPhys
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ullAvailPhysOffset_", declaredType="U64")
	public UDATA ullAvailPhys() throws CorruptDataException {
		return new U64(getLongAtOffset(_MEMORYSTATUSEX._ullAvailPhysOffset_));
	}

	// U64 ullAvailPhys
	public UDATAPointer ullAvailPhysEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MEMORYSTATUSEX._ullAvailPhysOffset_));
	}

	// U64 ullAvailVirtual
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ullAvailVirtualOffset_", declaredType="U64")
	public UDATA ullAvailVirtual() throws CorruptDataException {
		return new U64(getLongAtOffset(_MEMORYSTATUSEX._ullAvailVirtualOffset_));
	}

	// U64 ullAvailVirtual
	public UDATAPointer ullAvailVirtualEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MEMORYSTATUSEX._ullAvailVirtualOffset_));
	}

	// U64 ullTotalPageFile
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ullTotalPageFileOffset_", declaredType="U64")
	public UDATA ullTotalPageFile() throws CorruptDataException {
		return new U64(getLongAtOffset(_MEMORYSTATUSEX._ullTotalPageFileOffset_));
	}

	// U64 ullTotalPageFile
	public UDATAPointer ullTotalPageFileEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MEMORYSTATUSEX._ullTotalPageFileOffset_));
	}

	// U64 ullTotalPhys
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ullTotalPhysOffset_", declaredType="U64")
	public UDATA ullTotalPhys() throws CorruptDataException {
		return new U64(getLongAtOffset(_MEMORYSTATUSEX._ullTotalPhysOffset_));
	}

	// U64 ullTotalPhys
	public UDATAPointer ullTotalPhysEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MEMORYSTATUSEX._ullTotalPhysOffset_));
	}

	// U64 ullTotalVirtual
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ullTotalVirtualOffset_", declaredType="U64")
	public UDATA ullTotalVirtual() throws CorruptDataException {
		return new U64(getLongAtOffset(_MEMORYSTATUSEX._ullTotalVirtualOffset_));
	}

	// U64 ullTotalVirtual
	public UDATAPointer ullTotalVirtualEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_MEMORYSTATUSEX._ullTotalVirtualOffset_));
	}

}
