/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: jvmtiVThreadCallBackDataPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the jvmtiVThreadCallBackDataPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=jvmtiVThreadCallBackData.class)
public class jvmtiVThreadCallBackDataPointer extends StructurePointer {

	// NULL
	public static final jvmtiVThreadCallBackDataPointer NULL = new jvmtiVThreadCallBackDataPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected jvmtiVThreadCallBackDataPointer(long address) {
		super(address);
	}

	public static jvmtiVThreadCallBackDataPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static jvmtiVThreadCallBackDataPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static jvmtiVThreadCallBackDataPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new jvmtiVThreadCallBackDataPointer(address);
	}

	public jvmtiVThreadCallBackDataPointer add(long count) {
		return jvmtiVThreadCallBackDataPointer.cast(address + (jvmtiVThreadCallBackData.SIZEOF * count));
	}

	public jvmtiVThreadCallBackDataPointer add(Scalar count) {
		return add(count.longValue());
	}

	public jvmtiVThreadCallBackDataPointer addOffset(long offset) {
		return jvmtiVThreadCallBackDataPointer.cast(address + offset);
	}

	public jvmtiVThreadCallBackDataPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public jvmtiVThreadCallBackDataPointer sub(long count) {
		return jvmtiVThreadCallBackDataPointer.cast(address - (jvmtiVThreadCallBackData.SIZEOF * count));
	}

	public jvmtiVThreadCallBackDataPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public jvmtiVThreadCallBackDataPointer subOffset(long offset) {
		return jvmtiVThreadCallBackDataPointer.cast(address - offset);
	}

	public jvmtiVThreadCallBackDataPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public jvmtiVThreadCallBackDataPointer untag(long mask) {
		return jvmtiVThreadCallBackDataPointer.cast(address & ~mask);
	}

	public jvmtiVThreadCallBackDataPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return jvmtiVThreadCallBackData.SIZEOF;
	}

	// Implementation methods

	// I32 except_count
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_except_countOffset_", declaredType="I32")
	public IDATA except_count() throws CorruptDataException {
		return new I32(getIntAtOffset(jvmtiVThreadCallBackData._except_countOffset_));
	}

	// I32 except_count
	public IDATAPointer except_countEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(jvmtiVThreadCallBackData._except_countOffset_));
	}

	// const void** except_list
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_except_listOffset_", declaredType="const void**")
	public PointerPointer except_list() throws CorruptDataException {
		return PointerPointer.cast(getPointerAtOffset(jvmtiVThreadCallBackData._except_listOffset_));
	}

	// const void** except_list
	public PointerPointer except_listEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(jvmtiVThreadCallBackData._except_listOffset_));
	}

	// U64 is_suspend
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_is_suspendOffset_", declaredType="U64")
	public UDATA is_suspend() throws CorruptDataException {
		return new U64(getLongAtOffset(jvmtiVThreadCallBackData._is_suspendOffset_));
	}

	// U64 is_suspend
	public UDATAPointer is_suspendEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(jvmtiVThreadCallBackData._is_suspendOffset_));
	}

	// U64 suspend_current_thread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_suspend_current_threadOffset_", declaredType="U64")
	public UDATA suspend_current_thread() throws CorruptDataException {
		return new U64(getLongAtOffset(jvmtiVThreadCallBackData._suspend_current_threadOffset_));
	}

	// U64 suspend_current_thread
	public UDATAPointer suspend_current_threadEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(jvmtiVThreadCallBackData._suspend_current_threadOffset_));
	}

}
