/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: ConstantPoolMap
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class ConstantPoolMap {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __bufferManagerOffset_;
	public static final int __buildResultOffset_;
	public static final int __callSiteCountOffset_;
	public static final int __classFileOracleOffset_;
	public static final int __constantPoolEntriesOffset_;
	public static final int __contextOffset_;
	public static final int __invokeCacheCountOffset_;
	public static final int __ramConstantPoolCountOffset_;
	public static final int __romConstantPoolCountOffset_;
	public static final int __romConstantPoolEntriesOffset_;
	public static final int __romConstantPoolTypesOffset_;
	public static final int __specialSplitEntriesOffset_;
	public static final int __specialSplitEntryCountOffset_;
	public static final int __staticSplitEntriesOffset_;
	public static final int __staticSplitEntryCountOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__bufferManagerOffset_ = 0;
		__buildResultOffset_ = 0;
		__callSiteCountOffset_ = 0;
		__classFileOracleOffset_ = 0;
		__constantPoolEntriesOffset_ = 0;
		__contextOffset_ = 0;
		__invokeCacheCountOffset_ = 0;
		__ramConstantPoolCountOffset_ = 0;
		__romConstantPoolCountOffset_ = 0;
		__romConstantPoolEntriesOffset_ = 0;
		__romConstantPoolTypesOffset_ = 0;
		__specialSplitEntriesOffset_ = 0;
		__specialSplitEntryCountOffset_ = 0;
		__staticSplitEntriesOffset_ = 0;
		__staticSplitEntryCountOffset_ = 0;
	}

}
