/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: _PEB
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class _PEB {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _AtlThunkSListPtrOffset_;
	public static final int _AtlThunkSListPtr32Offset_;
	public static final int _BeingDebuggedOffset_;
	public static final int _LdrOffset_;
	public static final int _PostProcessInitRoutineOffset_;
	public static final int _ProcessParametersOffset_;
	public static final int _Reserved1Offset_;
	public static final int _Reserved10Offset_;
	public static final int _Reserved11Offset_;
	public static final int _Reserved12Offset_;
	public static final int _Reserved2Offset_;
	public static final int _Reserved3Offset_;
	public static final int _Reserved4Offset_;
	public static final int _Reserved5Offset_;
	public static final int _Reserved6Offset_;
	public static final int _Reserved7Offset_;
	public static final int _Reserved8Offset_;
	public static final int _Reserved9Offset_;
	public static final int _SessionIdOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_AtlThunkSListPtrOffset_ = 0;
		_AtlThunkSListPtr32Offset_ = 0;
		_BeingDebuggedOffset_ = 0;
		_LdrOffset_ = 0;
		_PostProcessInitRoutineOffset_ = 0;
		_ProcessParametersOffset_ = 0;
		_Reserved1Offset_ = 0;
		_Reserved10Offset_ = 0;
		_Reserved11Offset_ = 0;
		_Reserved12Offset_ = 0;
		_Reserved2Offset_ = 0;
		_Reserved3Offset_ = 0;
		_Reserved4Offset_ = 0;
		_Reserved5Offset_ = 0;
		_Reserved6Offset_ = 0;
		_Reserved7Offset_ = 0;
		_Reserved8Offset_ = 0;
		_Reserved9Offset_ = 0;
		_SessionIdOffset_ = 0;
	}

}
