/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: ModuleEntryPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the ModuleEntryPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=ModuleEntry.class)
public class ModuleEntryPointer extends StructurePointer {

	// NULL
	public static final ModuleEntryPointer NULL = new ModuleEntryPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected ModuleEntryPointer(long address) {
		super(address);
	}

	public static ModuleEntryPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static ModuleEntryPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static ModuleEntryPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new ModuleEntryPointer(address);
	}

	public ModuleEntryPointer add(long count) {
		return ModuleEntryPointer.cast(address + (ModuleEntry.SIZEOF * count));
	}

	public ModuleEntryPointer add(Scalar count) {
		return add(count.longValue());
	}

	public ModuleEntryPointer addOffset(long offset) {
		return ModuleEntryPointer.cast(address + offset);
	}

	public ModuleEntryPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public ModuleEntryPointer sub(long count) {
		return ModuleEntryPointer.cast(address - (ModuleEntry.SIZEOF * count));
	}

	public ModuleEntryPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public ModuleEntryPointer subOffset(long offset) {
		return ModuleEntryPointer.cast(address - offset);
	}

	public ModuleEntryPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public ModuleEntryPointer untag(long mask) {
		return ModuleEntryPointer.cast(address & ~mask);
	}

	public ModuleEntryPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return ModuleEntry.SIZEOF;
	}

	// Implementation methods

	// U32 classLoaderIndex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_classLoaderIndexOffset_", declaredType="U32")
	public UDATA classLoaderIndex() throws CorruptDataException {
		return new U32(getIntAtOffset(ModuleEntry._classLoaderIndexOffset_));
	}

	// U32 classLoaderIndex
	public UDATAPointer classLoaderIndexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ModuleEntry._classLoaderIndexOffset_));
	}

	// U32 index
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_indexOffset_", declaredType="U32")
	public UDATA index() throws CorruptDataException {
		return new U32(getIntAtOffset(ModuleEntry._indexOffset_));
	}

	// U32 index
	public UDATAPointer indexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ModuleEntry._indexOffset_));
	}

	// U32 locationStringUTF8Index
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_locationStringUTF8IndexOffset_", declaredType="U32")
	public UDATA locationStringUTF8Index() throws CorruptDataException {
		return new U32(getIntAtOffset(ModuleEntry._locationStringUTF8IndexOffset_));
	}

	// U32 locationStringUTF8Index
	public UDATAPointer locationStringUTF8IndexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ModuleEntry._locationStringUTF8IndexOffset_));
	}

	// J9Module* module
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_moduleOffset_", declaredType="J9Module*")
	public J9ModulePointer module() throws CorruptDataException {
		return J9ModulePointer.cast(getPointerAtOffset(ModuleEntry._moduleOffset_));
	}

	// J9Module* module
	public PointerPointer moduleEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ModuleEntry._moduleOffset_));
	}

	// U32 nameStringIndex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nameStringIndexOffset_", declaredType="U32")
	public UDATA nameStringIndex() throws CorruptDataException {
		return new U32(getIntAtOffset(ModuleEntry._nameStringIndexOffset_));
	}

	// U32 nameStringIndex
	public UDATAPointer nameStringIndexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ModuleEntry._nameStringIndexOffset_));
	}

	// ModuleEntry* next
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nextOffset_", declaredType="ModuleEntry*")
	public ModuleEntryPointer next() throws CorruptDataException {
		return ModuleEntryPointer.cast(getPointerAtOffset(ModuleEntry._nextOffset_));
	}

	// ModuleEntry* next
	public PointerPointer nextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ModuleEntry._nextOffset_));
	}

	// U32 versionStringIndex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_versionStringIndexOffset_", declaredType="U32")
	public UDATA versionStringIndex() throws CorruptDataException {
		return new U32(getIntAtOffset(ModuleEntry._versionStringIndexOffset_));
	}

	// U32 versionStringIndex
	public UDATAPointer versionStringIndexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ModuleEntry._versionStringIndexOffset_));
	}

}
