/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: WriteOnceCompactTableEntryPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the WriteOnceCompactTableEntryPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=WriteOnceCompactTableEntry.class)
public class WriteOnceCompactTableEntryPointer extends StructurePointer {

	// NULL
	public static final WriteOnceCompactTableEntryPointer NULL = new WriteOnceCompactTableEntryPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected WriteOnceCompactTableEntryPointer(long address) {
		super(address);
	}

	public static WriteOnceCompactTableEntryPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static WriteOnceCompactTableEntryPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static WriteOnceCompactTableEntryPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new WriteOnceCompactTableEntryPointer(address);
	}

	public WriteOnceCompactTableEntryPointer add(long count) {
		return WriteOnceCompactTableEntryPointer.cast(address + (WriteOnceCompactTableEntry.SIZEOF * count));
	}

	public WriteOnceCompactTableEntryPointer add(Scalar count) {
		return add(count.longValue());
	}

	public WriteOnceCompactTableEntryPointer addOffset(long offset) {
		return WriteOnceCompactTableEntryPointer.cast(address + offset);
	}

	public WriteOnceCompactTableEntryPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public WriteOnceCompactTableEntryPointer sub(long count) {
		return WriteOnceCompactTableEntryPointer.cast(address - (WriteOnceCompactTableEntry.SIZEOF * count));
	}

	public WriteOnceCompactTableEntryPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public WriteOnceCompactTableEntryPointer subOffset(long offset) {
		return WriteOnceCompactTableEntryPointer.cast(address - offset);
	}

	public WriteOnceCompactTableEntryPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public WriteOnceCompactTableEntryPointer untag(long mask) {
		return WriteOnceCompactTableEntryPointer.cast(address & ~mask);
	}

	public WriteOnceCompactTableEntryPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return WriteOnceCompactTableEntry.SIZEOF;
	}

	// Implementation methods

	// J9Object* _destinationAddress
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__destinationAddressOffset_", declaredType="J9Object*")
	public J9ObjectPointer _destinationAddress() throws CorruptDataException {
		return J9ObjectPointer.cast(getPointerAtOffset(WriteOnceCompactTableEntry.__destinationAddressOffset_));
	}

	// J9Object* _destinationAddress
	public PointerPointer _destinationAddressEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(WriteOnceCompactTableEntry.__destinationAddressOffset_));
	}

	// U64 _growBits
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__growBitsOffset_", declaredType="U64")
	public UDATA _growBits() throws CorruptDataException {
		return new U64(getLongAtOffset(WriteOnceCompactTableEntry.__growBitsOffset_));
	}

	// U64 _growBits
	public UDATAPointer _growBitsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(WriteOnceCompactTableEntry.__growBitsOffset_));
	}

}
