/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _IMAGE_LOAD_CONFIG_CODE_INTEGRITYPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _IMAGE_LOAD_CONFIG_CODE_INTEGRITYPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_IMAGE_LOAD_CONFIG_CODE_INTEGRITY.class)
public class _IMAGE_LOAD_CONFIG_CODE_INTEGRITYPointer extends StructurePointer {

	// NULL
	public static final _IMAGE_LOAD_CONFIG_CODE_INTEGRITYPointer NULL = new _IMAGE_LOAD_CONFIG_CODE_INTEGRITYPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _IMAGE_LOAD_CONFIG_CODE_INTEGRITYPointer(long address) {
		super(address);
	}

	public static _IMAGE_LOAD_CONFIG_CODE_INTEGRITYPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _IMAGE_LOAD_CONFIG_CODE_INTEGRITYPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _IMAGE_LOAD_CONFIG_CODE_INTEGRITYPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _IMAGE_LOAD_CONFIG_CODE_INTEGRITYPointer(address);
	}

	public _IMAGE_LOAD_CONFIG_CODE_INTEGRITYPointer add(long count) {
		return _IMAGE_LOAD_CONFIG_CODE_INTEGRITYPointer.cast(address + (_IMAGE_LOAD_CONFIG_CODE_INTEGRITY.SIZEOF * count));
	}

	public _IMAGE_LOAD_CONFIG_CODE_INTEGRITYPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _IMAGE_LOAD_CONFIG_CODE_INTEGRITYPointer addOffset(long offset) {
		return _IMAGE_LOAD_CONFIG_CODE_INTEGRITYPointer.cast(address + offset);
	}

	public _IMAGE_LOAD_CONFIG_CODE_INTEGRITYPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _IMAGE_LOAD_CONFIG_CODE_INTEGRITYPointer sub(long count) {
		return _IMAGE_LOAD_CONFIG_CODE_INTEGRITYPointer.cast(address - (_IMAGE_LOAD_CONFIG_CODE_INTEGRITY.SIZEOF * count));
	}

	public _IMAGE_LOAD_CONFIG_CODE_INTEGRITYPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _IMAGE_LOAD_CONFIG_CODE_INTEGRITYPointer subOffset(long offset) {
		return _IMAGE_LOAD_CONFIG_CODE_INTEGRITYPointer.cast(address - offset);
	}

	public _IMAGE_LOAD_CONFIG_CODE_INTEGRITYPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _IMAGE_LOAD_CONFIG_CODE_INTEGRITYPointer untag(long mask) {
		return _IMAGE_LOAD_CONFIG_CODE_INTEGRITYPointer.cast(address & ~mask);
	}

	public _IMAGE_LOAD_CONFIG_CODE_INTEGRITYPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _IMAGE_LOAD_CONFIG_CODE_INTEGRITY.SIZEOF;
	}

	// Implementation methods

	// U16 Catalog
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_CatalogOffset_", declaredType="U16")
	public U16 Catalog() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_LOAD_CONFIG_CODE_INTEGRITY._CatalogOffset_));
	}

	// U16 Catalog
	public U16Pointer CatalogEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_LOAD_CONFIG_CODE_INTEGRITY._CatalogOffset_));
	}

	// U32 CatalogOffset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_CatalogOffsetOffset_", declaredType="U32")
	public UDATA CatalogOffset() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGE_LOAD_CONFIG_CODE_INTEGRITY._CatalogOffsetOffset_));
	}

	// U32 CatalogOffset
	public UDATAPointer CatalogOffsetEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_LOAD_CONFIG_CODE_INTEGRITY._CatalogOffsetOffset_));
	}

	// U16 Flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_FlagsOffset_", declaredType="U16")
	public U16 Flags() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_LOAD_CONFIG_CODE_INTEGRITY._FlagsOffset_));
	}

	// U16 Flags
	public U16Pointer FlagsEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_LOAD_CONFIG_CODE_INTEGRITY._FlagsOffset_));
	}

	// U32 Reserved
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ReservedOffset_", declaredType="U32")
	public UDATA Reserved() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGE_LOAD_CONFIG_CODE_INTEGRITY._ReservedOffset_));
	}

	// U32 Reserved
	public UDATAPointer ReservedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_LOAD_CONFIG_CODE_INTEGRITY._ReservedOffset_));
	}

}
