/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _KEY_EVENT_RECORDPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _KEY_EVENT_RECORDPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_KEY_EVENT_RECORD.class)
public class _KEY_EVENT_RECORDPointer extends StructurePointer {

	// NULL
	public static final _KEY_EVENT_RECORDPointer NULL = new _KEY_EVENT_RECORDPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _KEY_EVENT_RECORDPointer(long address) {
		super(address);
	}

	public static _KEY_EVENT_RECORDPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _KEY_EVENT_RECORDPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _KEY_EVENT_RECORDPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _KEY_EVENT_RECORDPointer(address);
	}

	public _KEY_EVENT_RECORDPointer add(long count) {
		return _KEY_EVENT_RECORDPointer.cast(address + (_KEY_EVENT_RECORD.SIZEOF * count));
	}

	public _KEY_EVENT_RECORDPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _KEY_EVENT_RECORDPointer addOffset(long offset) {
		return _KEY_EVENT_RECORDPointer.cast(address + offset);
	}

	public _KEY_EVENT_RECORDPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _KEY_EVENT_RECORDPointer sub(long count) {
		return _KEY_EVENT_RECORDPointer.cast(address - (_KEY_EVENT_RECORD.SIZEOF * count));
	}

	public _KEY_EVENT_RECORDPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _KEY_EVENT_RECORDPointer subOffset(long offset) {
		return _KEY_EVENT_RECORDPointer.cast(address - offset);
	}

	public _KEY_EVENT_RECORDPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _KEY_EVENT_RECORDPointer untag(long mask) {
		return _KEY_EVENT_RECORDPointer.cast(address & ~mask);
	}

	public _KEY_EVENT_RECORDPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _KEY_EVENT_RECORD.SIZEOF;
	}

	// Implementation methods

	// I32 bKeyDown
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_bKeyDownOffset_", declaredType="I32")
	public IDATA bKeyDown() throws CorruptDataException {
		return new I32(getIntAtOffset(_KEY_EVENT_RECORD._bKeyDownOffset_));
	}

	// I32 bKeyDown
	public IDATAPointer bKeyDownEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_KEY_EVENT_RECORD._bKeyDownOffset_));
	}

	// U32 dwControlKeyState
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwControlKeyStateOffset_", declaredType="U32")
	public UDATA dwControlKeyState() throws CorruptDataException {
		return new U32(getIntAtOffset(_KEY_EVENT_RECORD._dwControlKeyStateOffset_));
	}

	// U32 dwControlKeyState
	public UDATAPointer dwControlKeyStateEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_KEY_EVENT_RECORD._dwControlKeyStateOffset_));
	}

	// void uChar
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_uCharOffset_", declaredType="void")
	public VoidPointer uChar() throws CorruptDataException {
		return VoidPointer.cast(nonNullFieldEA(_KEY_EVENT_RECORD._uCharOffset_));
	}

	// void uChar
	public PointerPointer uCharEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_KEY_EVENT_RECORD._uCharOffset_));
	}

	// U16 wRepeatCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wRepeatCountOffset_", declaredType="U16")
	public U16 wRepeatCount() throws CorruptDataException {
		return new U16(getShortAtOffset(_KEY_EVENT_RECORD._wRepeatCountOffset_));
	}

	// U16 wRepeatCount
	public U16Pointer wRepeatCountEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_KEY_EVENT_RECORD._wRepeatCountOffset_));
	}

	// U16 wVirtualKeyCode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wVirtualKeyCodeOffset_", declaredType="U16")
	public U16 wVirtualKeyCode() throws CorruptDataException {
		return new U16(getShortAtOffset(_KEY_EVENT_RECORD._wVirtualKeyCodeOffset_));
	}

	// U16 wVirtualKeyCode
	public U16Pointer wVirtualKeyCodeEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_KEY_EVENT_RECORD._wVirtualKeyCodeOffset_));
	}

	// U16 wVirtualScanCode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wVirtualScanCodeOffset_", declaredType="U16")
	public U16 wVirtualScanCode() throws CorruptDataException {
		return new U16(getShortAtOffset(_KEY_EVENT_RECORD._wVirtualScanCodeOffset_));
	}

	// U16 wVirtualScanCode
	public U16Pointer wVirtualScanCodeEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_KEY_EVENT_RECORD._wVirtualScanCodeOffset_));
	}

}
