/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _UNWIND_HISTORY_TABLEPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _UNWIND_HISTORY_TABLEPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_UNWIND_HISTORY_TABLE.class)
public class _UNWIND_HISTORY_TABLEPointer extends StructurePointer {

	// NULL
	public static final _UNWIND_HISTORY_TABLEPointer NULL = new _UNWIND_HISTORY_TABLEPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _UNWIND_HISTORY_TABLEPointer(long address) {
		super(address);
	}

	public static _UNWIND_HISTORY_TABLEPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _UNWIND_HISTORY_TABLEPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _UNWIND_HISTORY_TABLEPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _UNWIND_HISTORY_TABLEPointer(address);
	}

	public _UNWIND_HISTORY_TABLEPointer add(long count) {
		return _UNWIND_HISTORY_TABLEPointer.cast(address + (_UNWIND_HISTORY_TABLE.SIZEOF * count));
	}

	public _UNWIND_HISTORY_TABLEPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _UNWIND_HISTORY_TABLEPointer addOffset(long offset) {
		return _UNWIND_HISTORY_TABLEPointer.cast(address + offset);
	}

	public _UNWIND_HISTORY_TABLEPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _UNWIND_HISTORY_TABLEPointer sub(long count) {
		return _UNWIND_HISTORY_TABLEPointer.cast(address - (_UNWIND_HISTORY_TABLE.SIZEOF * count));
	}

	public _UNWIND_HISTORY_TABLEPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _UNWIND_HISTORY_TABLEPointer subOffset(long offset) {
		return _UNWIND_HISTORY_TABLEPointer.cast(address - offset);
	}

	public _UNWIND_HISTORY_TABLEPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _UNWIND_HISTORY_TABLEPointer untag(long mask) {
		return _UNWIND_HISTORY_TABLEPointer.cast(address & ~mask);
	}

	public _UNWIND_HISTORY_TABLEPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _UNWIND_HISTORY_TABLE.SIZEOF;
	}

	// Implementation methods

	// U32 Count
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_CountOffset_", declaredType="U32")
	public UDATA Count() throws CorruptDataException {
		return new U32(getIntAtOffset(_UNWIND_HISTORY_TABLE._CountOffset_));
	}

	// U32 Count
	public UDATAPointer CountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_UNWIND_HISTORY_TABLE._CountOffset_));
	}

	// _UNWIND_HISTORY_TABLE_ENTRY[] Entry
	public _UNWIND_HISTORY_TABLE_ENTRYPointer EntryEA() throws CorruptDataException {
		return _UNWIND_HISTORY_TABLE_ENTRYPointer.cast(nonNullFieldEA(_UNWIND_HISTORY_TABLE._EntryOffset_));
	}

	// U8 GlobalHint
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_GlobalHintOffset_", declaredType="U8")
	public U8 GlobalHint() throws CorruptDataException {
		return new U8(getByteAtOffset(_UNWIND_HISTORY_TABLE._GlobalHintOffset_));
	}

	// U8 GlobalHint
	public U8Pointer GlobalHintEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_UNWIND_HISTORY_TABLE._GlobalHintOffset_));
	}

	// U64 HighAddress
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_HighAddressOffset_", declaredType="U64")
	public UDATA HighAddress() throws CorruptDataException {
		return new U64(getLongAtOffset(_UNWIND_HISTORY_TABLE._HighAddressOffset_));
	}

	// U64 HighAddress
	public UDATAPointer HighAddressEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_UNWIND_HISTORY_TABLE._HighAddressOffset_));
	}

	// U8 LocalHint
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_LocalHintOffset_", declaredType="U8")
	public U8 LocalHint() throws CorruptDataException {
		return new U8(getByteAtOffset(_UNWIND_HISTORY_TABLE._LocalHintOffset_));
	}

	// U8 LocalHint
	public U8Pointer LocalHintEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_UNWIND_HISTORY_TABLE._LocalHintOffset_));
	}

	// U64 LowAddress
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_LowAddressOffset_", declaredType="U64")
	public UDATA LowAddress() throws CorruptDataException {
		return new U64(getLongAtOffset(_UNWIND_HISTORY_TABLE._LowAddressOffset_));
	}

	// U64 LowAddress
	public UDATAPointer LowAddressEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_UNWIND_HISTORY_TABLE._LowAddressOffset_));
	}

	// U8 Once
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_OnceOffset_", declaredType="U8")
	public U8 Once() throws CorruptDataException {
		return new U8(getByteAtOffset(_UNWIND_HISTORY_TABLE._OnceOffset_));
	}

	// U8 Once
	public U8Pointer OnceEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_UNWIND_HISTORY_TABLE._OnceOffset_));
	}

	// U8 Search
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SearchOffset_", declaredType="U8")
	public U8 Search() throws CorruptDataException {
		return new U8(getByteAtOffset(_UNWIND_HISTORY_TABLE._SearchOffset_));
	}

	// U8 Search
	public U8Pointer SearchEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_UNWIND_HISTORY_TABLE._SearchOffset_));
	}

}
