/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9CfrConstantPoolInfo
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9CfrConstantPoolInfo {

	// VM Constants

	public static final long SIZEOF;
	public static final long CFR_CONSTANT_Class;
	public static final long CFR_CONSTANT_Double;
	public static final long CFR_CONSTANT_Fieldref;
	public static final long CFR_CONSTANT_Float;
	public static final long CFR_CONSTANT_Integer;
	public static final long CFR_CONSTANT_InterfaceMethodref;
	public static final long CFR_CONSTANT_InvokeDynamic;
	public static final long CFR_CONSTANT_Long;
	public static final long CFR_CONSTANT_MethodHandle;
	public static final long CFR_CONSTANT_MethodType;
	public static final long CFR_CONSTANT_Methodref;
	public static final long CFR_CONSTANT_NameAndType;
	public static final long CFR_CONSTANT_Null;
	public static final long CFR_CONSTANT_String;
	public static final long CFR_CONSTANT_Utf8;
	public static final long CFR_FLAGS1_VerifiedFieldSignature;
	public static final long CFR_FLAGS1_VerifiedMemberName;
	public static final long CFR_ReferencedBit;
	public static final long CFR_ReferencedMask;
	public static final long CFR_SeenByConvertInvokevirtualToSpecial;
	public static final long CFR_ShouldConvertInvokevirtualToSpecial;

	// Offsets

	public static final int _bytesOffset_;
	public static final int _flags1Offset_;
	public static final int _nextCPIndexOffset_;
	public static final int _romAddressOffset_;
	public static final int _slot1Offset_;
	public static final int _slot2Offset_;
	public static final int _tagOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		CFR_CONSTANT_Class = 0;
		CFR_CONSTANT_Double = 0;
		CFR_CONSTANT_Fieldref = 0;
		CFR_CONSTANT_Float = 0;
		CFR_CONSTANT_Integer = 0;
		CFR_CONSTANT_InterfaceMethodref = 0;
		CFR_CONSTANT_InvokeDynamic = 0;
		CFR_CONSTANT_Long = 0;
		CFR_CONSTANT_MethodHandle = 0;
		CFR_CONSTANT_MethodType = 0;
		CFR_CONSTANT_Methodref = 0;
		CFR_CONSTANT_NameAndType = 0;
		CFR_CONSTANT_Null = 0;
		CFR_CONSTANT_String = 0;
		CFR_CONSTANT_Utf8 = 0;
		CFR_FLAGS1_VerifiedFieldSignature = 0;
		CFR_FLAGS1_VerifiedMemberName = 0;
		CFR_ReferencedBit = 0;
		CFR_ReferencedMask = 0;
		CFR_SeenByConvertInvokevirtualToSpecial = 0;
		CFR_ShouldConvertInvokevirtualToSpecial = 0;
		_bytesOffset_ = 0;
		_flags1Offset_ = 0;
		_nextCPIndexOffset_ = 0;
		_romAddressOffset_ = 0;
		_slot1Offset_ = 0;
		_slot2Offset_ = 0;
		_tagOffset_ = 0;
	}

}
