/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: HINSTANCE__Pointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the HINSTANCE__Pointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=HINSTANCE__.class)
public class HINSTANCE__Pointer extends StructurePointer {

	// NULL
	public static final HINSTANCE__Pointer NULL = new HINSTANCE__Pointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected HINSTANCE__Pointer(long address) {
		super(address);
	}

	public static HINSTANCE__Pointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static HINSTANCE__Pointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static HINSTANCE__Pointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new HINSTANCE__Pointer(address);
	}

	public HINSTANCE__Pointer add(long count) {
		return HINSTANCE__Pointer.cast(address + (HINSTANCE__.SIZEOF * count));
	}

	public HINSTANCE__Pointer add(Scalar count) {
		return add(count.longValue());
	}

	public HINSTANCE__Pointer addOffset(long offset) {
		return HINSTANCE__Pointer.cast(address + offset);
	}

	public HINSTANCE__Pointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public HINSTANCE__Pointer sub(long count) {
		return HINSTANCE__Pointer.cast(address - (HINSTANCE__.SIZEOF * count));
	}

	public HINSTANCE__Pointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public HINSTANCE__Pointer subOffset(long offset) {
		return HINSTANCE__Pointer.cast(address - offset);
	}

	public HINSTANCE__Pointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public HINSTANCE__Pointer untag(long mask) {
		return HINSTANCE__Pointer.cast(address & ~mask);
	}

	public HINSTANCE__Pointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return HINSTANCE__.SIZEOF;
	}

	// Implementation methods

	// I32 unused
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_unusedOffset_", declaredType="I32")
	public IDATA unused() throws CorruptDataException {
		return new I32(getIntAtOffset(HINSTANCE__._unusedOffset_));
	}

	// I32 unused
	public IDATAPointer unusedEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(HINSTANCE__._unusedOffset_));
	}

}
