/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _IMAGE_OPTIONAL_HEADER64Pointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _IMAGE_OPTIONAL_HEADER64Pointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_IMAGE_OPTIONAL_HEADER64.class)
public class _IMAGE_OPTIONAL_HEADER64Pointer extends StructurePointer {

	// NULL
	public static final _IMAGE_OPTIONAL_HEADER64Pointer NULL = new _IMAGE_OPTIONAL_HEADER64Pointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _IMAGE_OPTIONAL_HEADER64Pointer(long address) {
		super(address);
	}

	public static _IMAGE_OPTIONAL_HEADER64Pointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _IMAGE_OPTIONAL_HEADER64Pointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _IMAGE_OPTIONAL_HEADER64Pointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _IMAGE_OPTIONAL_HEADER64Pointer(address);
	}

	public _IMAGE_OPTIONAL_HEADER64Pointer add(long count) {
		return _IMAGE_OPTIONAL_HEADER64Pointer.cast(address + (_IMAGE_OPTIONAL_HEADER64.SIZEOF * count));
	}

	public _IMAGE_OPTIONAL_HEADER64Pointer add(Scalar count) {
		return add(count.longValue());
	}

	public _IMAGE_OPTIONAL_HEADER64Pointer addOffset(long offset) {
		return _IMAGE_OPTIONAL_HEADER64Pointer.cast(address + offset);
	}

	public _IMAGE_OPTIONAL_HEADER64Pointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _IMAGE_OPTIONAL_HEADER64Pointer sub(long count) {
		return _IMAGE_OPTIONAL_HEADER64Pointer.cast(address - (_IMAGE_OPTIONAL_HEADER64.SIZEOF * count));
	}

	public _IMAGE_OPTIONAL_HEADER64Pointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _IMAGE_OPTIONAL_HEADER64Pointer subOffset(long offset) {
		return _IMAGE_OPTIONAL_HEADER64Pointer.cast(address - offset);
	}

	public _IMAGE_OPTIONAL_HEADER64Pointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _IMAGE_OPTIONAL_HEADER64Pointer untag(long mask) {
		return _IMAGE_OPTIONAL_HEADER64Pointer.cast(address & ~mask);
	}

	public _IMAGE_OPTIONAL_HEADER64Pointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _IMAGE_OPTIONAL_HEADER64.SIZEOF;
	}

	// Implementation methods

	// U32 AddressOfEntryPoint
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_AddressOfEntryPointOffset_", declaredType="U32")
	public UDATA AddressOfEntryPoint() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGE_OPTIONAL_HEADER64._AddressOfEntryPointOffset_));
	}

	// U32 AddressOfEntryPoint
	public UDATAPointer AddressOfEntryPointEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._AddressOfEntryPointOffset_));
	}

	// U32 BaseOfCode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_BaseOfCodeOffset_", declaredType="U32")
	public UDATA BaseOfCode() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGE_OPTIONAL_HEADER64._BaseOfCodeOffset_));
	}

	// U32 BaseOfCode
	public UDATAPointer BaseOfCodeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._BaseOfCodeOffset_));
	}

	// U32 CheckSum
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_CheckSumOffset_", declaredType="U32")
	public UDATA CheckSum() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGE_OPTIONAL_HEADER64._CheckSumOffset_));
	}

	// U32 CheckSum
	public UDATAPointer CheckSumEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._CheckSumOffset_));
	}

	// _IMAGE_DATA_DIRECTORY[] DataDirectory
	public _IMAGE_DATA_DIRECTORYPointer DataDirectoryEA() throws CorruptDataException {
		return _IMAGE_DATA_DIRECTORYPointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._DataDirectoryOffset_));
	}

	// U16 DllCharacteristics
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_DllCharacteristicsOffset_", declaredType="U16")
	public U16 DllCharacteristics() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_OPTIONAL_HEADER64._DllCharacteristicsOffset_));
	}

	// U16 DllCharacteristics
	public U16Pointer DllCharacteristicsEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._DllCharacteristicsOffset_));
	}

	// U32 FileAlignment
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_FileAlignmentOffset_", declaredType="U32")
	public UDATA FileAlignment() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGE_OPTIONAL_HEADER64._FileAlignmentOffset_));
	}

	// U32 FileAlignment
	public UDATAPointer FileAlignmentEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._FileAlignmentOffset_));
	}

	// U64 ImageBase
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ImageBaseOffset_", declaredType="U64")
	public UDATA ImageBase() throws CorruptDataException {
		return new U64(getLongAtOffset(_IMAGE_OPTIONAL_HEADER64._ImageBaseOffset_));
	}

	// U64 ImageBase
	public UDATAPointer ImageBaseEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._ImageBaseOffset_));
	}

	// U32 LoaderFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_LoaderFlagsOffset_", declaredType="U32")
	public UDATA LoaderFlags() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGE_OPTIONAL_HEADER64._LoaderFlagsOffset_));
	}

	// U32 LoaderFlags
	public UDATAPointer LoaderFlagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._LoaderFlagsOffset_));
	}

	// U16 Magic
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MagicOffset_", declaredType="U16")
	public U16 Magic() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_OPTIONAL_HEADER64._MagicOffset_));
	}

	// U16 Magic
	public U16Pointer MagicEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._MagicOffset_));
	}

	// U16 MajorImageVersion
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MajorImageVersionOffset_", declaredType="U16")
	public U16 MajorImageVersion() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_OPTIONAL_HEADER64._MajorImageVersionOffset_));
	}

	// U16 MajorImageVersion
	public U16Pointer MajorImageVersionEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._MajorImageVersionOffset_));
	}

	// U8 MajorLinkerVersion
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MajorLinkerVersionOffset_", declaredType="U8")
	public U8 MajorLinkerVersion() throws CorruptDataException {
		return new U8(getByteAtOffset(_IMAGE_OPTIONAL_HEADER64._MajorLinkerVersionOffset_));
	}

	// U8 MajorLinkerVersion
	public U8Pointer MajorLinkerVersionEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._MajorLinkerVersionOffset_));
	}

	// U16 MajorOperatingSystemVersion
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MajorOperatingSystemVersionOffset_", declaredType="U16")
	public U16 MajorOperatingSystemVersion() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_OPTIONAL_HEADER64._MajorOperatingSystemVersionOffset_));
	}

	// U16 MajorOperatingSystemVersion
	public U16Pointer MajorOperatingSystemVersionEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._MajorOperatingSystemVersionOffset_));
	}

	// U16 MajorSubsystemVersion
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MajorSubsystemVersionOffset_", declaredType="U16")
	public U16 MajorSubsystemVersion() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_OPTIONAL_HEADER64._MajorSubsystemVersionOffset_));
	}

	// U16 MajorSubsystemVersion
	public U16Pointer MajorSubsystemVersionEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._MajorSubsystemVersionOffset_));
	}

	// U16 MinorImageVersion
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MinorImageVersionOffset_", declaredType="U16")
	public U16 MinorImageVersion() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_OPTIONAL_HEADER64._MinorImageVersionOffset_));
	}

	// U16 MinorImageVersion
	public U16Pointer MinorImageVersionEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._MinorImageVersionOffset_));
	}

	// U8 MinorLinkerVersion
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MinorLinkerVersionOffset_", declaredType="U8")
	public U8 MinorLinkerVersion() throws CorruptDataException {
		return new U8(getByteAtOffset(_IMAGE_OPTIONAL_HEADER64._MinorLinkerVersionOffset_));
	}

	// U8 MinorLinkerVersion
	public U8Pointer MinorLinkerVersionEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._MinorLinkerVersionOffset_));
	}

	// U16 MinorOperatingSystemVersion
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MinorOperatingSystemVersionOffset_", declaredType="U16")
	public U16 MinorOperatingSystemVersion() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_OPTIONAL_HEADER64._MinorOperatingSystemVersionOffset_));
	}

	// U16 MinorOperatingSystemVersion
	public U16Pointer MinorOperatingSystemVersionEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._MinorOperatingSystemVersionOffset_));
	}

	// U16 MinorSubsystemVersion
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_MinorSubsystemVersionOffset_", declaredType="U16")
	public U16 MinorSubsystemVersion() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_OPTIONAL_HEADER64._MinorSubsystemVersionOffset_));
	}

	// U16 MinorSubsystemVersion
	public U16Pointer MinorSubsystemVersionEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._MinorSubsystemVersionOffset_));
	}

	// U32 NumberOfRvaAndSizes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_NumberOfRvaAndSizesOffset_", declaredType="U32")
	public UDATA NumberOfRvaAndSizes() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGE_OPTIONAL_HEADER64._NumberOfRvaAndSizesOffset_));
	}

	// U32 NumberOfRvaAndSizes
	public UDATAPointer NumberOfRvaAndSizesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._NumberOfRvaAndSizesOffset_));
	}

	// U32 SectionAlignment
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SectionAlignmentOffset_", declaredType="U32")
	public UDATA SectionAlignment() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGE_OPTIONAL_HEADER64._SectionAlignmentOffset_));
	}

	// U32 SectionAlignment
	public UDATAPointer SectionAlignmentEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._SectionAlignmentOffset_));
	}

	// U32 SizeOfCode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SizeOfCodeOffset_", declaredType="U32")
	public UDATA SizeOfCode() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGE_OPTIONAL_HEADER64._SizeOfCodeOffset_));
	}

	// U32 SizeOfCode
	public UDATAPointer SizeOfCodeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._SizeOfCodeOffset_));
	}

	// U32 SizeOfHeaders
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SizeOfHeadersOffset_", declaredType="U32")
	public UDATA SizeOfHeaders() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGE_OPTIONAL_HEADER64._SizeOfHeadersOffset_));
	}

	// U32 SizeOfHeaders
	public UDATAPointer SizeOfHeadersEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._SizeOfHeadersOffset_));
	}

	// U64 SizeOfHeapCommit
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SizeOfHeapCommitOffset_", declaredType="U64")
	public UDATA SizeOfHeapCommit() throws CorruptDataException {
		return new U64(getLongAtOffset(_IMAGE_OPTIONAL_HEADER64._SizeOfHeapCommitOffset_));
	}

	// U64 SizeOfHeapCommit
	public UDATAPointer SizeOfHeapCommitEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._SizeOfHeapCommitOffset_));
	}

	// U64 SizeOfHeapReserve
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SizeOfHeapReserveOffset_", declaredType="U64")
	public UDATA SizeOfHeapReserve() throws CorruptDataException {
		return new U64(getLongAtOffset(_IMAGE_OPTIONAL_HEADER64._SizeOfHeapReserveOffset_));
	}

	// U64 SizeOfHeapReserve
	public UDATAPointer SizeOfHeapReserveEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._SizeOfHeapReserveOffset_));
	}

	// U32 SizeOfImage
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SizeOfImageOffset_", declaredType="U32")
	public UDATA SizeOfImage() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGE_OPTIONAL_HEADER64._SizeOfImageOffset_));
	}

	// U32 SizeOfImage
	public UDATAPointer SizeOfImageEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._SizeOfImageOffset_));
	}

	// U32 SizeOfInitializedData
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SizeOfInitializedDataOffset_", declaredType="U32")
	public UDATA SizeOfInitializedData() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGE_OPTIONAL_HEADER64._SizeOfInitializedDataOffset_));
	}

	// U32 SizeOfInitializedData
	public UDATAPointer SizeOfInitializedDataEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._SizeOfInitializedDataOffset_));
	}

	// U64 SizeOfStackCommit
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SizeOfStackCommitOffset_", declaredType="U64")
	public UDATA SizeOfStackCommit() throws CorruptDataException {
		return new U64(getLongAtOffset(_IMAGE_OPTIONAL_HEADER64._SizeOfStackCommitOffset_));
	}

	// U64 SizeOfStackCommit
	public UDATAPointer SizeOfStackCommitEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._SizeOfStackCommitOffset_));
	}

	// U64 SizeOfStackReserve
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SizeOfStackReserveOffset_", declaredType="U64")
	public UDATA SizeOfStackReserve() throws CorruptDataException {
		return new U64(getLongAtOffset(_IMAGE_OPTIONAL_HEADER64._SizeOfStackReserveOffset_));
	}

	// U64 SizeOfStackReserve
	public UDATAPointer SizeOfStackReserveEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._SizeOfStackReserveOffset_));
	}

	// U32 SizeOfUninitializedData
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SizeOfUninitializedDataOffset_", declaredType="U32")
	public UDATA SizeOfUninitializedData() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGE_OPTIONAL_HEADER64._SizeOfUninitializedDataOffset_));
	}

	// U32 SizeOfUninitializedData
	public UDATAPointer SizeOfUninitializedDataEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._SizeOfUninitializedDataOffset_));
	}

	// U16 Subsystem
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SubsystemOffset_", declaredType="U16")
	public U16 Subsystem() throws CorruptDataException {
		return new U16(getShortAtOffset(_IMAGE_OPTIONAL_HEADER64._SubsystemOffset_));
	}

	// U16 Subsystem
	public U16Pointer SubsystemEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._SubsystemOffset_));
	}

	// U32 Win32VersionValue
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_Win32VersionValueOffset_", declaredType="U32")
	public UDATA Win32VersionValue() throws CorruptDataException {
		return new U32(getIntAtOffset(_IMAGE_OPTIONAL_HEADER64._Win32VersionValueOffset_));
	}

	// U32 Win32VersionValue
	public UDATAPointer Win32VersionValueEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_IMAGE_OPTIONAL_HEADER64._Win32VersionValueOffset_));
	}

}
