/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _RTL_CRITICAL_SECTIONPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _RTL_CRITICAL_SECTIONPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_RTL_CRITICAL_SECTION.class)
public class _RTL_CRITICAL_SECTIONPointer extends StructurePointer {

	// NULL
	public static final _RTL_CRITICAL_SECTIONPointer NULL = new _RTL_CRITICAL_SECTIONPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _RTL_CRITICAL_SECTIONPointer(long address) {
		super(address);
	}

	public static _RTL_CRITICAL_SECTIONPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _RTL_CRITICAL_SECTIONPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _RTL_CRITICAL_SECTIONPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _RTL_CRITICAL_SECTIONPointer(address);
	}

	public _RTL_CRITICAL_SECTIONPointer add(long count) {
		return _RTL_CRITICAL_SECTIONPointer.cast(address + (_RTL_CRITICAL_SECTION.SIZEOF * count));
	}

	public _RTL_CRITICAL_SECTIONPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _RTL_CRITICAL_SECTIONPointer addOffset(long offset) {
		return _RTL_CRITICAL_SECTIONPointer.cast(address + offset);
	}

	public _RTL_CRITICAL_SECTIONPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _RTL_CRITICAL_SECTIONPointer sub(long count) {
		return _RTL_CRITICAL_SECTIONPointer.cast(address - (_RTL_CRITICAL_SECTION.SIZEOF * count));
	}

	public _RTL_CRITICAL_SECTIONPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _RTL_CRITICAL_SECTIONPointer subOffset(long offset) {
		return _RTL_CRITICAL_SECTIONPointer.cast(address - offset);
	}

	public _RTL_CRITICAL_SECTIONPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _RTL_CRITICAL_SECTIONPointer untag(long mask) {
		return _RTL_CRITICAL_SECTIONPointer.cast(address & ~mask);
	}

	public _RTL_CRITICAL_SECTIONPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _RTL_CRITICAL_SECTION.SIZEOF;
	}

	// Implementation methods

	// _RTL_CRITICAL_SECTION_DEBUG* DebugInfo
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_DebugInfoOffset_", declaredType="_RTL_CRITICAL_SECTION_DEBUG*")
	public _RTL_CRITICAL_SECTION_DEBUGPointer DebugInfo() throws CorruptDataException {
		return _RTL_CRITICAL_SECTION_DEBUGPointer.cast(getPointerAtOffset(_RTL_CRITICAL_SECTION._DebugInfoOffset_));
	}

	// _RTL_CRITICAL_SECTION_DEBUG* DebugInfo
	public PointerPointer DebugInfoEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_RTL_CRITICAL_SECTION._DebugInfoOffset_));
	}

	// I32 LockCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_LockCountOffset_", declaredType="I32")
	public IDATA LockCount() throws CorruptDataException {
		return new I32(getIntAtOffset(_RTL_CRITICAL_SECTION._LockCountOffset_));
	}

	// I32 LockCount
	public IDATAPointer LockCountEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_RTL_CRITICAL_SECTION._LockCountOffset_));
	}

	// void* LockSemaphore
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_LockSemaphoreOffset_", declaredType="void*")
	public VoidPointer LockSemaphore() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_RTL_CRITICAL_SECTION._LockSemaphoreOffset_));
	}

	// void* LockSemaphore
	public PointerPointer LockSemaphoreEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_RTL_CRITICAL_SECTION._LockSemaphoreOffset_));
	}

	// void* OwningThread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_OwningThreadOffset_", declaredType="void*")
	public VoidPointer OwningThread() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_RTL_CRITICAL_SECTION._OwningThreadOffset_));
	}

	// void* OwningThread
	public PointerPointer OwningThreadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_RTL_CRITICAL_SECTION._OwningThreadOffset_));
	}

	// I32 RecursionCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_RecursionCountOffset_", declaredType="I32")
	public IDATA RecursionCount() throws CorruptDataException {
		return new I32(getIntAtOffset(_RTL_CRITICAL_SECTION._RecursionCountOffset_));
	}

	// I32 RecursionCount
	public IDATAPointer RecursionCountEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_RTL_CRITICAL_SECTION._RecursionCountOffset_));
	}

	// U64 SpinCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SpinCountOffset_", declaredType="U64")
	public UDATA SpinCount() throws CorruptDataException {
		return new U64(getLongAtOffset(_RTL_CRITICAL_SECTION._SpinCountOffset_));
	}

	// U64 SpinCount
	public UDATAPointer SpinCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RTL_CRITICAL_SECTION._SpinCountOffset_));
	}

}
