/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _s__RTTIClassHierarchyDescriptorPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _s__RTTIClassHierarchyDescriptorPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_s__RTTIClassHierarchyDescriptor.class)
public class _s__RTTIClassHierarchyDescriptorPointer extends StructurePointer {

	// NULL
	public static final _s__RTTIClassHierarchyDescriptorPointer NULL = new _s__RTTIClassHierarchyDescriptorPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _s__RTTIClassHierarchyDescriptorPointer(long address) {
		super(address);
	}

	public static _s__RTTIClassHierarchyDescriptorPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _s__RTTIClassHierarchyDescriptorPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _s__RTTIClassHierarchyDescriptorPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _s__RTTIClassHierarchyDescriptorPointer(address);
	}

	public _s__RTTIClassHierarchyDescriptorPointer add(long count) {
		return _s__RTTIClassHierarchyDescriptorPointer.cast(address + (_s__RTTIClassHierarchyDescriptor.SIZEOF * count));
	}

	public _s__RTTIClassHierarchyDescriptorPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _s__RTTIClassHierarchyDescriptorPointer addOffset(long offset) {
		return _s__RTTIClassHierarchyDescriptorPointer.cast(address + offset);
	}

	public _s__RTTIClassHierarchyDescriptorPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _s__RTTIClassHierarchyDescriptorPointer sub(long count) {
		return _s__RTTIClassHierarchyDescriptorPointer.cast(address - (_s__RTTIClassHierarchyDescriptor.SIZEOF * count));
	}

	public _s__RTTIClassHierarchyDescriptorPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _s__RTTIClassHierarchyDescriptorPointer subOffset(long offset) {
		return _s__RTTIClassHierarchyDescriptorPointer.cast(address - offset);
	}

	public _s__RTTIClassHierarchyDescriptorPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _s__RTTIClassHierarchyDescriptorPointer untag(long mask) {
		return _s__RTTIClassHierarchyDescriptorPointer.cast(address & ~mask);
	}

	public _s__RTTIClassHierarchyDescriptorPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _s__RTTIClassHierarchyDescriptor.SIZEOF;
	}

	// Implementation methods

	// U32 attributes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_attributesOffset_", declaredType="U32")
	public UDATA attributes() throws CorruptDataException {
		return new U32(getIntAtOffset(_s__RTTIClassHierarchyDescriptor._attributesOffset_));
	}

	// U32 attributes
	public UDATAPointer attributesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_s__RTTIClassHierarchyDescriptor._attributesOffset_));
	}

	// U32 numBaseClasses
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numBaseClassesOffset_", declaredType="U32")
	public UDATA numBaseClasses() throws CorruptDataException {
		return new U32(getIntAtOffset(_s__RTTIClassHierarchyDescriptor._numBaseClassesOffset_));
	}

	// U32 numBaseClasses
	public UDATAPointer numBaseClassesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_s__RTTIClassHierarchyDescriptor._numBaseClassesOffset_));
	}

	// const _s__RTTIBaseClassArray* pBaseClassArray
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pBaseClassArrayOffset_", declaredType="const _s__RTTIBaseClassArray*")
	public _s__RTTIBaseClassArrayPointer pBaseClassArray() throws CorruptDataException {
		return _s__RTTIBaseClassArrayPointer.cast(getPointerAtOffset(_s__RTTIClassHierarchyDescriptor._pBaseClassArrayOffset_));
	}

	// const _s__RTTIBaseClassArray* pBaseClassArray
	public PointerPointer pBaseClassArrayEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_s__RTTIClassHierarchyDescriptor._pBaseClassArrayOffset_));
	}

	// U32 signature
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_signatureOffset_", declaredType="U32")
	public UDATA signature() throws CorruptDataException {
		return new U32(getIntAtOffset(_s__RTTIClassHierarchyDescriptor._signatureOffset_));
	}

	// U32 signature
	public UDATAPointer signatureEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_s__RTTIClassHierarchyDescriptor._signatureOffset_));
	}

}
