/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _tagSTACKFRAME64Pointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _tagSTACKFRAME64Pointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_tagSTACKFRAME64.class)
public class _tagSTACKFRAME64Pointer extends StructurePointer {

	// NULL
	public static final _tagSTACKFRAME64Pointer NULL = new _tagSTACKFRAME64Pointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _tagSTACKFRAME64Pointer(long address) {
		super(address);
	}

	public static _tagSTACKFRAME64Pointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _tagSTACKFRAME64Pointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _tagSTACKFRAME64Pointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _tagSTACKFRAME64Pointer(address);
	}

	public _tagSTACKFRAME64Pointer add(long count) {
		return _tagSTACKFRAME64Pointer.cast(address + (_tagSTACKFRAME64.SIZEOF * count));
	}

	public _tagSTACKFRAME64Pointer add(Scalar count) {
		return add(count.longValue());
	}

	public _tagSTACKFRAME64Pointer addOffset(long offset) {
		return _tagSTACKFRAME64Pointer.cast(address + offset);
	}

	public _tagSTACKFRAME64Pointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _tagSTACKFRAME64Pointer sub(long count) {
		return _tagSTACKFRAME64Pointer.cast(address - (_tagSTACKFRAME64.SIZEOF * count));
	}

	public _tagSTACKFRAME64Pointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _tagSTACKFRAME64Pointer subOffset(long offset) {
		return _tagSTACKFRAME64Pointer.cast(address - offset);
	}

	public _tagSTACKFRAME64Pointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _tagSTACKFRAME64Pointer untag(long mask) {
		return _tagSTACKFRAME64Pointer.cast(address & ~mask);
	}

	public _tagSTACKFRAME64Pointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _tagSTACKFRAME64.SIZEOF;
	}

	// Implementation methods

	// _tagADDRESS64 AddrBStore
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_AddrBStoreOffset_", declaredType="_tagADDRESS64")
	public _tagADDRESS64Pointer AddrBStore() throws CorruptDataException {
		return _tagADDRESS64Pointer.cast(nonNullFieldEA(_tagSTACKFRAME64._AddrBStoreOffset_));
	}

	// _tagADDRESS64 AddrBStore
	public PointerPointer AddrBStoreEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_tagSTACKFRAME64._AddrBStoreOffset_));
	}

	// _tagADDRESS64 AddrFrame
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_AddrFrameOffset_", declaredType="_tagADDRESS64")
	public _tagADDRESS64Pointer AddrFrame() throws CorruptDataException {
		return _tagADDRESS64Pointer.cast(nonNullFieldEA(_tagSTACKFRAME64._AddrFrameOffset_));
	}

	// _tagADDRESS64 AddrFrame
	public PointerPointer AddrFrameEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_tagSTACKFRAME64._AddrFrameOffset_));
	}

	// _tagADDRESS64 AddrPC
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_AddrPCOffset_", declaredType="_tagADDRESS64")
	public _tagADDRESS64Pointer AddrPC() throws CorruptDataException {
		return _tagADDRESS64Pointer.cast(nonNullFieldEA(_tagSTACKFRAME64._AddrPCOffset_));
	}

	// _tagADDRESS64 AddrPC
	public PointerPointer AddrPCEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_tagSTACKFRAME64._AddrPCOffset_));
	}

	// _tagADDRESS64 AddrReturn
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_AddrReturnOffset_", declaredType="_tagADDRESS64")
	public _tagADDRESS64Pointer AddrReturn() throws CorruptDataException {
		return _tagADDRESS64Pointer.cast(nonNullFieldEA(_tagSTACKFRAME64._AddrReturnOffset_));
	}

	// _tagADDRESS64 AddrReturn
	public PointerPointer AddrReturnEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_tagSTACKFRAME64._AddrReturnOffset_));
	}

	// _tagADDRESS64 AddrStack
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_AddrStackOffset_", declaredType="_tagADDRESS64")
	public _tagADDRESS64Pointer AddrStack() throws CorruptDataException {
		return _tagADDRESS64Pointer.cast(nonNullFieldEA(_tagSTACKFRAME64._AddrStackOffset_));
	}

	// _tagADDRESS64 AddrStack
	public PointerPointer AddrStackEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_tagSTACKFRAME64._AddrStackOffset_));
	}

	// I32 Far
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_FarOffset_", declaredType="I32")
	public IDATA Far() throws CorruptDataException {
		return new I32(getIntAtOffset(_tagSTACKFRAME64._FarOffset_));
	}

	// I32 Far
	public IDATAPointer FarEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_tagSTACKFRAME64._FarOffset_));
	}

	// void* FuncTableEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_FuncTableEntryOffset_", declaredType="void*")
	public VoidPointer FuncTableEntry() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_tagSTACKFRAME64._FuncTableEntryOffset_));
	}

	// void* FuncTableEntry
	public PointerPointer FuncTableEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_tagSTACKFRAME64._FuncTableEntryOffset_));
	}

	// _KDHELP64 KdHelp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_KdHelpOffset_", declaredType="_KDHELP64")
	public _KDHELP64Pointer KdHelp() throws CorruptDataException {
		return _KDHELP64Pointer.cast(nonNullFieldEA(_tagSTACKFRAME64._KdHelpOffset_));
	}

	// _KDHELP64 KdHelp
	public PointerPointer KdHelpEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_tagSTACKFRAME64._KdHelpOffset_));
	}

	// U64[] Params
	public UDATAPointer ParamsEA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(_tagSTACKFRAME64._ParamsOffset_));
	}

	// U64[] Reserved
	public UDATAPointer ReservedEA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(_tagSTACKFRAME64._ReservedOffset_));
	}

	// I32 Virtual
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_VirtualOffset_", declaredType="I32")
	public IDATA Virtual() throws CorruptDataException {
		return new I32(getIntAtOffset(_tagSTACKFRAME64._VirtualOffset_));
	}

	// I32 Virtual
	public IDATAPointer VirtualEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_tagSTACKFRAME64._VirtualOffset_));
	}

}
