/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: lconvPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the lconvPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=lconv.class)
public class lconvPointer extends StructurePointer {

	// NULL
	public static final lconvPointer NULL = new lconvPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected lconvPointer(long address) {
		super(address);
	}

	public static lconvPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static lconvPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static lconvPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new lconvPointer(address);
	}

	public lconvPointer add(long count) {
		return lconvPointer.cast(address + (lconv.SIZEOF * count));
	}

	public lconvPointer add(Scalar count) {
		return add(count.longValue());
	}

	public lconvPointer addOffset(long offset) {
		return lconvPointer.cast(address + offset);
	}

	public lconvPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public lconvPointer sub(long count) {
		return lconvPointer.cast(address - (lconv.SIZEOF * count));
	}

	public lconvPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public lconvPointer subOffset(long offset) {
		return lconvPointer.cast(address - offset);
	}

	public lconvPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public lconvPointer untag(long mask) {
		return lconvPointer.cast(address & ~mask);
	}

	public lconvPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return lconv.SIZEOF;
	}

	// Implementation methods

	// U16* _W_currency_symbol
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__W_currency_symbolOffset_", declaredType="U16*")
	public U16Pointer _W_currency_symbol() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(lconv.__W_currency_symbolOffset_));
	}

	// U16* _W_currency_symbol
	public PointerPointer _W_currency_symbolEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lconv.__W_currency_symbolOffset_));
	}

	// U16* _W_decimal_point
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__W_decimal_pointOffset_", declaredType="U16*")
	public U16Pointer _W_decimal_point() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(lconv.__W_decimal_pointOffset_));
	}

	// U16* _W_decimal_point
	public PointerPointer _W_decimal_pointEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lconv.__W_decimal_pointOffset_));
	}

	// U16* _W_int_curr_symbol
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__W_int_curr_symbolOffset_", declaredType="U16*")
	public U16Pointer _W_int_curr_symbol() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(lconv.__W_int_curr_symbolOffset_));
	}

	// U16* _W_int_curr_symbol
	public PointerPointer _W_int_curr_symbolEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lconv.__W_int_curr_symbolOffset_));
	}

	// U16* _W_mon_decimal_point
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__W_mon_decimal_pointOffset_", declaredType="U16*")
	public U16Pointer _W_mon_decimal_point() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(lconv.__W_mon_decimal_pointOffset_));
	}

	// U16* _W_mon_decimal_point
	public PointerPointer _W_mon_decimal_pointEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lconv.__W_mon_decimal_pointOffset_));
	}

	// U16* _W_mon_thousands_sep
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__W_mon_thousands_sepOffset_", declaredType="U16*")
	public U16Pointer _W_mon_thousands_sep() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(lconv.__W_mon_thousands_sepOffset_));
	}

	// U16* _W_mon_thousands_sep
	public PointerPointer _W_mon_thousands_sepEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lconv.__W_mon_thousands_sepOffset_));
	}

	// U16* _W_negative_sign
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__W_negative_signOffset_", declaredType="U16*")
	public U16Pointer _W_negative_sign() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(lconv.__W_negative_signOffset_));
	}

	// U16* _W_negative_sign
	public PointerPointer _W_negative_signEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lconv.__W_negative_signOffset_));
	}

	// U16* _W_positive_sign
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__W_positive_signOffset_", declaredType="U16*")
	public U16Pointer _W_positive_sign() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(lconv.__W_positive_signOffset_));
	}

	// U16* _W_positive_sign
	public PointerPointer _W_positive_signEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lconv.__W_positive_signOffset_));
	}

	// U16* _W_thousands_sep
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__W_thousands_sepOffset_", declaredType="U16*")
	public U16Pointer _W_thousands_sep() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(lconv.__W_thousands_sepOffset_));
	}

	// U16* _W_thousands_sep
	public PointerPointer _W_thousands_sepEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lconv.__W_thousands_sepOffset_));
	}

	// U8* currency_symbol
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_currency_symbolOffset_", declaredType="U8*")
	public U8Pointer currency_symbol() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(lconv._currency_symbolOffset_));
	}

	// U8* currency_symbol
	public PointerPointer currency_symbolEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lconv._currency_symbolOffset_));
	}

	// U8* decimal_point
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_decimal_pointOffset_", declaredType="U8*")
	public U8Pointer decimal_point() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(lconv._decimal_pointOffset_));
	}

	// U8* decimal_point
	public PointerPointer decimal_pointEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lconv._decimal_pointOffset_));
	}

	// U8 frac_digits
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_frac_digitsOffset_", declaredType="U8")
	public U8 frac_digits() throws CorruptDataException {
		return new U8(getByteAtOffset(lconv._frac_digitsOffset_));
	}

	// U8 frac_digits
	public U8Pointer frac_digitsEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(lconv._frac_digitsOffset_));
	}

	// U8* grouping
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_groupingOffset_", declaredType="U8*")
	public U8Pointer grouping() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(lconv._groupingOffset_));
	}

	// U8* grouping
	public PointerPointer groupingEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lconv._groupingOffset_));
	}

	// U8* int_curr_symbol
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_int_curr_symbolOffset_", declaredType="U8*")
	public U8Pointer int_curr_symbol() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(lconv._int_curr_symbolOffset_));
	}

	// U8* int_curr_symbol
	public PointerPointer int_curr_symbolEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lconv._int_curr_symbolOffset_));
	}

	// U8 int_frac_digits
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_int_frac_digitsOffset_", declaredType="U8")
	public U8 int_frac_digits() throws CorruptDataException {
		return new U8(getByteAtOffset(lconv._int_frac_digitsOffset_));
	}

	// U8 int_frac_digits
	public U8Pointer int_frac_digitsEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(lconv._int_frac_digitsOffset_));
	}

	// U8* mon_decimal_point
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mon_decimal_pointOffset_", declaredType="U8*")
	public U8Pointer mon_decimal_point() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(lconv._mon_decimal_pointOffset_));
	}

	// U8* mon_decimal_point
	public PointerPointer mon_decimal_pointEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lconv._mon_decimal_pointOffset_));
	}

	// U8* mon_grouping
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mon_groupingOffset_", declaredType="U8*")
	public U8Pointer mon_grouping() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(lconv._mon_groupingOffset_));
	}

	// U8* mon_grouping
	public PointerPointer mon_groupingEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lconv._mon_groupingOffset_));
	}

	// U8* mon_thousands_sep
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mon_thousands_sepOffset_", declaredType="U8*")
	public U8Pointer mon_thousands_sep() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(lconv._mon_thousands_sepOffset_));
	}

	// U8* mon_thousands_sep
	public PointerPointer mon_thousands_sepEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lconv._mon_thousands_sepOffset_));
	}

	// U8 n_cs_precedes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_n_cs_precedesOffset_", declaredType="U8")
	public U8 n_cs_precedes() throws CorruptDataException {
		return new U8(getByteAtOffset(lconv._n_cs_precedesOffset_));
	}

	// U8 n_cs_precedes
	public U8Pointer n_cs_precedesEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(lconv._n_cs_precedesOffset_));
	}

	// U8 n_sep_by_space
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_n_sep_by_spaceOffset_", declaredType="U8")
	public U8 n_sep_by_space() throws CorruptDataException {
		return new U8(getByteAtOffset(lconv._n_sep_by_spaceOffset_));
	}

	// U8 n_sep_by_space
	public U8Pointer n_sep_by_spaceEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(lconv._n_sep_by_spaceOffset_));
	}

	// U8 n_sign_posn
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_n_sign_posnOffset_", declaredType="U8")
	public U8 n_sign_posn() throws CorruptDataException {
		return new U8(getByteAtOffset(lconv._n_sign_posnOffset_));
	}

	// U8 n_sign_posn
	public U8Pointer n_sign_posnEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(lconv._n_sign_posnOffset_));
	}

	// U8* negative_sign
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_negative_signOffset_", declaredType="U8*")
	public U8Pointer negative_sign() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(lconv._negative_signOffset_));
	}

	// U8* negative_sign
	public PointerPointer negative_signEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lconv._negative_signOffset_));
	}

	// U8 p_cs_precedes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_cs_precedesOffset_", declaredType="U8")
	public U8 p_cs_precedes() throws CorruptDataException {
		return new U8(getByteAtOffset(lconv._p_cs_precedesOffset_));
	}

	// U8 p_cs_precedes
	public U8Pointer p_cs_precedesEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(lconv._p_cs_precedesOffset_));
	}

	// U8 p_sep_by_space
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_sep_by_spaceOffset_", declaredType="U8")
	public U8 p_sep_by_space() throws CorruptDataException {
		return new U8(getByteAtOffset(lconv._p_sep_by_spaceOffset_));
	}

	// U8 p_sep_by_space
	public U8Pointer p_sep_by_spaceEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(lconv._p_sep_by_spaceOffset_));
	}

	// U8 p_sign_posn
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_p_sign_posnOffset_", declaredType="U8")
	public U8 p_sign_posn() throws CorruptDataException {
		return new U8(getByteAtOffset(lconv._p_sign_posnOffset_));
	}

	// U8 p_sign_posn
	public U8Pointer p_sign_posnEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(lconv._p_sign_posnOffset_));
	}

	// U8* positive_sign
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_positive_signOffset_", declaredType="U8*")
	public U8Pointer positive_sign() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(lconv._positive_signOffset_));
	}

	// U8* positive_sign
	public PointerPointer positive_signEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lconv._positive_signOffset_));
	}

	// U8* thousands_sep
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_thousands_sepOffset_", declaredType="U8*")
	public U8Pointer thousands_sep() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(lconv._thousands_sepOffset_));
	}

	// U8* thousands_sep
	public PointerPointer thousands_sepEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(lconv._thousands_sepOffset_));
	}

}
