/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: _MINIDUMP_CALLBACK_INPUT
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class _MINIDUMP_CALLBACK_INPUT {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _CallbackTypeOffset_;
	public static final int _IncludeModuleOffset_;
	public static final int _IncludeThreadOffset_;
	public static final int _IoOffset_;
	public static final int _ModuleOffset_;
	public static final int _ProcessHandleOffset_;
	public static final int _ProcessIdOffset_;
	public static final int _ReadMemoryFailureOffset_;
	public static final int _SecondaryFlagsOffset_;
	public static final int _StatusOffset_;
	public static final int _ThreadOffset_;
	public static final int _ThreadExOffset_;
	public static final int _VmPostReadOffset_;
	public static final int _VmPreReadOffset_;
	public static final int _VmQueryOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_CallbackTypeOffset_ = 0;
		_IncludeModuleOffset_ = 0;
		_IncludeThreadOffset_ = 0;
		_IoOffset_ = 0;
		_ModuleOffset_ = 0;
		_ProcessHandleOffset_ = 0;
		_ProcessIdOffset_ = 0;
		_ReadMemoryFailureOffset_ = 0;
		_SecondaryFlagsOffset_ = 0;
		_StatusOffset_ = 0;
		_ThreadOffset_ = 0;
		_ThreadExOffset_ = 0;
		_VmPostReadOffset_ = 0;
		_VmPreReadOffset_ = 0;
		_VmQueryOffset_ = 0;
	}

}
