/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: _RS5_IMAGE_LOAD_CONFIG_DIRECTORY64
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class _RS5_IMAGE_LOAD_CONFIG_DIRECTORY64 {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _CHPEMetadataPointerOffset_;
	public static final int _CSDVersionOffset_;
	public static final int _CastGuardOsDeterminedFailureModeOffset_;
	public static final int _CodeIntegrityOffset_;
	public static final int _CriticalSectionDefaultTimeoutOffset_;
	public static final int _DeCommitFreeBlockThresholdOffset_;
	public static final int _DeCommitTotalFreeThresholdOffset_;
	public static final int _DependentLoadFlagsOffset_;
	public static final int _DynamicValueRelocTableOffset_;
	public static final int _DynamicValueRelocTableOffsetOffset_;
	public static final int _DynamicValueRelocTableSectionOffset_;
	public static final int _EditListOffset_;
	public static final int _EnclaveConfigurationPointerOffset_;
	public static final int _GlobalFlagsClearOffset_;
	public static final int _GlobalFlagsSetOffset_;
	public static final int _GuardAddressTakenIatEntryCountOffset_;
	public static final int _GuardAddressTakenIatEntryTableOffset_;
	public static final int _GuardCFCheckFunctionPointerOffset_;
	public static final int _GuardCFDispatchFunctionPointerOffset_;
	public static final int _GuardCFFunctionCountOffset_;
	public static final int _GuardCFFunctionTableOffset_;
	public static final int _GuardEHContinuationCountOffset_;
	public static final int _GuardEHContinuationTableOffset_;
	public static final int _GuardFlagsOffset_;
	public static final int _GuardLongJumpTargetCountOffset_;
	public static final int _GuardLongJumpTargetTableOffset_;
	public static final int _GuardMemcpyFunctionPointerOffset_;
	public static final int _GuardRFFailureRoutineOffset_;
	public static final int _GuardRFFailureRoutineFunctionPointerOffset_;
	public static final int _GuardRFVerifyStackPointerFunctionPointerOffset_;
	public static final int _GuardXFGCheckFunctionPointerOffset_;
	public static final int _GuardXFGDispatchFunctionPointerOffset_;
	public static final int _GuardXFGTableDispatchFunctionPointerOffset_;
	public static final int _HotPatchTableOffsetOffset_;
	public static final int _LockPrefixTableOffset_;
	public static final int _MajorVersionOffset_;
	public static final int _MaximumAllocationSizeOffset_;
	public static final int _MinorVersionOffset_;
	public static final int _ProcessAffinityMaskOffset_;
	public static final int _ProcessHeapFlagsOffset_;
	public static final int _Reserved2Offset_;
	public static final int _Reserved3Offset_;
	public static final int _SEHandlerCountOffset_;
	public static final int _SEHandlerTableOffset_;
	public static final int _SecurityCookieOffset_;
	public static final int _SizeOffset_;
	public static final int _TimeDateStampOffset_;
	public static final int _VirtualMemoryThresholdOffset_;
	public static final int _VolatileMetadataPointerOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_CHPEMetadataPointerOffset_ = 0;
		_CSDVersionOffset_ = 0;
		_CastGuardOsDeterminedFailureModeOffset_ = 0;
		_CodeIntegrityOffset_ = 0;
		_CriticalSectionDefaultTimeoutOffset_ = 0;
		_DeCommitFreeBlockThresholdOffset_ = 0;
		_DeCommitTotalFreeThresholdOffset_ = 0;
		_DependentLoadFlagsOffset_ = 0;
		_DynamicValueRelocTableOffset_ = 0;
		_DynamicValueRelocTableOffsetOffset_ = 0;
		_DynamicValueRelocTableSectionOffset_ = 0;
		_EditListOffset_ = 0;
		_EnclaveConfigurationPointerOffset_ = 0;
		_GlobalFlagsClearOffset_ = 0;
		_GlobalFlagsSetOffset_ = 0;
		_GuardAddressTakenIatEntryCountOffset_ = 0;
		_GuardAddressTakenIatEntryTableOffset_ = 0;
		_GuardCFCheckFunctionPointerOffset_ = 0;
		_GuardCFDispatchFunctionPointerOffset_ = 0;
		_GuardCFFunctionCountOffset_ = 0;
		_GuardCFFunctionTableOffset_ = 0;
		_GuardEHContinuationCountOffset_ = 0;
		_GuardEHContinuationTableOffset_ = 0;
		_GuardFlagsOffset_ = 0;
		_GuardLongJumpTargetCountOffset_ = 0;
		_GuardLongJumpTargetTableOffset_ = 0;
		_GuardMemcpyFunctionPointerOffset_ = 0;
		_GuardRFFailureRoutineOffset_ = 0;
		_GuardRFFailureRoutineFunctionPointerOffset_ = 0;
		_GuardRFVerifyStackPointerFunctionPointerOffset_ = 0;
		_GuardXFGCheckFunctionPointerOffset_ = 0;
		_GuardXFGDispatchFunctionPointerOffset_ = 0;
		_GuardXFGTableDispatchFunctionPointerOffset_ = 0;
		_HotPatchTableOffsetOffset_ = 0;
		_LockPrefixTableOffset_ = 0;
		_MajorVersionOffset_ = 0;
		_MaximumAllocationSizeOffset_ = 0;
		_MinorVersionOffset_ = 0;
		_ProcessAffinityMaskOffset_ = 0;
		_ProcessHeapFlagsOffset_ = 0;
		_Reserved2Offset_ = 0;
		_Reserved3Offset_ = 0;
		_SEHandlerCountOffset_ = 0;
		_SEHandlerTableOffset_ = 0;
		_SecurityCookieOffset_ = 0;
		_SizeOffset_ = 0;
		_TimeDateStampOffset_ = 0;
		_VirtualMemoryThresholdOffset_ = 0;
		_VolatileMetadataPointerOffset_ = 0;
	}

}
