/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9ZipDirEntryPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9ZipDirEntryPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9ZipDirEntry.class)
public class J9ZipDirEntryPointer extends StructurePointer {

	// NULL
	public static final J9ZipDirEntryPointer NULL = new J9ZipDirEntryPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9ZipDirEntryPointer(long address) {
		super(address);
	}

	public static J9ZipDirEntryPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9ZipDirEntryPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9ZipDirEntryPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new J9ZipDirEntryPointer(address);
	}

	public J9ZipDirEntryPointer add(long count) {
		return J9ZipDirEntryPointer.cast(address + (J9ZipDirEntry.SIZEOF * count));
	}

	public J9ZipDirEntryPointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9ZipDirEntryPointer addOffset(long offset) {
		return J9ZipDirEntryPointer.cast(address + offset);
	}

	public J9ZipDirEntryPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9ZipDirEntryPointer sub(long count) {
		return J9ZipDirEntryPointer.cast(address - (J9ZipDirEntry.SIZEOF * count));
	}

	public J9ZipDirEntryPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9ZipDirEntryPointer subOffset(long offset) {
		return J9ZipDirEntryPointer.cast(address - offset);
	}

	public J9ZipDirEntryPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9ZipDirEntryPointer untag(long mask) {
		return J9ZipDirEntryPointer.cast(address & ~mask);
	}

	public J9ZipDirEntryPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9ZipDirEntry.SIZEOF;
	}

	// Implementation methods

	// I64 dirList
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dirListOffset_", declaredType="I64")
	public IDATA dirList() throws CorruptDataException {
		return new I64(getLongAtOffset(J9ZipDirEntry._dirListOffset_));
	}

	// I64 dirList
	public IDATAPointer dirListEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(J9ZipDirEntry._dirListOffset_));
	}

	// I64 fileList
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fileListOffset_", declaredType="I64")
	public IDATA fileList() throws CorruptDataException {
		return new I64(getLongAtOffset(J9ZipDirEntry._fileListOffset_));
	}

	// I64 fileList
	public IDATAPointer fileListEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(J9ZipDirEntry._fileListOffset_));
	}

	// I64 next
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nextOffset_", declaredType="I64")
	public IDATA next() throws CorruptDataException {
		return new I64(getLongAtOffset(J9ZipDirEntry._nextOffset_));
	}

	// I64 next
	public IDATAPointer nextEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(J9ZipDirEntry._nextOffset_));
	}

	// U64 zipFileOffset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_zipFileOffsetOffset_", declaredType="U64")
	public UDATA zipFileOffset() throws CorruptDataException {
		return new U64(getLongAtOffset(J9ZipDirEntry._zipFileOffsetOffset_));
	}

	// U64 zipFileOffset
	public UDATAPointer zipFileOffsetEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9ZipDirEntry._zipFileOffsetOffset_));
	}

}
