/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: RasTriggerMethodRulePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the RasTriggerMethodRulePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=RasTriggerMethodRule.class)
public class RasTriggerMethodRulePointer extends StructurePointer {

	// NULL
	public static final RasTriggerMethodRulePointer NULL = new RasTriggerMethodRulePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected RasTriggerMethodRulePointer(long address) {
		super(address);
	}

	public static RasTriggerMethodRulePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static RasTriggerMethodRulePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static RasTriggerMethodRulePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new RasTriggerMethodRulePointer(address);
	}

	public RasTriggerMethodRulePointer add(long count) {
		return RasTriggerMethodRulePointer.cast(address + (RasTriggerMethodRule.SIZEOF * count));
	}

	public RasTriggerMethodRulePointer add(Scalar count) {
		return add(count.longValue());
	}

	public RasTriggerMethodRulePointer addOffset(long offset) {
		return RasTriggerMethodRulePointer.cast(address + offset);
	}

	public RasTriggerMethodRulePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public RasTriggerMethodRulePointer sub(long count) {
		return RasTriggerMethodRulePointer.cast(address - (RasTriggerMethodRule.SIZEOF * count));
	}

	public RasTriggerMethodRulePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public RasTriggerMethodRulePointer subOffset(long offset) {
		return RasTriggerMethodRulePointer.cast(address - offset);
	}

	public RasTriggerMethodRulePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public RasTriggerMethodRulePointer untag(long mask) {
		return RasTriggerMethodRulePointer.cast(address & ~mask);
	}

	public RasTriggerMethodRulePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return RasTriggerMethodRule.SIZEOF;
	}

	// Implementation methods

	// U32 delay
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_delayOffset_", declaredType="U32")
	public UDATA delay() throws CorruptDataException {
		return new U32(getIntAtOffset(RasTriggerMethodRule._delayOffset_));
	}

	// U32 delay
	public UDATAPointer delayEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(RasTriggerMethodRule._delayOffset_));
	}

	// const RasTriggerAction* entryAction
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_entryActionOffset_", declaredType="const RasTriggerAction*")
	public RasTriggerActionPointer entryAction() throws CorruptDataException {
		return RasTriggerActionPointer.cast(getPointerAtOffset(RasTriggerMethodRule._entryActionOffset_));
	}

	// const RasTriggerAction* entryAction
	public PointerPointer entryActionEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(RasTriggerMethodRule._entryActionOffset_));
	}

	// const RasTriggerAction* exitAction
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_exitActionOffset_", declaredType="const RasTriggerAction*")
	public RasTriggerActionPointer exitAction() throws CorruptDataException {
		return RasTriggerActionPointer.cast(getPointerAtOffset(RasTriggerMethodRule._exitActionOffset_));
	}

	// const RasTriggerAction* exitAction
	public PointerPointer exitActionEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(RasTriggerMethodRule._exitActionOffset_));
	}

	// I32 match
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_matchOffset_", declaredType="I32")
	public IDATA match() throws CorruptDataException {
		return new I32(getIntAtOffset(RasTriggerMethodRule._matchOffset_));
	}

	// I32 match
	public IDATAPointer matchEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(RasTriggerMethodRule._matchOffset_));
	}

	// RasMethodTable* methodTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_methodTableOffset_", declaredType="RasMethodTable*")
	public RasMethodTablePointer methodTable() throws CorruptDataException {
		return RasMethodTablePointer.cast(getPointerAtOffset(RasTriggerMethodRule._methodTableOffset_));
	}

	// RasMethodTable* methodTable
	public PointerPointer methodTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(RasTriggerMethodRule._methodTableOffset_));
	}

	// RasTriggerMethodRule* next
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nextOffset_", declaredType="RasTriggerMethodRule*")
	public RasTriggerMethodRulePointer next() throws CorruptDataException {
		return RasTriggerMethodRulePointer.cast(getPointerAtOffset(RasTriggerMethodRule._nextOffset_));
	}

	// RasTriggerMethodRule* next
	public PointerPointer nextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(RasTriggerMethodRule._nextOffset_));
	}

	// RasTriggeredMethodBlock* tmbChain
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tmbChainOffset_", declaredType="RasTriggeredMethodBlock*")
	public RasTriggeredMethodBlockPointer tmbChain() throws CorruptDataException {
		return RasTriggeredMethodBlockPointer.cast(getPointerAtOffset(RasTriggerMethodRule._tmbChainOffset_));
	}

	// RasTriggeredMethodBlock* tmbChain
	public PointerPointer tmbChainEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(RasTriggerMethodRule._tmbChainOffset_));
	}

}
