/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _EXCEPTION_RECORDPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _EXCEPTION_RECORDPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_EXCEPTION_RECORD.class)
public class _EXCEPTION_RECORDPointer extends StructurePointer {

	// NULL
	public static final _EXCEPTION_RECORDPointer NULL = new _EXCEPTION_RECORDPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _EXCEPTION_RECORDPointer(long address) {
		super(address);
	}

	public static _EXCEPTION_RECORDPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _EXCEPTION_RECORDPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _EXCEPTION_RECORDPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _EXCEPTION_RECORDPointer(address);
	}

	public _EXCEPTION_RECORDPointer add(long count) {
		return _EXCEPTION_RECORDPointer.cast(address + (_EXCEPTION_RECORD.SIZEOF * count));
	}

	public _EXCEPTION_RECORDPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _EXCEPTION_RECORDPointer addOffset(long offset) {
		return _EXCEPTION_RECORDPointer.cast(address + offset);
	}

	public _EXCEPTION_RECORDPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _EXCEPTION_RECORDPointer sub(long count) {
		return _EXCEPTION_RECORDPointer.cast(address - (_EXCEPTION_RECORD.SIZEOF * count));
	}

	public _EXCEPTION_RECORDPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _EXCEPTION_RECORDPointer subOffset(long offset) {
		return _EXCEPTION_RECORDPointer.cast(address - offset);
	}

	public _EXCEPTION_RECORDPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _EXCEPTION_RECORDPointer untag(long mask) {
		return _EXCEPTION_RECORDPointer.cast(address & ~mask);
	}

	public _EXCEPTION_RECORDPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _EXCEPTION_RECORD.SIZEOF;
	}

	// Implementation methods

	// void* ExceptionAddress
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ExceptionAddressOffset_", declaredType="void*")
	public VoidPointer ExceptionAddress() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_EXCEPTION_RECORD._ExceptionAddressOffset_));
	}

	// void* ExceptionAddress
	public PointerPointer ExceptionAddressEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_EXCEPTION_RECORD._ExceptionAddressOffset_));
	}

	// U32 ExceptionCode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ExceptionCodeOffset_", declaredType="U32")
	public UDATA ExceptionCode() throws CorruptDataException {
		return new U32(getIntAtOffset(_EXCEPTION_RECORD._ExceptionCodeOffset_));
	}

	// U32 ExceptionCode
	public UDATAPointer ExceptionCodeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_EXCEPTION_RECORD._ExceptionCodeOffset_));
	}

	// U32 ExceptionFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ExceptionFlagsOffset_", declaredType="U32")
	public UDATA ExceptionFlags() throws CorruptDataException {
		return new U32(getIntAtOffset(_EXCEPTION_RECORD._ExceptionFlagsOffset_));
	}

	// U32 ExceptionFlags
	public UDATAPointer ExceptionFlagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_EXCEPTION_RECORD._ExceptionFlagsOffset_));
	}

	// U64[] ExceptionInformation
	public UDATAPointer ExceptionInformationEA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(_EXCEPTION_RECORD._ExceptionInformationOffset_));
	}

	// _EXCEPTION_RECORD* ExceptionRecord
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ExceptionRecordOffset_", declaredType="_EXCEPTION_RECORD*")
	public _EXCEPTION_RECORDPointer ExceptionRecord() throws CorruptDataException {
		return _EXCEPTION_RECORDPointer.cast(getPointerAtOffset(_EXCEPTION_RECORD._ExceptionRecordOffset_));
	}

	// _EXCEPTION_RECORD* ExceptionRecord
	public PointerPointer ExceptionRecordEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_EXCEPTION_RECORD._ExceptionRecordOffset_));
	}

	// U32 NumberParameters
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_NumberParametersOffset_", declaredType="U32")
	public UDATA NumberParameters() throws CorruptDataException {
		return new U32(getIntAtOffset(_EXCEPTION_RECORD._NumberParametersOffset_));
	}

	// U32 NumberParameters
	public UDATAPointer NumberParametersEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_EXCEPTION_RECORD._NumberParametersOffset_));
	}

}
