/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _RTL_CRITICAL_SECTION_DEBUGPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _RTL_CRITICAL_SECTION_DEBUGPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_RTL_CRITICAL_SECTION_DEBUG.class)
public class _RTL_CRITICAL_SECTION_DEBUGPointer extends StructurePointer {

	// NULL
	public static final _RTL_CRITICAL_SECTION_DEBUGPointer NULL = new _RTL_CRITICAL_SECTION_DEBUGPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _RTL_CRITICAL_SECTION_DEBUGPointer(long address) {
		super(address);
	}

	public static _RTL_CRITICAL_SECTION_DEBUGPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _RTL_CRITICAL_SECTION_DEBUGPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _RTL_CRITICAL_SECTION_DEBUGPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _RTL_CRITICAL_SECTION_DEBUGPointer(address);
	}

	public _RTL_CRITICAL_SECTION_DEBUGPointer add(long count) {
		return _RTL_CRITICAL_SECTION_DEBUGPointer.cast(address + (_RTL_CRITICAL_SECTION_DEBUG.SIZEOF * count));
	}

	public _RTL_CRITICAL_SECTION_DEBUGPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _RTL_CRITICAL_SECTION_DEBUGPointer addOffset(long offset) {
		return _RTL_CRITICAL_SECTION_DEBUGPointer.cast(address + offset);
	}

	public _RTL_CRITICAL_SECTION_DEBUGPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _RTL_CRITICAL_SECTION_DEBUGPointer sub(long count) {
		return _RTL_CRITICAL_SECTION_DEBUGPointer.cast(address - (_RTL_CRITICAL_SECTION_DEBUG.SIZEOF * count));
	}

	public _RTL_CRITICAL_SECTION_DEBUGPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _RTL_CRITICAL_SECTION_DEBUGPointer subOffset(long offset) {
		return _RTL_CRITICAL_SECTION_DEBUGPointer.cast(address - offset);
	}

	public _RTL_CRITICAL_SECTION_DEBUGPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _RTL_CRITICAL_SECTION_DEBUGPointer untag(long mask) {
		return _RTL_CRITICAL_SECTION_DEBUGPointer.cast(address & ~mask);
	}

	public _RTL_CRITICAL_SECTION_DEBUGPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _RTL_CRITICAL_SECTION_DEBUG.SIZEOF;
	}

	// Implementation methods

	// U32 ContentionCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ContentionCountOffset_", declaredType="U32")
	public UDATA ContentionCount() throws CorruptDataException {
		return new U32(getIntAtOffset(_RTL_CRITICAL_SECTION_DEBUG._ContentionCountOffset_));
	}

	// U32 ContentionCount
	public UDATAPointer ContentionCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RTL_CRITICAL_SECTION_DEBUG._ContentionCountOffset_));
	}

	// U16 CreatorBackTraceIndex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_CreatorBackTraceIndexOffset_", declaredType="U16")
	public U16 CreatorBackTraceIndex() throws CorruptDataException {
		return new U16(getShortAtOffset(_RTL_CRITICAL_SECTION_DEBUG._CreatorBackTraceIndexOffset_));
	}

	// U16 CreatorBackTraceIndex
	public U16Pointer CreatorBackTraceIndexEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_RTL_CRITICAL_SECTION_DEBUG._CreatorBackTraceIndexOffset_));
	}

	// U16 CreatorBackTraceIndexHigh
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_CreatorBackTraceIndexHighOffset_", declaredType="U16")
	public U16 CreatorBackTraceIndexHigh() throws CorruptDataException {
		return new U16(getShortAtOffset(_RTL_CRITICAL_SECTION_DEBUG._CreatorBackTraceIndexHighOffset_));
	}

	// U16 CreatorBackTraceIndexHigh
	public U16Pointer CreatorBackTraceIndexHighEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_RTL_CRITICAL_SECTION_DEBUG._CreatorBackTraceIndexHighOffset_));
	}

	// _RTL_CRITICAL_SECTION* CriticalSection
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_CriticalSectionOffset_", declaredType="_RTL_CRITICAL_SECTION*")
	public _RTL_CRITICAL_SECTIONPointer CriticalSection() throws CorruptDataException {
		return _RTL_CRITICAL_SECTIONPointer.cast(getPointerAtOffset(_RTL_CRITICAL_SECTION_DEBUG._CriticalSectionOffset_));
	}

	// _RTL_CRITICAL_SECTION* CriticalSection
	public PointerPointer CriticalSectionEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_RTL_CRITICAL_SECTION_DEBUG._CriticalSectionOffset_));
	}

	// U32 EntryCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_EntryCountOffset_", declaredType="U32")
	public UDATA EntryCount() throws CorruptDataException {
		return new U32(getIntAtOffset(_RTL_CRITICAL_SECTION_DEBUG._EntryCountOffset_));
	}

	// U32 EntryCount
	public UDATAPointer EntryCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RTL_CRITICAL_SECTION_DEBUG._EntryCountOffset_));
	}

	// U32 Flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_FlagsOffset_", declaredType="U32")
	public UDATA Flags() throws CorruptDataException {
		return new U32(getIntAtOffset(_RTL_CRITICAL_SECTION_DEBUG._FlagsOffset_));
	}

	// U32 Flags
	public UDATAPointer FlagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_RTL_CRITICAL_SECTION_DEBUG._FlagsOffset_));
	}

	// _LIST_ENTRY ProcessLocksList
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ProcessLocksListOffset_", declaredType="_LIST_ENTRY")
	public _LIST_ENTRYPointer ProcessLocksList() throws CorruptDataException {
		return _LIST_ENTRYPointer.cast(nonNullFieldEA(_RTL_CRITICAL_SECTION_DEBUG._ProcessLocksListOffset_));
	}

	// _LIST_ENTRY ProcessLocksList
	public PointerPointer ProcessLocksListEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_RTL_CRITICAL_SECTION_DEBUG._ProcessLocksListOffset_));
	}

	// U16 SpareWORD
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_SpareWORDOffset_", declaredType="U16")
	public U16 SpareWORD() throws CorruptDataException {
		return new U16(getShortAtOffset(_RTL_CRITICAL_SECTION_DEBUG._SpareWORDOffset_));
	}

	// U16 SpareWORD
	public U16Pointer SpareWORDEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_RTL_CRITICAL_SECTION_DEBUG._SpareWORDOffset_));
	}

	// U16 Type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_TypeOffset_", declaredType="U16")
	public U16 Type() throws CorruptDataException {
		return new U16(getShortAtOffset(_RTL_CRITICAL_SECTION_DEBUG._TypeOffset_));
	}

	// U16 Type
	public U16Pointer TypeEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_RTL_CRITICAL_SECTION_DEBUG._TypeOffset_));
	}

}
